/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.decoder;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import netbank.firm.base.MD5Util;
import netbank.firm.decoder.DcfirmMessageToMessageDecoder;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.model.Message;
import netbank.firm.model.MessageHead;
import netbank.firm.model.MessageType;

public class MessageDigestDecoder
extends DcfirmMessageToMessageDecoder<Message> {
    protected void decode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        try {
            if (msg.getMessageType() == MessageType.MESSAGE) {
                MessageHead mh = (MessageHead)msg.getHead();
                this.LOG.debug("\u53c2\u4e0e\u6821\u9a8c\u7684\u6d88\u606f\uff1a[" + new String(msg.getBody()) + "]");
                String md5 = MD5Util.md5Digest(msg.getBody());
                if (!md5.equals(mh.getMd())) {
                    throw new DcfirmException(ExceptionCode.U113);
                }
                this.LOG.debug("\u901a\u8fc7\u5408\u6cd5\u6027\u6821\u9a8c");
            }
            out.add(msg);
        }
        catch (DcfirmException d) {
            throw d;
        }
        catch (Exception e) {
            throw new DcfirmException(ExceptionCode.U114);
        }
    }
}

