/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.encoder;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import netbank.firm.base.CompressionUtil;
import netbank.firm.encoder.DcfirmMessageToMessageEncoder;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.model.Message;
import netbank.firm.model.MessageHead;
import netbank.firm.model.MessageType;

public class CompressEncoder
extends DcfirmMessageToMessageEncoder<Message> {
    protected void encode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        try {
            if (msg.getMessageType() == MessageType.MESSAGE) {
                MessageHead mh = (MessageHead)msg.getHead();
                if (mh.getCompress().booleanValue()) {
                    this.LOG.debug("\u538b\u7f29\u5904\u7406");
                    byte[] body = msg.getBody();
                    body = CompressionUtil.compress(body);
                    msg.setBody(body);
                    msg.getHead().setLength(body.length);
                } else {
                    this.LOG.debug("\u65e0\u9700\u538b\u7f29\u5904\u7406");
                }
            }
            out.add(msg);
        }
        catch (Exception e) {
            throw new DcfirmException(ExceptionCode.U105, (Throwable)e);
        }
    }
}

