/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.encoder;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import netbank.firm.base.MD5Util;
import netbank.firm.encoder.DcfirmMessageToMessageEncoder;
import netbank.firm.exception.DcfirmException;
import netbank.firm.exception.ExceptionCode;
import netbank.firm.model.Message;
import netbank.firm.model.MessageHead;
import netbank.firm.model.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDigestEncoder
extends DcfirmMessageToMessageEncoder<Message> {
    protected final Logger macLog = LoggerFactory.getLogger((String)"filemac.out");

    protected void encode(ChannelHandlerContext ctx, Message msg, List<Object> out) throws Exception {
        try {
            if (msg.getMessageType() == MessageType.MESSAGE) {
                MessageHead mh = (MessageHead)msg.getHead();
                if (msg.getBody() != null) {
                    this.LOG.debug("\u53c2\u4e0e\u8ba1\u7b97\u7684\u6d88\u606f\uff1a[" + new String(msg.getBody(), "GBK") + "]");
                    String md5 = MD5Util.md5Digest(msg.getBody());
                    mh.setMd(md5);
                    this.LOG.debug("\u7b97\u51fa\u6d88\u606f\u6458\u8981\uff1a[" + md5 + "]");
                    this.macLog.info("\u7b97\u51fa\u6d88\u606f\u6458\u8981MD5\uff1a[" + md5 + "]");
                } else {
                    this.LOG.debug("\u65e0\u9700\u6458\u8981\u5904\u7406");
                }
            }
            out.add(msg);
        }
        catch (Exception e) {
            throw new DcfirmException(ExceptionCode.U114, (Throwable)e);
        }
    }
}

