/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import netbank.firm.base.SystemProperty;
import netbank.firm.decoder.MessageDecoder;
import netbank.firm.dispatcher.DecoderDispatcher;
import netbank.firm.encoder.MessageDigestEncoder;
import netbank.firm.encoder.MessageEncoder;
import netbank.firm.encoder.Object2Message;
import netbank.firm.handler.NotifyTypeHandler;
import netbank.firm.handler.TimeoutHandler;

public class DefaultListenChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private String recvPath;

    public DefaultListenChannelInitializer(String recvPath) {
        this.recvPath = recvPath;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        p.addLast("decoders", (ChannelHandler)new DecoderDispatcher());
        p.addLast("messDecoder", (ChannelHandler)new MessageDecoder());
        p.addLast("messEncoder", (ChannelHandler)new MessageEncoder());
        p.addAfter("messEncoder", "digest", (ChannelHandler)new MessageDigestEncoder());
        p.addAfter("digest", "toMessage", (ChannelHandler)new Object2Message());
        int readerIdleTimeSeconds = Integer.parseInt(SystemProperty.getInstance().getProperty("netty.reader.idletime.seconds", "60"));
        int writerIdleTimeSeconds = Integer.parseInt(SystemProperty.getInstance().getProperty("netty.writer.idletime.seconds", "60"));
        int allIdleTimeSeconds = Integer.parseInt(SystemProperty.getInstance().getProperty("netty.all.idletime.seconds", "60"));
        p.addLast("notifyType", (ChannelHandler)new NotifyTypeHandler());
        p.addLast("idleState", (ChannelHandler)new IdleStateHandler(readerIdleTimeSeconds, writerIdleTimeSeconds, allIdleTimeSeconds));
        p.addLast(new ChannelHandler[]{new TimeoutHandler()});
    }
}

