/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.model;

import netbank.firm.model.FileRequest;
import netbank.firm.model.FileRequestType;
import netbank.firm.model.MessageHead;
import netbank.firm.serial.AlignType;
import netbank.firm.serial.FieldDefine;
import netbank.firm.serial.HeadType;
import netbank.firm.serial.Serialable;
import netbank.firm.serial.TxnModel;

@Serialable(headType=HeadType.Message, txnModel=TxnModel.DOWNLOAD_REQUEST)
public class DownloadRequest
extends FileRequest<DownloadRequest> {
    @FieldDefine(length=15, order=5)
    private String fileId;
    @FieldDefine(length=64, order=6)
    private String fileName;
    @FieldDefine(length=5, order=10, align=AlignType.RIGHT)
    private Integer blockSize;
    @FieldDefine(length=5, order=15, align=AlignType.RIGHT)
    private Integer startNum;

    public DownloadRequest(MessageHead head, byte[] body) {
        super(FileRequestType.DOWNLOAD);
        this.fileId = new String(body, 0, 15);
        this.fileName = new String(body, 15, 64);
        this.blockSize = new Integer(new String(body, 79, 5).trim());
        this.startNum = new Integer(new String(body, 84, 5).trim());
    }

    public DownloadRequest() {
        super(FileRequestType.DOWNLOAD);
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(Integer blockSize) {
        this.blockSize = blockSize;
    }

    public Integer getStartNum() {
        return this.startNum;
    }

    public void setStartNum(Integer startNum) {
        this.startNum = startNum;
    }
}

