/*
 * Decompiled with CFR 0.152.
 */
package netbank.firm.model;

import io.netty.buffer.ByteBuf;
import netbank.firm.model.AbstractMessageHead;
import netbank.firm.model.MessageType;
import netbank.firm.model.ProtocolVersion;

public class Message {
    MessageType messageType;
    final ProtocolVersion protocolVersion = ProtocolVersion.VER1;
    protected AbstractMessageHead<?> head;
    protected byte[] body;

    public Message() {
    }

    public Message(MessageType type, AbstractMessageHead<?> head, byte[] body) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.messageType = type;
        this.head = head;
        this.body = body;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void encodeAsByteBuf(ByteBuf byteBuf) throws Exception {
        byteBuf.writeBytes(this.head.tobytes());
        if (this.getBody() != null) {
            byteBuf.writeBytes(this.getBody());
        }
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public AbstractMessageHead<?> getHead() {
        return this.head;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public void setHead(AbstractMessageHead<?> head) {
        this.head = head;
    }
}

