/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.isfj;

import cn.com.infosec.isfj.formatutil.FileUtil;
import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.util.Properties;

public class Config {
    private static String providerName;
    private static String providerLocation;
    private static Provider provider;
    private static String rootCertPath;
    private static String encCertPath;
    private static String decPrivateKeyPath;
    private static String signCertPath;
    private static String signPrivateKeyPath;
    private static String superCertificate;
    private static String isReturnCert;
    private static String whiteBoxLibraryPath;
    private static String signCertString;
    private static String encCertString;

    public static void loadConfig(String path) throws Exception {
        Properties cfg = new Properties();
        byte[] data = FileUtil.readFromFile(path);
        cfg.load(new ByteArrayInputStream(data));
        providerName = cfg.getProperty("ProviderName", "INFOSEC");
        providerLocation = cfg.getProperty("PackageName", "cn.com.infosec.jce.provider");
        String className = cfg.getProperty("Provider", "INFOSECProvider");
        rootCertPath = cfg.getProperty("RootCertPath", "");
        encCertPath = cfg.getProperty("EncCertPath", "");
        decPrivateKeyPath = cfg.getProperty("DecPrivateKeyPath", "");
        signCertPath = cfg.getProperty("SignCertPath", "");
        signPrivateKeyPath = cfg.getProperty("SignPrivateKeyPath", "");
        isReturnCert = cfg.getProperty("IsReturnCert", "1");
        whiteBoxLibraryPath = cfg.getProperty("WhiteBoxLibraryPath", "wbsm4");
        provider = (Provider)Config.getProviderClass(className).newInstance();
    }

    public static void android_loadConfig(String a_providerName, String a_packageName, String a_provider, String signCert, String encCert, String a_superCertificate) throws Exception {
        providerName = a_providerName;
        providerLocation = a_packageName;
        String className = a_provider;
        rootCertPath = "";
        encCertPath = "";
        signCertPath = "";
        signCertString = signCert;
        encCertString = encCert;
        superCertificate = a_superCertificate;
        whiteBoxLibraryPath = "wbsm4";
        provider = (Provider)Config.getProviderClass(className).newInstance();
    }

    private static Class<?> getProviderClass(String nameOfClass) throws ClassNotFoundException {
        String className = nameOfClass.replaceAll("\\s", "").replaceAll("-", "");
        String classNameFinal = Character.toUpperCase(className.charAt(0)) + className.substring(1);
        return Class.forName(providerLocation + "." + classNameFinal);
    }

    public static String getProviderName() {
        return providerName;
    }

    public static void setProviderName(String providerName) {
        Config.providerName = providerName;
    }

    public static String getProviderLocation() {
        return providerLocation;
    }

    public static void setProviderLocation(String providerLocation) {
        Config.providerLocation = providerLocation;
    }

    public static Provider getProvider() {
        return provider;
    }

    public static void setProvider(Provider provider) {
        Config.provider = provider;
    }

    public static String getRootCertPath() {
        return rootCertPath;
    }

    public static void setRootCertPath(String rootCertPath) {
        Config.rootCertPath = rootCertPath;
    }

    public static String getEncCertPath() {
        return encCertPath;
    }

    public static void setEncCertPath(String encCertPath) {
        Config.encCertPath = encCertPath;
    }

    public static String getSignCertPath() {
        return signCertPath;
    }

    public static void setSignCertPath(String signCertPath) {
        Config.signCertPath = signCertPath;
    }

    public static String getSignPrivateKeyPath() {
        return signPrivateKeyPath;
    }

    public static void setSignPrivateKeyPath(String signPrivateKeyPath) {
        Config.signPrivateKeyPath = signPrivateKeyPath;
    }

    public static String getDecPrivateKeyPath() {
        return decPrivateKeyPath;
    }

    public static void setDecPrivateKeyPath(String decPrivateKeyPath) {
        Config.decPrivateKeyPath = decPrivateKeyPath;
    }

    public static String getSuperCertificate() {
        return superCertificate;
    }

    public static void setSuperCertificate(String superCertificate) {
        Config.superCertificate = superCertificate;
    }

    public static String getIsReturnCert() {
        return isReturnCert;
    }

    public static void setIsReturnCert(String isReturnCert) {
        Config.isReturnCert = isReturnCert;
    }

    public static String getWhiteBoxLibraryPath() {
        return whiteBoxLibraryPath;
    }

    public static void setWhiteBoxLibraryPath(String whiteBoxLibraryPath) {
        Config.whiteBoxLibraryPath = whiteBoxLibraryPath;
    }

    public static String getSignCertString() {
        return signCertString;
    }

    public static void setSignCertString(String signCertString) {
        Config.signCertString = signCertString;
    }

    public static String getEncCertString() {
        return encCertString;
    }

    public static void setEncCertString(String encCertString) {
        Config.encCertString = encCertString;
    }
}

