/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.isfj.cryptoutil;

import cn.com.infosec.crypto.digests.SM3Digest;
import java.security.SecureRandom;

public class KDFUtil {
    public static byte[] KDF(byte[] seed, int klen) {
        int blockSize = 32;
        int outLen = klen % blockSize == 0 ? klen : (klen / blockSize + 1) * blockSize;
        byte[] out = new byte[outLen];
        int ct = 1;
        byte[] hash = null;
        int outOffset = 0;
        for (int i = 0; i < outLen / blockSize; ++i) {
            byte[] bsct = KDFUtil.int2bytes(ct);
            byte[] buf = new byte[seed.length + bsct.length];
            System.arraycopy(seed, 0, buf, 0, seed.length);
            System.arraycopy(bsct, 0, buf, seed.length, bsct.length);
            hash = KDFUtil.sm3hash(buf);
            System.arraycopy(hash, 0, out, outOffset, hash.length);
            outOffset += hash.length;
            ++ct;
        }
        return out;
    }

    private static byte[] sm3hash(byte[] d) {
        SM3Digest sm3 = new SM3Digest();
        sm3.update(d, 0, d.length);
        byte[] r = new byte[32];
        sm3.doFinal(r, 0);
        return r;
    }

    private static byte[] int2bytes(int num) {
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bytes[3 - i] = (byte)(0xFF & num >> i * 8);
        }
        return bytes;
    }

    public static void main(String[] args) {
        byte[] sr = new byte[16];
        byte[] cr = new byte[16];
        byte[] prem = new byte[16];
        SecureRandom r = new SecureRandom();
        r.nextBytes(sr);
        r.nextBytes(cr);
        r.nextBytes(prem);
        byte[] seed = new byte[48];
        System.arraycopy(cr, 0, seed, 0, 16);
        System.arraycopy(sr, 0, seed, 16, 16);
        System.arraycopy(prem, 0, seed, 32, 16);
        byte[] key = KDFUtil.KDF(seed, 48);
    }
}

