/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.isfj.keyagreement;

import cn.com.infosec.isfj.Config;
import cn.com.infosec.isfj.certutil.X509CertificateParser;
import cn.com.infosec.isfj.cryptoutil.HMACUtil;
import cn.com.infosec.isfj.cryptoutil.KDFUtil;
import cn.com.infosec.isfj.cryptoutil.SM2AlgoUtil;
import cn.com.infosec.isfj.cryptoutil.SymKeyUtil;
import cn.com.infosec.isfj.enums.BlockCipherModeEnum;
import cn.com.infosec.isfj.enums.HMACAlgorithm;
import cn.com.infosec.isfj.enums.PaddingMethodEnum;
import cn.com.infosec.isfj.enums.SymmetricAlgorithm;
import cn.com.infosec.isfj.formatutil.EncodeUtil;
import cn.com.infosec.isfj.keyagreement.ErrorCode;
import cn.com.infosec.jcajce.provider.asymmetric.ec.INFOSECECPublicKey;
import cn.com.infosec.utils.WBSM4;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class KeyAgreement {
    static SymmetricAlgorithm symmetricAlgorithm = SymmetricAlgorithm.SM4;
    static BlockCipherModeEnum mode = BlockCipherModeEnum.CBC;
    static PaddingMethodEnum padding = PaddingMethodEnum.PKCS5Padding;
    private byte[] wbkey = new byte[0];
    private byte[] wbiv = new byte[0];
    private String wb_sm4key = "";
    private String wb_sm4iv = "";
    private String wb_hmackey = "";
    private String wb_cmackey = "";

    public static String generatrRandom() {
        SecureRandom random = new SecureRandom();
        byte[] random_bytes = new byte[32];
        random.nextBytes(random_bytes);
        return EncodeUtil.base64Encode(random_bytes);
    }

    public static String clientKeyAgreementGetRandom() {
        return KeyAgreement.generatrRandom();
    }

    public Map<String, String> clientKeyAgreement(String serverRandom, String clienRandom, String signCert, String encCert, String signResult, Boolean virifyCert) {
        String errcode = "000000";
        HashMap<String, String> map = new HashMap<String, String>();
        Boolean isPlainContainCert = true;
        try {
            byte[] plainBytes;
            if (signCert == null || signCert.length() == 0) {
                isPlainContainCert = false;
                signCert = Config.getSignCertString();
                if (signCert == null || signCert.length() == 0) {
                    String signCertPath = Config.getSignCertPath();
                    if (!KeyAgreement.checkFile(signCertPath)) {
                        errcode = "A00003";
                        map.put("ret", errcode);
                        map.put("message", ErrorCode.getErrorDesc(errcode));
                        return map;
                    }
                    signCert = KeyAgreement.readCertFile(signCertPath);
                    if (signCert == null || signCert.length() == 0) {
                        errcode = "A00007";
                        map.put("ret", errcode);
                        map.put("message", ErrorCode.getErrorDesc(errcode));
                        return map;
                    }
                }
            }
            if (encCert == null || encCert.length() == 0) {
                isPlainContainCert = false;
                encCert = Config.getEncCertString();
                if (encCert == null || encCert.length() == 0) {
                    String encCertPath = Config.getEncCertPath();
                    if (!KeyAgreement.checkFile(encCertPath)) {
                        errcode = "A00002";
                        map.put("ret", errcode);
                        map.put("message", ErrorCode.getErrorDesc(errcode));
                        return map;
                    }
                    encCert = KeyAgreement.readCertFile(encCertPath);
                    if (encCert == null || encCert.length() == 0) {
                        errcode = "A00007";
                        map.put("ret", errcode);
                        map.put("message", ErrorCode.getErrorDesc(errcode));
                        return map;
                    }
                }
            }
            X509Certificate X509Cert2 = X509CertificateParser.certParser(signCert);
            X509Certificate X509Cert3 = X509CertificateParser.certParser(encCert);
            if (virifyCert.booleanValue()) {
                String rootCert = Config.getSuperCertificate();
                String rootCertPath = Config.getRootCertPath();
                if (KeyAgreement.checkFile(rootCertPath)) {
                    String tmp_rootCert = KeyAgreement.readCertFile(rootCertPath);
                    if (tmp_rootCert != null && tmp_rootCert.length() != 0) {
                        rootCert = tmp_rootCert;
                    } else if (rootCert == null || rootCert.length() == 0) {
                        errcode = "A00001";
                        map.put("ret", errcode);
                        map.put("message", ErrorCode.getErrorDesc(errcode));
                        return map;
                    }
                } else if (rootCert == null || rootCert.length() == 0) {
                    errcode = "A00001";
                    map.put("ret", errcode);
                    map.put("message", ErrorCode.getErrorDesc(errcode));
                    return map;
                }
                X509Certificate X509Cert1 = X509CertificateParser.certParser(rootCert);
                try {
                    X509Cert1.checkValidity();
                }
                catch (CertificateExpiredException e) {
                    errcode = "A00028";
                    map.put("ret", errcode);
                    map.put("message", ErrorCode.getErrorDesc(errcode));
                    return map;
                }
                catch (CertificateNotYetValidException e) {
                    errcode = "A00029";
                    map.put("ret", errcode);
                    map.put("message", ErrorCode.getErrorDesc(errcode));
                    return map;
                }
                INFOSECECPublicKey pub = (INFOSECECPublicKey)X509Cert1.getPublicKey();
                try {
                    X509Cert2.verify((PublicKey)pub);
                }
                catch (SignatureException e) {
                    errcode = "A00022";
                    map.put("ret", errcode);
                    map.put("message", ErrorCode.getErrorDesc(errcode));
                    return map;
                }
                try {
                    X509Cert2.checkValidity();
                }
                catch (CertificateExpiredException e) {
                    errcode = "A00024";
                    map.put("ret", errcode);
                    map.put("message", ErrorCode.getErrorDesc(errcode));
                    return map;
                }
                catch (CertificateNotYetValidException e) {
                    errcode = "A00025";
                    map.put("ret", errcode);
                    map.put("message", ErrorCode.getErrorDesc(errcode));
                    return map;
                }
                try {
                    X509Cert3.verify((PublicKey)pub);
                }
                catch (SignatureException e) {
                    errcode = "A00023";
                    map.put("ret", errcode);
                    map.put("message", ErrorCode.getErrorDesc(errcode));
                    return map;
                }
                try {
                    X509Cert3.checkValidity();
                }
                catch (CertificateExpiredException e) {
                    errcode = "A00026";
                    map.put("ret", errcode);
                    map.put("message", ErrorCode.getErrorDesc(errcode));
                    return map;
                }
                catch (CertificateNotYetValidException e) {
                    errcode = "A00027";
                    map.put("ret", errcode);
                    map.put("message", ErrorCode.getErrorDesc(errcode));
                    return map;
                }
            }
            INFOSECECPublicKey pub = (INFOSECECPublicKey)X509Cert2.getPublicKey();
            String PublicKey2 = EncodeUtil.base64Encode(pub.getQ().getEncoded());
            byte[] clientRandombytes = EncodeUtil.base64Decode(clienRandom);
            byte[] serverRandombytes = EncodeUtil.base64Decode(serverRandom);
            byte[] signCertbytes = EncodeUtil.base64Decode(signCert);
            byte[] encCertbytes = EncodeUtil.base64Decode(encCert);
            if (isPlainContainCert.booleanValue()) {
                plainBytes = new byte[clientRandombytes.length + serverRandombytes.length + signCertbytes.length + encCertbytes.length];
                System.arraycopy(clientRandombytes, 0, plainBytes, 0, clientRandombytes.length);
                System.arraycopy(serverRandombytes, 0, plainBytes, clientRandombytes.length, serverRandombytes.length);
                System.arraycopy(signCertbytes, 0, plainBytes, clientRandombytes.length + serverRandombytes.length, signCertbytes.length);
                System.arraycopy(encCertbytes, 0, plainBytes, clientRandombytes.length + serverRandombytes.length + signCertbytes.length, encCertbytes.length);
            } else {
                plainBytes = new byte[clientRandombytes.length + serverRandombytes.length];
                System.arraycopy(clientRandombytes, 0, plainBytes, 0, clientRandombytes.length);
                System.arraycopy(serverRandombytes, 0, plainBytes, clientRandombytes.length, serverRandombytes.length);
            }
            boolean verifyResult = false;
            verifyResult = SM2AlgoUtil.sm2RawVerify(PublicKey2, EncodeUtil.base64Encode(plainBytes), signResult);
            if (!verifyResult) {
                errcode = "A00012";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            SecureRandom random = new SecureRandom();
            byte[] client_random = new byte[48];
            random.nextBytes(client_random);
            String preMasterKey = EncodeUtil.base64Encode(client_random);
            pub = (INFOSECECPublicKey)X509Cert3.getPublicKey();
            String serverEncCertPublicKey = EncodeUtil.base64Encode(pub.getQ().getEncoded());
            String encPreMasterKey = SM2AlgoUtil.sm2Encrypt(serverEncCertPublicKey, preMasterKey);
            byte[] kdfPlain = new byte[clientRandombytes.length + serverRandombytes.length + client_random.length];
            System.arraycopy(clientRandombytes, 0, kdfPlain, 0, clientRandombytes.length);
            System.arraycopy(serverRandombytes, 0, kdfPlain, clientRandombytes.length, serverRandombytes.length);
            System.arraycopy(client_random, 0, kdfPlain, clientRandombytes.length + serverRandombytes.length, client_random.length);
            this.genKeyAndWBEnc(kdfPlain);
            map.put("preMasterKey", encPreMasterKey);
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
        }
        catch (Exception e) {
            errcode = "A00030";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
        }
        return map;
    }

    public Map<String, String> clientKeyAgreementWithKeyPair(String serverRandom, String clientRandom, String signPublicKey, String encPublicKey, String signResult) {
        String errcode = "000000";
        HashMap<String, String> map = new HashMap<String, String>();
        Boolean isPlainContainCert = false;
        try {
            byte[] plainBytes;
            byte[] clientRandombytes = EncodeUtil.base64Decode(clientRandom);
            byte[] serverRandombytes = EncodeUtil.base64Decode(serverRandom);
            byte[] signCertbytes = EncodeUtil.base64Decode(signPublicKey);
            byte[] encCertbytes = EncodeUtil.base64Decode(encPublicKey);
            if (isPlainContainCert.booleanValue()) {
                plainBytes = new byte[clientRandombytes.length + serverRandombytes.length + signCertbytes.length + encCertbytes.length];
                System.arraycopy(clientRandombytes, 0, plainBytes, 0, clientRandombytes.length);
                System.arraycopy(serverRandombytes, 0, plainBytes, clientRandombytes.length, serverRandombytes.length);
                System.arraycopy(signCertbytes, 0, plainBytes, clientRandombytes.length + serverRandombytes.length, signCertbytes.length);
                System.arraycopy(encCertbytes, 0, plainBytes, clientRandombytes.length + serverRandombytes.length + signCertbytes.length, encCertbytes.length);
            } else {
                plainBytes = new byte[clientRandombytes.length + serverRandombytes.length];
                System.arraycopy(clientRandombytes, 0, plainBytes, 0, clientRandombytes.length);
                System.arraycopy(serverRandombytes, 0, plainBytes, clientRandombytes.length, serverRandombytes.length);
            }
            boolean verifyResult = false;
            verifyResult = SM2AlgoUtil.sm2RawVerify(signPublicKey, EncodeUtil.base64Encode(plainBytes), signResult);
            if (!verifyResult) {
                errcode = "A00012";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            SecureRandom random = new SecureRandom();
            byte[] client_random = new byte[48];
            random.nextBytes(client_random);
            String preMasterKey = EncodeUtil.base64Encode(client_random);
            String encPreMasterKey = SM2AlgoUtil.sm2Encrypt(encPublicKey, preMasterKey);
            byte[] kdfPlain = new byte[clientRandombytes.length + serverRandombytes.length + client_random.length];
            System.arraycopy(clientRandombytes, 0, kdfPlain, 0, clientRandombytes.length);
            System.arraycopy(serverRandombytes, 0, kdfPlain, clientRandombytes.length, serverRandombytes.length);
            System.arraycopy(client_random, 0, kdfPlain, clientRandombytes.length + serverRandombytes.length, client_random.length);
            this.genKeyAndWBEnc(kdfPlain);
            map.put("preMasterKey", encPreMasterKey);
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
        }
        catch (Exception e) {
            errcode = "A00030";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
        }
        return map;
    }

    private static boolean checkFile(String filePath) {
        if (filePath == null || filePath.length() == 0) {
            return false;
        }
        File file = new File(filePath);
        return file.exists();
    }

    public static String readCertFile(String filePath) {
        Scanner sc = null;
        int count = 0;
        String tmpString = "";
        String fileContent = "";
        try {
            sc = new Scanner(new FileReader(filePath));
        }
        catch (FileNotFoundException e) {
            return fileContent;
        }
        while (sc.hasNextLine()) {
            fileContent = fileContent + tmpString;
            if (count == 0) {
                sc.nextLine();
                ++count;
                continue;
            }
            tmpString = sc.nextLine();
        }
        return fileContent;
    }

    public static Map<String, String> serverKeyAgreementGetRandomAndSignResultWithKeyPair(String clientRandom, String signPrivateKey) {
        HashMap<String, String> map = new HashMap();
        map = KeyAgreement.serverKeyAgreementGetRandomAndSignResultWithoutKey(clientRandom, signPrivateKey);
        return map;
    }

    private static Map<String, String> serverKeyAgreementGetRandomAndSignResultWithoutKey(String clientRandom, String signPrivateKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        String errcode = "000000";
        if (clientRandom == null || clientRandom.length() == 0) {
            errcode = "A00021";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        String serverRandom = KeyAgreement.generatrRandom();
        if (serverRandom == null || serverRandom.length() == 0) {
            errcode = "A00000";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        String signed = null;
        try {
            byte[] clientRandombytes = EncodeUtil.base64Decode(clientRandom);
            byte[] serverRandombytes = EncodeUtil.base64Decode(serverRandom);
            byte[] plainBytes = new byte[clientRandombytes.length + serverRandombytes.length];
            System.arraycopy(clientRandombytes, 0, plainBytes, 0, clientRandombytes.length);
            System.arraycopy(serverRandombytes, 0, plainBytes, clientRandombytes.length, serverRandombytes.length);
            signed = SM2AlgoUtil.sm2RawSign(signPrivateKey, EncodeUtil.base64Encode(plainBytes));
            if (signed == null || signed.length() == 0) {
                errcode = "A00011";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            map.put("serverRandom", serverRandom);
            map.put("signResult", signed);
        }
        catch (Exception e) {
            // empty catch block
        }
        return map;
    }

    public static Map<String, String> serverKeyAgreementGetRandomAndSignResult(String clientRandom) {
        String isReturnCert = Config.getIsReturnCert();
        Map<Object, Object> map = new HashMap();
        map = isReturnCert.equals("1") ? KeyAgreement.serverKeyAgreementGetRandomAndSignResultWithCert(clientRandom) : KeyAgreement.serverKeyAgreementGetRandomAndSignResultWithoutCert(clientRandom);
        return map;
    }

    private static Map<String, String> serverKeyAgreementGetRandomAndSignResultWithCert(String clientRandom) {
        HashMap<String, String> map = new HashMap<String, String>();
        String errcode = "000000";
        if (clientRandom == null || clientRandom.length() == 0) {
            errcode = "A00021";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        String serverRandom = KeyAgreement.generatrRandom();
        if (serverRandom == null || serverRandom.length() == 0) {
            errcode = "A00000";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        String encCertPath = Config.getEncCertPath();
        if (!KeyAgreement.checkFile(encCertPath)) {
            errcode = "A00002";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        String encCert = KeyAgreement.readCertFile(encCertPath);
        if (encCert == null || encCert.length() == 0) {
            errcode = "A00007";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        String signCertPath = Config.getSignCertPath();
        if (!KeyAgreement.checkFile(signCertPath)) {
            errcode = "A00003";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        String signCert = KeyAgreement.readCertFile(signCertPath);
        if (signCert == null || signCert.length() == 0) {
            errcode = "A00007";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        String signPrivateKeyPath = Config.getSignPrivateKeyPath();
        if (!KeyAgreement.checkFile(signPrivateKeyPath)) {
            errcode = "A00010";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        String signPrivateKey = KeyAgreement.readCertFile(signPrivateKeyPath);
        if (signPrivateKey == null || signPrivateKey.length() == 0) {
            errcode = "A00010";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        String signed = null;
        try {
            PrivateKey key = SM2AlgoUtil.formatPrivateKey(EncodeUtil.base64Decode(signPrivateKey));
            byte[] clientRandombytes = EncodeUtil.base64Decode(clientRandom);
            byte[] serverRandombytes = EncodeUtil.base64Decode(serverRandom);
            byte[] signCertbytes = EncodeUtil.base64Decode(signCert);
            byte[] encCertbytes = EncodeUtil.base64Decode(encCert);
            byte[] plainBytes = new byte[clientRandombytes.length + serverRandombytes.length + signCertbytes.length + encCertbytes.length];
            System.arraycopy(clientRandombytes, 0, plainBytes, 0, clientRandombytes.length);
            System.arraycopy(serverRandombytes, 0, plainBytes, clientRandombytes.length, serverRandombytes.length);
            System.arraycopy(signCertbytes, 0, plainBytes, clientRandombytes.length + serverRandombytes.length, signCertbytes.length);
            System.arraycopy(encCertbytes, 0, plainBytes, clientRandombytes.length + serverRandombytes.length + signCertbytes.length, encCertbytes.length);
            Signature sign = Signature.getInstance("SM2", Config.getProviderName());
            sign.initSign(key);
            sign.update(plainBytes);
            signed = EncodeUtil.base64Encode(sign.sign());
            if (signed == null || signed.length() == 0) {
                errcode = "A00011";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            map.put("serverRandom", serverRandom);
            map.put("signResult", signed);
            map.put("serverEncyptCert", encCert);
            map.put("serverSignatureCert", signCert);
        }
        catch (Exception e) {
            map.put("ret", "A00011");
            map.put("message", ErrorCode.getErrorDesc("A00011"));
        }
        return map;
    }

    private static Map<String, String> serverKeyAgreementGetRandomAndSignResultWithoutCert(String clientRandom) {
        HashMap<String, String> map = new HashMap<String, String>();
        String errcode = "000000";
        if (clientRandom == null || clientRandom.length() == 0) {
            errcode = "A00021";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        String serverRandom = KeyAgreement.generatrRandom();
        if (serverRandom == null || serverRandom.length() == 0) {
            errcode = "A00000";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        String signPrivateKeyPath = Config.getSignPrivateKeyPath();
        if (!KeyAgreement.checkFile(signPrivateKeyPath)) {
            errcode = "A00010";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        String signPrivateKey = KeyAgreement.readCertFile(signPrivateKeyPath);
        if (signPrivateKey == null || signPrivateKey.length() == 0) {
            errcode = "A00010";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        String signed = null;
        try {
            PrivateKey key = SM2AlgoUtil.formatPrivateKey(EncodeUtil.base64Decode(signPrivateKey));
            byte[] clientRandombytes = EncodeUtil.base64Decode(clientRandom);
            byte[] serverRandombytes = EncodeUtil.base64Decode(serverRandom);
            byte[] plainBytes = new byte[clientRandombytes.length + serverRandombytes.length];
            System.arraycopy(clientRandombytes, 0, plainBytes, 0, clientRandombytes.length);
            System.arraycopy(serverRandombytes, 0, plainBytes, clientRandombytes.length, serverRandombytes.length);
            Signature sign = Signature.getInstance("SM2", Config.getProviderName());
            sign.initSign(key);
            sign.update(plainBytes);
            signed = EncodeUtil.base64Encode(sign.sign());
            if (signed == null || signed.length() == 0) {
                errcode = "A00011";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            map.put("serverRandom", serverRandom);
            map.put("signResult", signed);
        }
        catch (Exception e) {
            map.put("ret", "A00011");
            map.put("message", ErrorCode.getErrorDesc("A00011"));
        }
        return map;
    }

    public static Map<String, String> serverKeyAgreementWithKey(String clientRandom, String serverRandom, String encpreMasterKey, String encPrivateKey) {
        String errcode = "000000";
        Map<String, String> map = new HashMap<String, String>();
        try {
            String plaintext = SM2AlgoUtil.sm2Decrypt(encPrivateKey, encpreMasterKey);
            byte[] preMasterKeybytes = EncodeUtil.base64Decode(plaintext);
            byte[] clientRandombytes = EncodeUtil.base64Decode(clientRandom);
            byte[] serverRandombytes = EncodeUtil.base64Decode(serverRandom);
            byte[] kdfPlain = new byte[clientRandombytes.length + serverRandombytes.length + preMasterKeybytes.length];
            System.arraycopy(clientRandombytes, 0, kdfPlain, 0, clientRandombytes.length);
            System.arraycopy(serverRandombytes, 0, kdfPlain, clientRandombytes.length, serverRandombytes.length);
            System.arraycopy(preMasterKeybytes, 0, kdfPlain, clientRandombytes.length + serverRandombytes.length, preMasterKeybytes.length);
            map = KeyAgreement.GenKey(kdfPlain);
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
        }
        catch (Exception e) {
            errcode = "A00030";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
        }
        return map;
    }

    public static Map<String, String> serverKeyAgreement(String clientRandom, String serverRandom, String encpreMasterKey) {
        String errcode = "000000";
        Map<String, String> map = new HashMap<String, String>();
        String decPrivateKeyPath = Config.getDecPrivateKeyPath();
        if (!KeyAgreement.checkFile(decPrivateKeyPath)) {
            errcode = "A00009";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        String decPrivateKey = KeyAgreement.readCertFile(decPrivateKeyPath);
        if (decPrivateKey == null || decPrivateKey.length() == 0) {
            errcode = "A00009";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        try {
            PrivateKey key = SM2AlgoUtil.formatPrivateKey(EncodeUtil.base64Decode(decPrivateKey));
            Cipher cipher = Cipher.getInstance("SM2", Config.getProviderName());
            cipher.init(2, key);
            byte[] tTemp = cipher.doFinal(EncodeUtil.base64Decode(encpreMasterKey));
            byte[] clientRandombytes = EncodeUtil.base64Decode(clientRandom);
            byte[] serverRandombytes = EncodeUtil.base64Decode(serverRandom);
            byte[] kdfPlain = new byte[clientRandombytes.length + serverRandombytes.length + tTemp.length];
            System.arraycopy(clientRandombytes, 0, kdfPlain, 0, clientRandombytes.length);
            System.arraycopy(serverRandombytes, 0, kdfPlain, clientRandombytes.length, serverRandombytes.length);
            System.arraycopy(tTemp, 0, kdfPlain, clientRandombytes.length + serverRandombytes.length, tTemp.length);
            map = KeyAgreement.GenKey(kdfPlain);
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
        }
        catch (Exception e) {
            errcode = "A00030";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
        }
        return map;
    }

    public static Map<String, String> serverKeyAgreementWithoutDec(String clientRandom, String serverRandom, String preMasterKey) {
        String errcode = "000000";
        Map<String, String> map = new HashMap<String, String>();
        try {
            byte[] tTemp = EncodeUtil.base64Decode(preMasterKey);
            byte[] clientRandombytes = EncodeUtil.base64Decode(clientRandom);
            byte[] serverRandombytes = EncodeUtil.base64Decode(serverRandom);
            byte[] kdfPlain = new byte[clientRandombytes.length + serverRandombytes.length + tTemp.length];
            System.arraycopy(clientRandombytes, 0, kdfPlain, 0, clientRandombytes.length);
            System.arraycopy(serverRandombytes, 0, kdfPlain, clientRandombytes.length, serverRandombytes.length);
            System.arraycopy(tTemp, 0, kdfPlain, clientRandombytes.length + serverRandombytes.length, tTemp.length);
            map = KeyAgreement.GenKey(kdfPlain);
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
        }
        catch (Exception e) {
            errcode = "A00030";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
        }
        return map;
    }

    private void genKeyAndWBEnc(byte[] KDFParam) {
        SecureRandom random;
        byte[] keys = KDFUtil.KDF(KDFParam, 64);
        byte[] sm4Key = new byte[16];
        byte[] sm4iv = new byte[16];
        byte[] sm4hmac = new byte[16];
        byte[] sm4cmac = new byte[16];
        System.arraycopy(keys, 0, sm4Key, 0, sm4Key.length);
        System.arraycopy(keys, sm4Key.length, sm4iv, 0, sm4iv.length);
        System.arraycopy(keys, sm4Key.length + sm4iv.length, sm4hmac, 0, sm4hmac.length);
        System.arraycopy(keys, sm4Key.length + sm4iv.length + sm4hmac.length, sm4cmac, 0, sm4cmac.length);
        if (this.wbiv.length != 16) {
            random = new SecureRandom();
            this.wbiv = new byte[16];
            random.nextBytes(this.wbiv);
        }
        if (this.wbkey.length != 16) {
            random = new SecureRandom();
            this.wbkey = new byte[16];
            random.nextBytes(this.wbkey);
        }
        this.wb_sm4key = KeyAgreement.whiteBoxEncrypt(this.wbkey, this.wbiv, EncodeUtil.base64Encode(sm4Key).getBytes());
        this.wb_sm4iv = KeyAgreement.whiteBoxEncrypt(this.wbkey, this.wbiv, EncodeUtil.base64Encode(sm4iv).getBytes());
        this.wb_hmackey = KeyAgreement.whiteBoxEncrypt(this.wbkey, this.wbiv, EncodeUtil.base64Encode(sm4hmac).getBytes());
        this.wb_cmackey = KeyAgreement.whiteBoxEncrypt(this.wbkey, this.wbiv, EncodeUtil.base64Encode(sm4cmac).getBytes());
    }

    private static Map<String, String> GenKey(byte[] KDFParam) {
        byte[] keys = KDFUtil.KDF(KDFParam, 64);
        byte[] sm4Key = new byte[16];
        byte[] sm4iv = new byte[16];
        byte[] sm4hmac = new byte[16];
        byte[] sm4cmac = new byte[16];
        System.arraycopy(keys, 0, sm4Key, 0, sm4Key.length);
        System.arraycopy(keys, sm4Key.length, sm4iv, 0, sm4iv.length);
        System.arraycopy(keys, sm4Key.length + sm4iv.length, sm4hmac, 0, sm4hmac.length);
        System.arraycopy(keys, sm4Key.length + sm4iv.length + sm4hmac.length, sm4cmac, 0, sm4cmac.length);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("SM4Key", EncodeUtil.base64Encode(sm4Key));
        map.put("SM4IV", EncodeUtil.base64Encode(sm4iv));
        map.put("hmacKey", EncodeUtil.base64Encode(sm4hmac));
        map.put("cmacKey", EncodeUtil.base64Encode(sm4cmac));
        return map;
    }

    public Map<String, String> messageCheck(String encMerssage, boolean hmacFlag, String hmac, boolean cmacFlag, String cmac) {
        String cmacResult;
        String errcode = "000000";
        HashMap<String, String> map = new HashMap<String, String>();
        String message = SymKeyUtil.symmetricCrypt(KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_sm4key)), encMerssage, KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_sm4iv)), "", 128, symmetricAlgorithm, mode, padding, false);
        if (message == null || message.length() == 0) {
            errcode = "A00016";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        if (hmacFlag) {
            String hmacResult = null;
            try {
                hmacResult = HMACUtil.HMACCalc(HMACAlgorithm.HmacSM3, message, KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_hmackey)));
            }
            catch (Exception e) {
                errcode = "A00018";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            if (!hmacResult.equals(hmac)) {
                errcode = "A00018";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
        }
        if (cmacFlag && !(cmacResult = SymKeyUtil.CMAC(KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_cmackey)), message, SymmetricAlgorithm.SM4)).equals(cmac)) {
            errcode = "A00020";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        map.put("ret", errcode);
        map.put("message", ErrorCode.getErrorDesc(errcode));
        map.put("plaintext", new String(EncodeUtil.base64Decode(message)));
        return map;
    }

    public Map<String, String> messageCheck(byte[] encMerssage, boolean hmacFlag, byte[] hmac, boolean cmacFlag, byte[] cmac) {
        String cmacResult;
        String errcode = "000000";
        HashMap<String, String> map = new HashMap<String, String>();
        String message = null;
        try {
            String sm4key = KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_sm4key));
            String sm4iv = KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_sm4iv));
            String transformation = symmetricAlgorithm.getValue() + "/" + mode.getValue() + "/" + padding.getValue();
            SecretKeySpec sk = new SecretKeySpec(EncodeUtil.base64Decode(sm4key), symmetricAlgorithm.getValue());
            Cipher cipher = Cipher.getInstance(transformation, Config.getProviderName());
            cipher.init(2, (Key)sk, new IvParameterSpec(EncodeUtil.base64Decode(sm4iv)));
            byte[] plaintext = cipher.doFinal(encMerssage);
            message = EncodeUtil.base64Encode(plaintext);
        }
        catch (Exception e) {
            errcode = "A00016";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        if (message == null || message.length() == 0) {
            errcode = "A00016";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        if (hmacFlag) {
            String hmacResult = null;
            try {
                hmacResult = HMACUtil.HMACCalc(HMACAlgorithm.HmacSM3, message, KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_hmackey)));
            }
            catch (Exception e) {
                errcode = "A00018";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            if (!hmacResult.equals(EncodeUtil.base64Encode(hmac))) {
                errcode = "A00018";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
        }
        if (cmacFlag && !(cmacResult = SymKeyUtil.CMAC(KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_cmackey)), message, SymmetricAlgorithm.SM4)).equals(EncodeUtil.base64Encode(cmac))) {
            errcode = "A00020";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        map.put("ret", errcode);
        map.put("message", ErrorCode.getErrorDesc(errcode));
        map.put("plaintext", new String(EncodeUtil.base64Decode(message)));
        return map;
    }

    public static Map<String, String> messageCheckWithKey(String sm4Key, String sm4IV, String encMerssage, boolean hmacFlag, String hmacKey, String hmac, boolean cmacFlag, String cmacKey, String cmac) {
        String cmacResult;
        String errcode = "000000";
        HashMap<String, String> map = new HashMap<String, String>();
        String message = SymKeyUtil.symmetricCrypt(sm4Key, encMerssage, sm4IV, "", 128, symmetricAlgorithm, mode, padding, false);
        if (message == null || message.length() == 0) {
            errcode = "A00016";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        if (hmacFlag) {
            String hmacResult = null;
            try {
                hmacResult = HMACUtil.HMACCalc(HMACAlgorithm.HmacSM3, message, hmacKey);
            }
            catch (Exception e) {
                errcode = "A00018";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            if (!hmacResult.equals(hmac)) {
                errcode = "A00018";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
        }
        if (cmacFlag && !(cmacResult = SymKeyUtil.CMAC(cmacKey, message, SymmetricAlgorithm.SM4)).equals(cmac)) {
            errcode = "A00020";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        map.put("ret", errcode);
        map.put("message", ErrorCode.getErrorDesc(errcode));
        map.put("plaintext", new String(EncodeUtil.base64Decode(message)));
        return map;
    }

    public static Map<String, String> messageCheckWithKey(byte[] sm4Key, byte[] sm4IV, byte[] encMerssage, boolean hmacFlag, byte[] hmacKey, byte[] hmac, boolean cmacFlag, byte[] cmacKey, byte[] cmac) {
        String cmacResult;
        byte[] plaintext;
        String errcode = "000000";
        HashMap<String, String> map = new HashMap<String, String>();
        String message = null;
        try {
            String transformation = symmetricAlgorithm.getValue() + "/" + mode.getValue() + "/" + padding.getValue();
            SecretKeySpec sk = new SecretKeySpec(sm4Key, symmetricAlgorithm.getValue());
            Cipher cipher = Cipher.getInstance(transformation, Config.getProviderName());
            cipher.init(2, (Key)sk, new IvParameterSpec(sm4IV));
            plaintext = cipher.doFinal(encMerssage);
            message = EncodeUtil.base64Encode(plaintext);
        }
        catch (Exception e) {
            errcode = "A00016";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        if (message == null || message.length() == 0) {
            errcode = "A00016";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        if (hmacFlag) {
            String hmacResult = null;
            try {
                hmacResult = HMACUtil.HMACCalc(HMACAlgorithm.HmacSM3, plaintext, hmacKey);
            }
            catch (Exception e) {
                errcode = "A00018";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            if (!hmacResult.equals(EncodeUtil.base64Encode(hmac))) {
                errcode = "A00018";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
        }
        if (cmacFlag && !(cmacResult = SymKeyUtil.CMAC(cmacKey, plaintext, SymmetricAlgorithm.SM4)).equals(EncodeUtil.base64Encode(cmac))) {
            errcode = "A00020";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        map.put("ret", errcode);
        map.put("message", ErrorCode.getErrorDesc(errcode));
        map.put("plaintext", new String(EncodeUtil.base64Decode(message)));
        return map;
    }

    public Map<String, String> sm4encAndgenHMAC_CMAC(String source, boolean hmacflag, boolean cmacflag) {
        String errcode = "000000";
        HashMap<String, String> map = new HashMap<String, String>();
        String base64Messages = EncodeUtil.base64Encode(source.getBytes());
        String sm4Messages = SymKeyUtil.symmetricCrypt(KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_sm4key)), base64Messages, KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_sm4iv)), "", 128, symmetricAlgorithm, mode, padding, true);
        if (sm4Messages == null || sm4Messages.length() == 0) {
            errcode = "A00015";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        if (hmacflag) {
            String hmac_result = null;
            try {
                hmac_result = HMACUtil.HMACCalc(HMACAlgorithm.HmacSM3, base64Messages, KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_hmackey)));
            }
            catch (Exception e) {
                errcode = "A00017";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            if (hmac_result == null || hmac_result.length() == 0) {
                errcode = "A00017";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            map.put("hmac", hmac_result);
        }
        if (cmacflag) {
            String cmac_result = SymKeyUtil.CMAC(KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_cmackey)), base64Messages, SymmetricAlgorithm.SM4);
            if (cmac_result == null || cmac_result.length() == 0) {
                map.remove("hmac");
                errcode = "A00019";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            map.put("cmac", cmac_result);
        }
        map.put("ret", errcode);
        map.put("message", ErrorCode.getErrorDesc(errcode));
        map.put("encMessage", sm4Messages);
        return map;
    }

    public Map<String, String> sm4encAndgenHMAC_CMAC(byte[] bytes, boolean hmacflag, boolean cmacflag) {
        String errcode = "000000";
        HashMap<String, String> map = new HashMap<String, String>();
        String base64Messages = EncodeUtil.base64Encode(bytes);
        String sm4Messages = SymKeyUtil.symmetricCrypt(KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_sm4key)), base64Messages, KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_sm4iv)), "", 128, symmetricAlgorithm, mode, padding, true);
        if (sm4Messages == null || sm4Messages.length() == 0) {
            errcode = "A00015";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        if (hmacflag) {
            String hmac_result = null;
            try {
                hmac_result = HMACUtil.HMACCalc(HMACAlgorithm.HmacSM3, base64Messages, KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_hmackey)));
            }
            catch (Exception e) {
                errcode = "A00017";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            if (hmac_result == null || hmac_result.length() == 0) {
                errcode = "A00017";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            map.put("hmac", hmac_result);
        }
        if (cmacflag) {
            String cmac_result = SymKeyUtil.CMAC(KeyAgreement.whiteBoxDecrypt(this.wbkey, this.wbiv, EncodeUtil.base64Decode(this.wb_cmackey)), base64Messages, SymmetricAlgorithm.SM4);
            if (cmac_result == null || cmac_result.length() == 0) {
                map.remove("hmac");
                errcode = "A00019";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            map.put("cmac", cmac_result);
        }
        map.put("ret", errcode);
        map.put("message", ErrorCode.getErrorDesc(errcode));
        map.put("encMessage", sm4Messages);
        return map;
    }

    public static Map<String, String> sm4encAndgenHMAC_CMACWithKey(String sm4Key, String sm4IV, String source, boolean hmacflag, String hmacKey, boolean cmacflag, String cmacKey) {
        String errcode = "000000";
        HashMap<String, String> map = new HashMap<String, String>();
        String base64Messages = EncodeUtil.base64Encode(source.getBytes());
        String sm4Messages = SymKeyUtil.symmetricCrypt(sm4Key, base64Messages, sm4IV, "", 128, symmetricAlgorithm, mode, padding, true);
        if (sm4Messages == null || sm4Messages.length() == 0) {
            errcode = "A00015";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        if (hmacflag) {
            String hmac_result = null;
            try {
                hmac_result = HMACUtil.HMACCalc(HMACAlgorithm.HmacSM3, base64Messages, hmacKey);
            }
            catch (Exception e) {
                errcode = "A00017";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            if (hmac_result == null || hmac_result.length() == 0) {
                errcode = "A00017";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            map.put("hmac", hmac_result);
        }
        if (cmacflag) {
            String cmac_result = SymKeyUtil.CMAC(cmacKey, base64Messages, SymmetricAlgorithm.SM4);
            if (cmac_result == null || cmac_result.length() == 0) {
                map.remove("hmac");
                errcode = "A00019";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            map.put("cmac", cmac_result);
        }
        map.put("ret", errcode);
        map.put("message", ErrorCode.getErrorDesc(errcode));
        map.put("encMessage", sm4Messages);
        return map;
    }

    public static Map<String, String> sm4encAndgenHMAC_CMACWithKey(byte[] sm4Key, byte[] sm4IV, byte[] source, boolean hmacflag, byte[] hmacKey, boolean cmacflag, byte[] cmacKey) {
        String sm4Messages;
        String errcode = "000000";
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String transformation = symmetricAlgorithm.getValue() + "/" + mode.getValue() + "/" + padding.getValue();
            SecretKeySpec sk = new SecretKeySpec(sm4Key, symmetricAlgorithm.getValue());
            Cipher cipher = Cipher.getInstance(transformation, Config.getProviderName());
            cipher.init(1, (Key)sk, new IvParameterSpec(sm4IV));
            byte[] enctext = cipher.doFinal(source);
            sm4Messages = EncodeUtil.base64Encode(enctext);
        }
        catch (Exception e) {
            errcode = "A00015";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        if (sm4Messages == null || sm4Messages.length() == 0) {
            errcode = "A00015";
            map.put("ret", errcode);
            map.put("message", ErrorCode.getErrorDesc(errcode));
            return map;
        }
        if (hmacflag) {
            String hmac_result = null;
            try {
                hmac_result = HMACUtil.HMACCalc(HMACAlgorithm.HmacSM3, source, hmacKey);
            }
            catch (Exception e) {
                errcode = "A00017";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            if (hmac_result == null || hmac_result.length() == 0) {
                errcode = "A00017";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            map.put("hmac", hmac_result);
        }
        if (cmacflag) {
            String cmac_result = SymKeyUtil.CMAC(cmacKey, source, SymmetricAlgorithm.SM4);
            if (cmac_result == null || cmac_result.length() == 0) {
                map.remove("hmac");
                errcode = "A00019";
                map.put("ret", errcode);
                map.put("message", ErrorCode.getErrorDesc(errcode));
                return map;
            }
            map.put("cmac", cmac_result);
        }
        map.put("ret", errcode);
        map.put("message", ErrorCode.getErrorDesc(errcode));
        map.put("encMessage", sm4Messages);
        return map;
    }

    public static String whiteBoxEncrypt(byte[] key, byte[] iv, byte[] plain) {
        WBSM4 wbsm4 = new WBSM4();
        byte[] cipher = wbsm4.encrypt(key, iv, plain);
        if (null == cipher) {
            return null;
        }
        return EncodeUtil.base64Encode(cipher);
    }

    public static String whiteBoxDecrypt(byte[] key, byte[] iv, byte[] cipher) {
        HashMap map = new HashMap();
        String errcode = "000000";
        WBSM4 wbsm4 = new WBSM4();
        byte[] decPlain = wbsm4.decrypt(key, iv, cipher);
        if (null == decPlain) {
            return null;
        }
        return new String(decPlain);
    }

    public static byte[] whiteBoxCrypt(byte[] src, boolean isEnc) {
        String key = "SZcDkwWPWqrWcjzdUE3nmg==";
        String iv = "DoRD73dk3N/CeOo7p/iUww==";
        WBSM4 wbsm4 = new WBSM4();
        if (isEnc) {
            return wbsm4.encrypt(EncodeUtil.base64Decode(key), EncodeUtil.base64Decode(iv), src);
        }
        return wbsm4.decrypt(EncodeUtil.base64Decode(key), EncodeUtil.base64Decode(iv), src);
    }
}

