/*
 * Decompiled with CFR 0.152.
 */
package com.sheca.safeengine;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;

class ParseCertificate {
    ParseCertificate() {
    }

    private static void printErr(String sInfo, Exception e) {
        String sErr = null;
        if (sInfo != null) {
            sErr = sInfo;
        }
        System.err.println(sErr);
        if (e != null) {
            e.printStackTrace();
        }
        System.out.println();
    }

    private static byte[] getExtContent(byte[] bExt) {
        int i;
        int outLen;
        int tag = bExt[1] & 0xFF;
        int len = 0;
        if (tag < 128) {
            outLen = tag;
        } else {
            len = tag - 128;
            outLen = 0;
            i = 0;
            while (i < len) {
                outLen <<= 8;
                outLen += bExt[i + 2] & 0xFF;
                ++i;
            }
        }
        len += 2;
        byte[] bRet = new byte[outLen];
        i = 0;
        while (i < outLen) {
            bRet[i] = bExt[len + i];
            ++i;
        }
        return bRet;
    }

    public static String[] getCRLDPN(X509Certificate oCert) {
        ByteArrayInputStream bIn = null;
        DistributionPoint[] oDP = null;
        ASN1InputStream aIn = null;
        ASN1Sequence seq = null;
        String[] sDPN = null;
        CRLDistPoint oCDP = null;
        byte[] bPath = null;
        try {
            bPath = oCert.getExtensionValue("2.5.29.31");
        }
        catch (Exception e) {
            ParseCertificate.printErr("getCRLDPN getExtensionValue error:", e);
            return null;
        }
        try {
            bPath = ParseCertificate.getExtContent(bPath);
            bIn = new ByteArrayInputStream(bPath);
        }
        catch (Exception e) {
            ParseCertificate.printErr("getCRLDPN create ByteArrayInputStream error:", e);
            return null;
        }
        try {
            aIn = new ASN1InputStream((InputStream)bIn);
            seq = (ASN1Sequence)aIn.readObject();
        }
        catch (Exception e) {
            ParseCertificate.printErr("getCRLDPN create ASN1InputStream error:", e);
            return null;
        }
        try {
            oCDP = new CRLDistPoint(seq);
        }
        catch (Exception e) {
            ParseCertificate.printErr("getCRLDPN create CRLDistPoint error:", e);
            return null;
        }
        oDP = oCDP.getDistributionPoints();
        sDPN = new String[oDP.length];
        int iNum = 0;
        while (iNum < oDP.length) {
            try {
                byte[] bName = oDP[iNum].getDistributionPoint().getName().getDEREncoded();
                bName = ParseCertificate.getExtContent(bName);
                bName = ParseCertificate.getExtContent(bName);
                char[] cName = new char[bName.length];
                int i = 0;
                while (i < bName.length) {
                    cName[i] = (char)bName[i];
                    ++i;
                }
                sDPN[iNum] = new String(cName);
            }
            catch (Exception e) {
                ParseCertificate.printErr("getCRLDPN getDistribuitonPoint error:", e);
                return sDPN;
            }
            ++iNum;
        }
        return sDPN;
    }
}

