/*
 * Decompiled with CFR 0.152.
 */
package com.sheca.safeengine;

import com.sheca.safeengine.CertIsRevokeFromLocal;
import com.sheca.safeengine.CertIsRevokeFromLocalLdap;
import com.sheca.safeengine.CertIsRevokeFromUrl;
import com.sheca.safeengine.FetchCRL;
import com.sheca.safeengine.Sdbi;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.util.encoders.Base64;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class javasafeengine {
    private int m_verifyTimeout = 5000;
    private String local_url;
    private int block = 0x100000;
    private static final Map jseMap = new Hashtable();
    private static char[] map1 = new char[64];
    private static byte[] map2;

    static {
        int i = 0;
        int c = 65;
        while (c <= 90) {
            javasafeengine.map1[i++] = c;
            c = (char)(c + 1);
        }
        c = 97;
        while (c <= 122) {
            javasafeengine.map1[i++] = c;
            c = (char)(c + 1);
        }
        c = 48;
        while (c <= 57) {
            javasafeengine.map1[i++] = c;
            c = (char)(c + 1);
        }
        javasafeengine.map1[i++] = 43;
        javasafeengine.map1[i++] = 47;
        map2 = new byte[128];
        i = 0;
        while (i < map2.length) {
            javasafeengine.map2[i] = -1;
            ++i;
        }
        i = 0;
        while (i < 64) {
            javasafeengine.map2[javasafeengine.map1[i]] = (byte)i;
            ++i;
        }
    }

    public static javasafeengine getInstance() {
        if (jseMap.isEmpty()) {
            javasafeengine jse = new javasafeengine();
            jseMap.put("javasafeengine", jse);
            return jse;
        }
        javasafeengine jseMap = (javasafeengine)javasafeengine.jseMap.get("javasafeengine");
        return jseMap;
    }

    private void printErr(String sInfo, Exception e) {
        String sErr = null;
        if (sInfo != null) {
            sErr = sInfo;
        }
        System.err.println(sErr);
        if (e != null) {
            e.printStackTrace();
        }
        System.out.println();
    }

    public String base64Encode(byte[] in) {
        BASE64Encoder oB64 = new BASE64Encoder();
        String sRet = oB64.encode(in);
        if (sRet == null) {
            this.printErr("base64Encode error.", null);
        }
        return sRet;
    }

    public byte[] base64Decode(String in) {
        BASE64Decoder oB64 = new BASE64Decoder();
        byte[] bRet = null;
        try {
            bRet = oB64.decodeBuffer(in);
        }
        catch (Exception e) {
            this.printErr("base64Decode error:", e);
        }
        return bRet;
    }

    public KeyStore getKeyStore(String sStoreType, String sProviderName, String sStoreName, String sStorePin) {
        KeyStore oKeyStoreToken = null;
        try {
            oKeyStoreToken = sStoreType.equals("PKCS12") ? KeyStore.getInstance("PKCS12") : KeyStore.getInstance(sStoreType, sProviderName);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printErr("getKeyStore error:", e);
        }
        try {
            if (sStoreName == null || sStoreName.equalsIgnoreCase("") || sStoreName.equalsIgnoreCase("NONE")) {
                oKeyStoreToken.load(null, sStorePin.toCharArray());
            } else {
                oKeyStoreToken.load(new FileInputStream(sStoreName), sStorePin.toCharArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printErr("getKeyStore load error:", e);
        }
        return oKeyStoreToken;
    }

    public Enumeration getAliasEnum(KeyStore oStore) {
        Enumeration<String> eNum = null;
        try {
            eNum = oStore.aliases();
        }
        catch (Exception e) {
            this.printErr("getAliasEnum error:", e);
        }
        return eNum;
    }

    public Certificate getCertFromStore(KeyStore oStore, String sAlias, String sPin) {
        Certificate oCert = null;
        KeyStore.TrustedCertificateEntry oEntry = null;
        boolean jEn = false;
        try {
            jEn = oStore.isCertificateEntry(sAlias);
        }
        catch (Exception e) {
            this.printErr("getCertFromStore isCertificateEntry error:", e);
            return null;
        }
        if (jEn) {
            try {
                oEntry = (KeyStore.TrustedCertificateEntry)oStore.getEntry(sAlias, null);
            }
            catch (Exception e) {
                try {
                    oEntry = (KeyStore.TrustedCertificateEntry)oStore.getEntry(sAlias, new KeyStore.PasswordProtection(sPin.toCharArray()));
                }
                catch (Exception e1) {
                    this.printErr("getCertFromStore certificate entry error:", e1);
                    return null;
                }
            }
            oCert = oEntry.getTrustedCertificate();
        } else {
            try {
                oCert = oStore.getCertificate(sAlias);
            }
            catch (Exception e1) {
                this.printErr("getCertFromStore error:", e1);
            }
        }
        return oCert;
    }

    public Certificate getCertFromBuffer(byte[] bCert) {
        Certificate oCert = null;
        CertificateFactory cf = null;
        ByteArrayInputStream iData = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (Exception e) {
            this.printErr("getCertFromBuffer getInstance error:", e);
            return null;
        }
        try {
            iData = new ByteArrayInputStream(bCert);
        }
        catch (Exception e) {
            this.printErr("getCertFromBuffer create ByteArrayInputStream error:", e);
            return null;
        }
        try {
            oCert = cf.generateCertificate(iData);
        }
        catch (Exception e) {
            this.printErr("getCertFromBuffer generate certificate error:", e);
        }
        return oCert;
    }

    public Key getPrivateKeyFromStore(KeyStore oStore, String sAlias, String sKeyPin) {
        Key oKey = null;
        try {
            oKey = oStore.getKey(sAlias, sKeyPin.toCharArray());
        }
        catch (Exception e) {
            this.printErr("getPrivateKeyFromStore error:", e);
        }
        return oKey;
    }

    public Key getPublicKeyFromStore(KeyStore oStore, String sAlias) {
        Key oKey = null;
        try {
            oStore.getCertificate(sAlias).getPublicKey();
        }
        catch (Exception e) {
            this.printErr("getPublicKeyFromStore error:", e);
        }
        return oKey;
    }

    public byte[] sign(byte[] bData, PrivateKey oPrivateKey, String sAlg, String sProviderName) {
        Signature oSig = null;
        Provider oProvider = null;
        byte[] bSign = null;
        try {
            oProvider = Security.getProvider(sProviderName);
        }
        catch (Exception e) {
            this.printErr("sign getProvider in sign error:", e);
        }
        if (oProvider == null) {
            System.out.println("no provider found in sign.");
            return null;
        }
        try {
            oSig = Signature.getInstance(sAlg, oProvider);
        }
        catch (Exception e) {
            this.printErr("sign getInstance error:", e);
        }
        if (oSig == null) {
            System.out.println("no signature found in sign.");
            return null;
        }
        try {
            oSig.initSign(oPrivateKey);
        }
        catch (Exception e) {
            this.printErr("sign initSign error:", e);
            return null;
        }
        try {
            oSig.update(bData);
        }
        catch (Exception e) {
            this.printErr("sign update error:", e);
            return null;
        }
        try {
            bSign = oSig.sign();
        }
        catch (Exception e) {
            this.printErr("sign sign error:", e);
        }
        return bSign;
    }

    public byte[] sign(byte[] bData, String keyName, String sAlg, String sProviderName) {
        Signature oSig = null;
        Provider oProvider = null;
        byte[] bSign = null;
        KeyPair kr = null;
        try {
            oProvider = Security.getProvider(sProviderName);
        }
        catch (Exception e) {
            this.printErr("sign getProvider in sign error:", e);
        }
        if (oProvider == null) {
            System.out.println("no provider found in sign.");
            return null;
        }
        try {
            oSig = Signature.getInstance(sAlg, oProvider);
        }
        catch (Exception e) {
            this.printErr("sign getInstance error:", e);
        }
        if (oSig == null) {
            System.out.println("no signature found in sign.");
            return null;
        }
        try {
            SecureRandom secureRandom = SecureRandom.getInstance(keyName, sProviderName);
            KeyPairGenerator pg = KeyPairGenerator.getInstance("RSA", sProviderName);
            pg.initialize(1024, secureRandom);
            kr = pg.genKeyPair();
            oSig.initSign(kr.getPrivate());
        }
        catch (Exception e) {
            this.printErr("sign initSign error:", e);
            return null;
        }
        try {
            oSig.update(bData);
        }
        catch (Exception e) {
            this.printErr("sign update error:", e);
            return null;
        }
        try {
            bSign = oSig.sign();
        }
        catch (Exception e) {
            this.printErr("sign sign error:", e);
        }
        return bSign;
    }

    public byte[] sign(byte[] bData, KeyStore oStore, String sAlias, String sKeyPin, String sAlg, String sProviderName) {
        PrivateKey oPrivateKey = (PrivateKey)this.getPrivateKeyFromStore(oStore, sAlias, sKeyPin);
        if (oPrivateKey == null) {
            this.printErr("sign get private key from store error:", null);
            return null;
        }
        return this.sign(bData, oPrivateKey, sAlg, sProviderName);
    }

    public boolean verifySign(byte[] bData, byte[] bSign, String sAlg, Certificate oCert, String sProviderName) {
        Signature oSig = null;
        boolean bRet = false;
        Provider oProvider = null;
        try {
            oProvider = Security.getProvider(sProviderName);
        }
        catch (Exception e) {
            return false;
        }
        try {
            oSig = Signature.getInstance(sAlg, oProvider);
        }
        catch (Exception e) {
            return false;
        }
        try {
            oSig.initVerify(oCert.getPublicKey());
        }
        catch (Exception e) {
            return false;
        }
        try {
            oSig.update(bData);
        }
        catch (Exception e) {
            return false;
        }
        try {
            bRet = oSig.verify(bSign);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bRet;
    }

    public boolean verifySign(byte[] bData, byte[] bSign, String sAlg, byte[] bCert, String sProviderName) {
        boolean ret = false;
        Certificate oCert = this.getCertFromBuffer(bCert);
        if (oCert == null) {
            this.printErr("verifySign getCertFromBuffer error:", null);
            return ret;
        }
        ret = this.verifySign(bData, bSign, sAlg, oCert, sProviderName);
        return ret;
    }

    public String getCertDetail(int itemNo, byte[] bcert) throws Exception {
        Vector id_at_telephoneNumber;
        ASN1InputStream asn1Input = new ASN1InputStream((InputStream)new ByteArrayInputStream(bcert));
        DERObject asn1X509 = asn1Input.readObject();
        String retval = "";
        X509CertificateStructure x509 = X509CertificateStructure.getInstance((Object)asn1X509);
        if (itemNo == 1) {
            retval = Integer.toString(x509.getVersion());
        } else if (itemNo == 2) {
            retval = x509.getSerialNumber().getValue().toString(16);
        } else if (itemNo == 3) {
            retval = x509.getSignatureAlgorithm().getObjectId().getId();
        } else if (itemNo == 4) {
            Vector countrys = x509.getIssuer().getValues(X509CertificateStructure.countryName);
            if (countrys != null && countrys.size() > 0) {
                retval = countrys.get(0) != null ? countrys.get(0).toString() : "";
            }
        } else if (itemNo == 5) {
            Vector companys = x509.getIssuer().getValues(X509CertificateStructure.organization);
            if (companys != null && companys.size() > 0) {
                retval = companys.get(0) != null ? companys.get(0).toString() : "";
            }
        } else if (itemNo == 6) {
            Vector depts = x509.getIssuer().getValues(X509CertificateStructure.organizationalUnitName);
            if (depts != null && depts.size() > 0) {
                retval = depts.get(0) != null ? depts.get(0).toString() : "";
            }
        } else if (itemNo == 7) {
            Vector stateOrProvinceNames = x509.getIssuer().getValues(X509CertificateStructure.stateOrProvinceName);
            if (stateOrProvinceNames != null && stateOrProvinceNames.size() > 0) {
                retval = stateOrProvinceNames.get(0) != null ? stateOrProvinceNames.get(0).toString() : "";
            }
        } else if (itemNo == 8) {
            Vector cns = x509.getIssuer().getValues(X509CertificateStructure.commonName);
            retval = cns.get(0) != null ? cns.get(0).toString() : "";
        } else if (itemNo == 9) {
            Vector citys = x509.getIssuer().getValues(X509CertificateStructure.localityName);
            if (citys != null && citys.size() > 0) {
                retval = citys.get(0) != null ? citys.get(0).toString() : "";
            }
        } else if (itemNo == 10) {
            Vector emails = x509.getIssuer().getValues(X509CertificateStructure.pkcs_9_at_emailAddress);
            if (emails != null && emails.size() > 0) {
                retval = emails.get(0) != null ? emails.get(0).toString() : "";
            }
        } else if (itemNo == 11) {
            retval = x509.getStartDate().getTime();
        } else if (itemNo == 12) {
            retval = x509.getEndDate().getTime();
        } else if (itemNo == 13) {
            Vector countrys = x509.getSubject().getValues(X509CertificateStructure.countryName);
            if (countrys != null && countrys.size() > 0) {
                retval = countrys.get(0) != null ? countrys.get(0).toString() : "";
            }
        } else if (itemNo == 14) {
            Vector companys = x509.getSubject().getValues(X509CertificateStructure.organization);
            if (companys != null && companys.size() > 0) {
                retval = companys.get(0) != null ? companys.get(0).toString() : "";
            }
        } else if (itemNo == 15) {
            Vector depts = x509.getSubject().getValues(X509CertificateStructure.organizationalUnitName);
            if (depts != null && depts.size() > 0) {
                retval = depts.get(0) != null ? depts.get(0).toString() : "";
            }
        } else if (itemNo == 16) {
            Vector stateOrProvinceNames = x509.getSubject().getValues(X509CertificateStructure.stateOrProvinceName);
            if (stateOrProvinceNames != null && stateOrProvinceNames.size() > 0) {
                retval = stateOrProvinceNames.get(0) != null ? stateOrProvinceNames.get(0).toString() : "";
            }
        } else if (itemNo == 17) {
            Vector cns = x509.getSubject().getValues(X509CertificateStructure.commonName);
            retval = cns.get(0) != null ? cns.get(0).toString() : "";
        } else if (itemNo == 18) {
            Vector citys = x509.getSubject().getValues(X509CertificateStructure.localityName);
            if (citys != null && citys.size() > 0) {
                retval = citys.get(0) != null ? citys.get(0).toString() : "";
            }
        } else if (itemNo == 19) {
            Vector emails = x509.getSubject().getValues(X509CertificateStructure.pkcs_9_at_emailAddress);
            if (emails != null && emails.size() > 0) {
                retval = emails.get(0) != null ? emails.get(0).toString() : "";
            }
        } else if (itemNo == 20) {
            SubjectPublicKeyInfo pukinfo = x509.getSubjectPublicKeyInfo();
            byte[] byPuk = pukinfo.getPublicKeyData().getBytes();
            retval = new String(Base64.encode((byte[])byPuk));
        } else if (itemNo == 21 && (id_at_telephoneNumber = x509.getSubject().getValues(X509CertificateStructure.id_at_telephoneNumber)) != null && id_at_telephoneNumber.size() > 0) {
            retval = id_at_telephoneNumber.get(0) != null ? id_at_telephoneNumber.get(0).toString() : "";
        }
        return retval;
    }

    private byte[] getExtContent(byte[] bExt) {
        int i;
        int outLen;
        int tag = bExt[1] & 0xFF;
        int len = 0;
        if (tag < 128) {
            outLen = tag;
        } else {
            len = tag - 128;
            outLen = 0;
            i = 0;
            while (i < len) {
                outLen <<= 8;
                outLen += bExt[i + 2] & 0xFF;
                ++i;
            }
        }
        len += 2;
        byte[] bRet = new byte[outLen];
        i = 0;
        while (i < outLen) {
            bRet[i] = bExt[len + i];
            ++i;
        }
        return bRet;
    }

    private byte[] getShecaCertInfo(String sOid, X509Certificate oCert) {
        X509Extension oExt;
        byte[] bDerExt = null;
        byte[] bRetExt = null;
        ByteArrayInputStream bIn = null;
        X509Extensions oExts = null;
        ASN1InputStream aIn = null;
        ASN1Sequence seq = null;
        DERObjectIdentifier oid = null;
        try {
            bDerExt = oCert.getExtensionValue("1.2.156.1.8888");
        }
        catch (Exception e) {
            return null;
        }
        try {
            bDerExt = this.getExtContent(bDerExt);
            bIn = new ByteArrayInputStream(bDerExt);
        }
        catch (Exception e) {
            return null;
        }
        try {
            aIn = new ASN1InputStream((InputStream)bIn);
        }
        catch (Exception e) {
            return null;
        }
        try {
            seq = (ASN1Sequence)aIn.readObject();
        }
        catch (Exception e) {
            return null;
        }
        try {
            oExts = new X509Extensions(seq);
        }
        catch (Exception e) {
            return null;
        }
        try {
            oid = new DERObjectIdentifier(sOid);
        }
        catch (Exception e) {
            return null;
        }
        try {
            oExt = oExts.getExtension(oid);
        }
        catch (Exception e) {
            return null;
        }
        try {
            bRetExt = oExt.getValue().getOctets();
        }
        catch (Exception e) {
            return null;
        }
        return bRetExt;
    }

    private byte[] getCertExtInfo1(String sOid, X509Certificate oCert) {
        byte[] bRet = null;
        if (sOid.startsWith("1.2.156.1.8888")) {
            bRet = this.getShecaCertInfo(sOid, oCert);
        } else {
            try {
                bRet = oCert.getExtensionValue(sOid);
            }
            catch (Exception e) {
                this.printErr("getCertExtInfo getExtensionvalue error:", e);
                return null;
            }
            try {
                bRet = this.getExtContent(bRet);
            }
            catch (Exception e) {
                this.printErr("getCertExtInfo getExtContent error:", e);
                return null;
            }
        }
        return bRet;
    }

    public String getCertExtInfo(String sOid, X509Certificate oCert) {
        byte[] bRet = null;
        String sInfo = null;
        bRet = sOid.startsWith("1.2.156.1.8888") ? this.getShecaCertInfo(sOid, oCert) : this.getCAGCertInfo(sOid, oCert);
        if (bRet == null) {
            bRet = this.getCAGCertInfo("1.2.156.112570.11.206", oCert);
            if (bRet != null && "1".equals(new String(bRet))) {
                if ("1.2.156.1.8888.148".equals(sOid)) {
                    bRet = this.getCAGCertInfo("1.2.156.10260.4.1.4", oCert);
                } else {
                    if ("1.2.156.10260.4.1.5".equals(sOid)) {
                        return null;
                    }
                    String cagURL = "";
                    try {
                        Properties prop = new Properties();
                        prop.load(this.getClass().getClassLoader().getResourceAsStream("sheca.properties"));
                        cagURL = prop.getProperty("cagURL");
                    }
                    catch (Exception ex) {
                        cagURL = null;
                    }
                    bRet = cagURL != null && !"".equals(cagURL) ? this.getCertInfoOnLine(sOid, oCert, cagURL) : (byte[])null;
                }
            } else {
                bRet = "1.2.156.10260.4.1.5".equals(sOid) ? this.getShecaCertInfo("1.2.156.1.8888.148", oCert) : (byte[])null;
            }
        }
        if (bRet != null) {
            sInfo = new String(bRet);
        }
        return sInfo;
    }

    public String getCertExtInfo(String sOid, byte[] bCert) {
        X509Certificate oCert = (X509Certificate)this.getCertFromBuffer(bCert);
        return this.getCertExtInfo(sOid, oCert);
    }

    public byte[] digest(byte[] bData, String sAlg, String sProviderName) {
        MessageDigest md = null;
        byte[] bDgt = null;
        try {
            md = MessageDigest.getInstance(sAlg, sProviderName);
        }
        catch (Exception e) {
            this.printErr("digest getInstance error:", e);
            return null;
        }
        try {
            bDgt = md.digest(bData);
        }
        catch (Exception e) {
            this.printErr("digest error:", e);
            return null;
        }
        return bDgt;
    }

    public byte[] random(int iByteLen, String sAlg, String sProviderName) {
        SecureRandom random = null;
        byte[] seed = null;
        try {
            random = SecureRandom.getInstance(sAlg, sProviderName);
        }
        catch (Exception e) {
            this.printErr("randm getInstance error:", e);
            return null;
        }
        try {
            seed = random.generateSeed(iByteLen);
        }
        catch (Exception e) {
            this.printErr("random generateSeed error:", e);
        }
        return seed;
    }

    public byte[] encrypt(byte[] bData, byte[] bKey, String sAlg, String sProviderName) {
        byte[] bCipher = null;
        Cipher c1 = null;
        SecretKeySpec oKeySpec = null;
        try {
            oKeySpec = new SecretKeySpec(bKey, sAlg);
        }
        catch (Exception e) {
            this.printErr("encrypt create SecretKeySpec error:", e);
            return null;
        }
        try {
            c1 = Cipher.getInstance(sAlg, sProviderName);
        }
        catch (Exception e) {
            this.printErr("encrypt cipher getInstance error:", e);
            return null;
        }
        try {
            c1.init(1, oKeySpec);
        }
        catch (Exception e) {
            this.printErr("encrypt cipher init error:", e);
            return null;
        }
        try {
            bCipher = c1.doFinal(bData);
        }
        catch (Exception e) {
            this.printErr("encrypt cipher doFinal error:", e);
            return null;
        }
        return bCipher;
    }

    public byte[] decrypt(byte[] bCipher, byte[] bKey, String sAlg, String sProviderName) {
        byte[] bDecipher = null;
        Cipher c1 = null;
        SecretKeySpec oKeySpec = null;
        try {
            oKeySpec = new SecretKeySpec(bKey, sAlg);
        }
        catch (Exception e) {
            this.printErr("decrypt create SecretKeySpec error:", e);
            return null;
        }
        try {
            c1 = Cipher.getInstance(sAlg, sProviderName);
        }
        catch (Exception e) {
            this.printErr("decrypt cipher getInstance error:", e);
            return null;
        }
        try {
            c1.init(2, oKeySpec);
        }
        catch (Exception e) {
            this.printErr("decrypt cipher init error:", e);
            return null;
        }
        try {
            bDecipher = c1.doFinal(bCipher);
        }
        catch (Exception e) {
            this.printErr("decrypt cipher doFinal error:", e);
            return null;
        }
        return bDecipher;
    }

    private int verifyUserCert(X509Certificate subject, List certChain, int iCfg) {
        CertIsRevokeFromLocal cr;
        try {
            subject.checkValidity();
        }
        catch (Exception e) {
            return -1;
        }
        int verify = 0;
        verify = this.verifyCertChain(certChain, subject);
        if (verify == -1 && (verify = this.verifyLocalCertChain(subject)) == -1) {
            return -1;
        }
        if (verify != -1 && (iCfg & 1) != 0 && (verify = (cr = new CertIsRevokeFromLocal()).certIsRevoked(subject)) != 0) {
            int cfg = iCfg & 4;
            if (cfg == 4) {
                verify = new CertIsRevokeFromLocalLdap().certIsRevoked(subject);
            }
            if (cfg == 0 && (verify = new CertIsRevokeFromLocalLdap().certIsRevoked(subject)) != 0) {
                verify = new CertIsRevokeFromUrl().certIsRevoked(subject);
            }
        }
        return verify;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int verifyLocalCertChain(X509Certificate subject) {
        int verify = -1;
        Properties prop = null;
        try {
            prop = new Properties();
            prop.load(this.getClass().getClassLoader().getResourceAsStream("CertChain.properties"));
        }
        catch (Exception e) {
            return -1;
        }
        List<? extends Certificate> certs = null;
        ByteArrayInputStream bIn = null;
        CertificateFactory cf = null;
        CertPath oCertPath = null;
        InputStream CACertIs = null;
        byte[] bCACert = null;
        boolean isSign = false;
        try {
            String certChainNum = prop.getProperty("CertChainNum");
            int chainNum = Integer.valueOf(certChainNum);
            String certChain = "";
            String sign = "";
            try {
                try {
                    CACertIs = this.getClass().getClassLoader().getResourceAsStream("CA.der");
                    bCACert = new byte[CACertIs.available()];
                    CACertIs.read(bCACert);
                }
                catch (Exception e) {
                    if (CACertIs == null) return -1;
                    try {
                        CACertIs.close();
                        return -1;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return -1;
                }
            }
            finally {
                if (CACertIs != null) {
                    try {
                        CACertIs.close();
                    }
                    catch (Exception exception) {}
                }
            }
            int i = 0;
            while (true) {
                block32: {
                    if (i >= chainNum) {
                        return verify;
                    }
                    certChain = prop.getProperty("CertChain" + i);
                    sign = prop.getProperty("Sign" + i);
                    if (certChain != null && !"".equals(certChain) && sign != null && !"".equals(sign)) {
                        try {
                            X509Certificate oCert = (X509Certificate)this.getCertFromBuffer(bCACert);
                            if (!isSign) {
                                isSign = this.verifySign(certChain.getBytes(), this.base64Decode(sign), "SHA1withRSA", (Certificate)oCert, "SunRsaSign");
                            }
                            if (!isSign) {
                                isSign = this.verifySign(certChain.getBytes(), this.base64Decode(sign), "SHA1withRSA", (Certificate)oCert, "IBMJCE");
                            }
                        }
                        catch (Exception e) {
                            isSign = false;
                        }
                    }
                    if (isSign) {
                        try {
                            bIn = new ByteArrayInputStream(this.base64Decode(certChain));
                        }
                        catch (Exception e) {
                            break block32;
                        }
                        try {
                            cf = CertificateFactory.getInstance("X.509");
                            oCertPath = cf.generateCertPath(bIn, "PKCS7");
                        }
                        catch (Exception e) {
                            break block32;
                        }
                        try {
                            certs = oCertPath.getCertificates();
                        }
                        catch (Exception e) {
                            break block32;
                        }
                        verify = this.verifyCertChain(certs, subject);
                        if (verify != -1) {
                            return verify;
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            return -1;
        }
    }

    private String initLocalURL(String url) {
        return url;
    }

    private int verifyCertChain(List certChain, X509Certificate subject) {
        int nRtn = 1;
        if (certChain == null) {
            return -1;
        }
        int size = certChain.size();
        if (size <= 0) {
            return -1;
        }
        int i = 0;
        while (size > 0) {
            ++i;
            try {
                subject.checkValidity();
            }
            catch (Exception e) {
                nRtn = -1;
                break;
            }
            X509Certificate issuer = (X509Certificate)certChain.get(size - 1);
            --size;
            try {
                subject.verify(issuer.getPublicKey());
                nRtn = 1;
            }
            catch (Exception e) {
                nRtn = -1;
                if (i != certChain.size()) continue;
            }
            break;
        }
        return nRtn;
    }

    public void SetVerifyTimeout(int timeout) {
        this.m_verifyTimeout = timeout;
    }

    public int verifyCert(X509Certificate oCert, byte[] bChain, int iCfg) {
        List<? extends Certificate> certs = null;
        ByteArrayInputStream bIn = null;
        CertificateFactory cf = null;
        CertPath oCertPath = null;
        try {
            bIn = new ByteArrayInputStream(bChain);
            cf = CertificateFactory.getInstance("X.509");
            oCertPath = cf.generateCertPath(bIn, "PKCS7");
            certs = oCertPath.getCertificates();
        }
        catch (Exception exception) {
            // empty catch block
        }
        FetchCRL.SetConnectTimeout(this.m_verifyTimeout);
        FetchCRL.SetReadTimeout(this.m_verifyTimeout);
        return this.verifyUserCert(oCert, certs, iCfg);
    }

    public int verifyCert(byte[] bCert, byte[] bChain, int iCfg) {
        Certificate subject = this.getCertFromBuffer(bCert);
        if (subject == null) {
            this.printErr("verifyCert getCertFromBuffer error:", null);
            return -1;
        }
        return this.verifyCert((X509Certificate)subject, bChain, iCfg);
    }

    public int getValidDays(X509Certificate oCert) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        String sd = sf.format(date);
        Date oNA = oCert.getNotAfter();
        Date oNB = oCert.getNotBefore();
        if (date.after(oNA)) {
            this.printErr("This certificate is expired.", null);
            return 0;
        }
        if (date.before(oNB)) {
            this.printErr("This certificate hasn't become effective.", null);
            return -1;
        }
        long i = date.getTime();
        i = oNA.getTime() - i;
        int ii = (int)(i / 86400000L);
        return ii;
    }

    public int getValidDays(byte[] bCert) {
        X509Certificate oCert = (X509Certificate)this.getCertFromBuffer(bCert);
        return this.getValidDays(oCert);
    }

    public byte[] encryptByPublicKey(PublicKey pk, byte[] data, String sAlg, String sProvider) {
        Cipher cipher = null;
        byte[] bRet = null;
        try {
            if (sProvider.equals("SwxaJCE")) {
                sAlg = "RSA/ECB/PKCS1Padding";
            } else if (sProvider.equals("FishermanJCE")) {
                sAlg = "RSA/2/PKCS1PADDING";
            }
            cipher = Cipher.getInstance(sAlg, sProvider);
        }
        catch (Exception e) {
            this.printErr("encryptByPublicKey cipher getInstance error:", e);
            return null;
        }
        try {
            cipher.init(1, pk);
        }
        catch (Exception e) {
            this.printErr("encryptByPublicKey cipher init error:", e);
            return null;
        }
        int outputSize = cipher.getOutputSize(data.length);
        try {
            bRet = cipher.doFinal(data);
        }
        catch (Exception e) {
            this.printErr("encryptByPublicKey cipher encrypt error:", e);
            return null;
        }
        return bRet;
    }

    public byte[] decryptByPrivateKey(PrivateKey pk, byte[] bCipher, String sAlg, String sProvider) {
        Cipher cipher = null;
        byte[] bRet = null;
        try {
            if (sProvider.equals("SwxaJCE")) {
                sAlg = "RSA/ECB/PKCS1Padding";
            } else if (sProvider.equals("FishermanJCE")) {
                sAlg = "RSA/1/PKCS1PADDING";
            }
            cipher = Cipher.getInstance(sAlg, sProvider);
        }
        catch (Exception e) {
            this.printErr("decryptByPrivateKey cipher getInstance error:", e);
            return null;
        }
        try {
            cipher.init(2, pk);
        }
        catch (Exception e) {
            this.printErr("decryptByPrivateKey cipher init error:", e);
            return null;
        }
        try {
            bRet = cipher.doFinal(bCipher);
        }
        catch (Exception e) {
            this.printErr("decryptByPrivateKey cipher decrypt error:", e);
            return null;
        }
        return bRet;
    }

    public byte[] envelope(int i, byte[] data, KeyStore oKeyStore, String sAlias, String sPin, String sAlg, String sProvider, String sAlgProvider) {
        byte[] encrpt_key;
        byte[] envelope = null;
        if (i == 1) {
            try {
                String ranAlg = "SHA1PRNG";
                if (sAlgProvider.equals("SwxaJCE")) {
                    ranAlg = "RND";
                } else if (sAlgProvider.equals("FishermanJCE")) {
                    ranAlg = "TrueRandom";
                }
                byte[] bRan = this.random(16, ranAlg, sProvider);
                Sdbi sdbi = new Sdbi();
                byte[] encrypt_data = sdbi.SDBIEncryptData(data, bRan);
                Certificate oCert = this.getCertFromStore(oKeyStore, sAlias, sPin);
                PublicKey pbkey = oCert.getPublicKey();
                encrpt_key = this.encryptByPublicKey(pbkey, bRan, sAlg, sAlgProvider);
                envelope = new byte[encrypt_data.length + encrpt_key.length];
                envelope = javasafeengine.getMergeBytes(encrpt_key, encrypt_data);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (i == 2) {
            Certificate oCert = this.getCertFromStore(oKeyStore, sAlias, sPin);
            PublicKey pubkey = oCert.getPublicKey();
            byte[] pbkey = pubkey.getEncoded();
            int at = 0;
            X509EncodedKeySpec spec = new X509EncodedKeySpec(pbkey);
            try {
                KeyFactory keyfac = KeyFactory.getInstance("RSA");
                RSAPublicKey pubKey = (RSAPublicKey)keyfac.generatePublic(spec);
                at = (pubKey.getModulus().bitLength() + 7) / 8;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            encrpt_key = new byte[at];
            int aCount = data.length;
            byte[] encrypt_data = new byte[data.length - at];
            int j = 0;
            while (j < at) {
                encrpt_key[j] = data[j];
                ++j;
            }
            j = at;
            while (j < aCount) {
                encrypt_data[j - at] = data[j];
                ++j;
            }
            byte[] bKey = this.decryptByPrivateKey((PrivateKey)this.getPrivateKeyFromStore(oKeyStore, sAlias, sPin), encrpt_key, sAlg, sAlgProvider);
            Sdbi sdbi = new Sdbi();
            byte[] origin = sdbi.SDBIDecryptData(encrypt_data, bKey);
            envelope = origin;
        }
        return envelope;
    }

    public byte[] envelope(int i, byte[] out_data, Certificate oCert, PrivateKey oPrivateKey, String sAlg, String sProviderName, String sAlgProvider) {
        byte[] encrpt_key;
        byte[] envelope = null;
        if (i == 1) {
            try {
                String ranAlg = "SHA1PRNG";
                if (sAlgProvider.equals("SwxaJCE")) {
                    ranAlg = "RND";
                } else if (sAlgProvider.equals("FishermanJCE")) {
                    ranAlg = "TrueRandom";
                }
                byte[] bRan = this.random(16, ranAlg, sProviderName);
                Sdbi sdbi = new Sdbi();
                byte[] encrypt_data = sdbi.SDBIEncryptData(out_data, bRan);
                PublicKey pbkey = oCert.getPublicKey();
                encrpt_key = this.encryptByPublicKey(pbkey, bRan, sAlg, sAlgProvider);
                envelope = new byte[encrypt_data.length + encrpt_key.length];
                envelope = javasafeengine.getMergeBytes(encrpt_key, encrypt_data);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (i == 2) {
            PublicKey pubkey = oCert.getPublicKey();
            byte[] pbkey = pubkey.getEncoded();
            int at = 0;
            X509EncodedKeySpec spec = new X509EncodedKeySpec(pbkey);
            try {
                KeyFactory keyfac = KeyFactory.getInstance("RSA");
                RSAPublicKey pubKey = (RSAPublicKey)keyfac.generatePublic(spec);
                at = (pubKey.getModulus().bitLength() + 7) / 8;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            encrpt_key = new byte[at];
            int aCount = out_data.length;
            byte[] encrypt_data = new byte[out_data.length - at];
            int j = 0;
            while (j < at) {
                encrpt_key[j] = out_data[j];
                ++j;
            }
            j = at;
            while (j < aCount) {
                encrypt_data[j - at] = out_data[j];
                ++j;
            }
            byte[] bKey = this.decryptByPrivateKey(oPrivateKey, encrpt_key, sAlg, sAlgProvider);
            Sdbi sdbi = new Sdbi();
            byte[] origin = sdbi.SDBIDecryptData(encrypt_data, bKey);
            envelope = origin;
        }
        return envelope;
    }

    public byte[] envelope(int i, byte[] out_data, Certificate oCert, PrivateKey oPrivateKey, String sAlg, String sProviderName, String sAlgProvider, String ranAlg, String encAlg) {
        byte[] encrpt_key;
        byte[] envelope = null;
        if (i == 1) {
            try {
                int iByteLen = 0;
                iByteLen = encAlg.indexOf("DES") == 0 ? 8 : (encAlg.indexOf("TripleDES") >= 0 ? 24 : 16);
                byte[] bRan = this.random(iByteLen, ranAlg, sProviderName);
                byte[] encrypt_data = null;
                Sdbi sdbi = new Sdbi();
                encrypt_data = encAlg.equals("DES") ? this.encrypt(out_data, bRan, encAlg, sAlgProvider) : (encAlg.equals("TripleDES") ? this.encrypt(out_data, bRan, encAlg, sAlgProvider) : sdbi.SDBIEncryptData(out_data, bRan));
                PublicKey pbkey = oCert.getPublicKey();
                encrpt_key = this.encryptByPublicKey(pbkey, bRan, sAlg, sAlgProvider);
                envelope = new byte[encrypt_data.length + encrpt_key.length];
                envelope = javasafeengine.getMergeBytes(encrpt_key, encrypt_data);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (i == 2) {
            PublicKey pubkey = oCert.getPublicKey();
            byte[] pbkey = pubkey.getEncoded();
            int at = 0;
            X509EncodedKeySpec spec = new X509EncodedKeySpec(pbkey);
            try {
                KeyFactory keyfac = KeyFactory.getInstance("RSA");
                RSAPublicKey pubKey = (RSAPublicKey)keyfac.generatePublic(spec);
                at = (pubKey.getModulus().bitLength() + 7) / 8;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            encrpt_key = new byte[at];
            int aCount = out_data.length;
            byte[] encrypt_data = new byte[out_data.length - at];
            int j = 0;
            while (j < at) {
                encrpt_key[j] = out_data[j];
                ++j;
            }
            j = at;
            while (j < aCount) {
                encrypt_data[j - at] = out_data[j];
                ++j;
            }
            byte[] bKey = this.decryptByPrivateKey(oPrivateKey, encrpt_key, sAlg, sAlgProvider);
            byte[] origin = null;
            if (encAlg.indexOf("DES") == 0) {
                origin = this.decrypt(encrypt_data, bKey, encAlg, sAlgProvider);
            } else if (encAlg.indexOf("TripleDES") >= 0) {
                origin = this.decrypt(encrypt_data, bKey, encAlg, sAlgProvider);
            } else {
                Sdbi sdbi = new Sdbi();
                origin = sdbi.SDBIDecryptData(encrypt_data, bKey);
            }
            envelope = origin;
        }
        return envelope;
    }

    /*
     * Unable to fully structure code
     */
    byte[] envelopeSM2_P7(int i, byte[] inputdata, KeyStore keystore, String provider, String algProvider, String skeyPin, int keynum) throws Exception {
        block5: {
            block3: {
                block4: {
                    outdata = null;
                    if (i != 1) break block3;
                    encrpytcontentinfo = new ASN1Encodable[3];
                    conType = new DERObjectIdentifier("1.2.840.113549.1.7.1");
                    encrpytcontentinfo[0] = conType;
                    AlgorithmIdentifier1 = new ASN1Encodable[]{new DERObjectIdentifier("1.2.156.10197.1.102"), new DERNull()};
                    ds = new DERSequence(AlgorithmIdentifier1);
                    encrpytcontentinfo[1] = ds;
                    ecryptAlg = new AlgorithmIdentifier((ASN1Sequence)ds);
                    receptInfoinfo = new ASN1Encodable[4];
                    version = new DERInteger(1);
                    receptInfoinfo[0] = version;
                    nameDN = null;
                    serialNumber = null;
                    oEnum = this.getAliasEnum(keystore);
                    sAlias = null;
                    if (oEnum != null) ** GOTO lbl21
                    System.out.println("alias is null");
                    break block4;
lbl-1000:
                    // 1 sources

                    {
                        sAlias = (String)oEnum.nextElement();
lbl21:
                        // 2 sources

                        ** while (oEnum.hasMoreElements())
                    }
                }
                oCert = this.getCertFromStore(keystore, sAlias, skeyPin);
                asn1Input = new ASN1InputStream((InputStream)new ByteArrayInputStream(oCert.getEncoded()));
                asn1X509 = asn1Input.readObject();
                alg = "SM1";
                key = null;
                kg = KeyGenerator.getInstance(alg, provider);
                kg.init(256);
                key = kg.generateKey();
                if (key == null) {
                    System.err.println("fail\uff01");
                } else {
                    System.out.println("ok\uff01");
                }
                symmetrykey = key.getEncoded();
                ecryptedkey = this.encryptByPublicKeySM2(symmetrykey, algProvider, keynum);
                x509 = X509CertificateStructure.getInstance((Object)asn1X509);
                serialNumber = new DERInteger(x509.getSerialNumber().getValue());
                dn = ((X509Certificate)oCert).getSubjectX500Principal().getName();
                nameDN = new X509Name(dn);
                issuer = new IssuerAndSerialNumber(nameDN, serialNumber);
                receptInfoinfo[1] = issuer.getDERObject();
                keyidentifier = new DERObjectIdentifier("1.2.156.10197.1.301.3");
                keyseq = new DERSequence((DEREncodable)keyidentifier);
                receptInfoinfo[2] = keyseq;
                receptInfoinfo[3] = new DEROctetString(ecryptedkey);
                ecryptedtext = this.symetryEncryptBySM2(inputdata, alg, "SM1/ECB/PKCS5PADDING", algProvider);
                ecryptecontent1 = new EncryptedContentInfo(conType, ecryptAlg, (ASN1OctetString)new DEROctetString(ecryptedtext));
                encrpytcontentinfoSeq = new DERSequence((DEREncodable)ecryptecontent1);
                receptInfoSeq = new DERSequence(receptInfoinfo);
                receptInfoSet = new DERSet((DEREncodable)receptInfoSeq);
                temp = new ASN1Encodable[3];
                universal = new DERInteger(0);
                temp[0] = universal;
                temp[1] = receptInfoSet;
                temp[2] = encrpytcontentinfoSeq;
                tempSeq = new DERSequence(temp);
                evelopeIdentifier = new DERObjectIdentifier("1.2.840.113549.1.7.3");
                contentinfo2 = new ContentInfo(evelopeIdentifier, (DEREncodable)tempSeq);
                evlope = new EnvelopedData(null, (ASN1Set)receptInfoSet, ecryptecontent1, null);
                contentinfo2 = new ContentInfo(evelopeIdentifier, (DEREncodable)evlope);
                outdata = contentinfo2.getEncoded();
                break block5;
            }
            contentinfo = ContentInfo.getInstance((Object)ASN1Object.fromByteArray((byte[])inputdata));
            parseevlope = new EnvelopedData((ASN1Sequence)((DERSequence)contentinfo.getContent()));
            encrypte = parseevlope.getEncryptedContentInfo();
            reset = (DERSet)parseevlope.getRecipientInfos();
            dseq = (DERSequence)reset.getObjectAt(0);
            enckey = (DEROctetString)dseq.getObjectAt(3);
            tempbnkey = enckey.getOctets();
            tempdseq = (DERSequence)DERSequence.getInstance((Object)ASN1Object.fromByteArray((byte[])tempbnkey));
            bsenckey = tempdseq.getDEREncoded();
            parseecryptekey = javasafeengine.decryptByPrivateKeySM2(bsenckey, keynum, algProvider, "SM2");
            encrypte1 = (DEROctetString)encrypte.getEncryptedContent();
            bencrypte1 = encrypte1.getDEREncoded();
            bsencrypte1y = new byte[bencrypte1.length - 2];
            System.arraycopy(bencrypte1, 2, bsencrypte1y, 0, bencrypte1.length - 2);
            oKeySpec = new SecretKeySpec(parseecryptekey, "SM1");
            outdata = javasafeengine.symetryDecryptBySM2(oKeySpec, "SM1/ECB/PKCS5PADDING", bsencrypte1y);
        }
        return outdata;
    }

    public byte[] encryptByPublicKeySM2(byte[] plain, String provider, int keynum) {
        String transformation = "SM2";
        KeyPair kp = null;
        byte[] tEncrypt = null;
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("SM2", provider);
            kpg.initialize(keynum << 16);
            kp = kpg.genKeyPair();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(transformation, provider);
            cipher.init(1, kp.getPublic());
            tEncrypt = cipher.doFinal(plain);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(transformation) + " Mode Encrypt and Decrypt ERROR!");
            e.printStackTrace();
        }
        return tEncrypt;
    }

    public byte[] symetryEncryptBySM2(byte[] plain, String alg, String transformation, String provider) {
        SecretKey key = null;
        int keylength = 256;
        byte[] tTemp = null;
        try {
            KeyGenerator kg = KeyGenerator.getInstance(alg, provider);
            kg.init(keylength);
            key = kg.generateKey();
            if (key == null) {
                System.err.println("fail\uff01");
            } else {
                System.out.println("ok\uff01");
            }
            Cipher cipher = null;
            cipher = Cipher.getInstance(transformation, provider);
            cipher.init(1, key);
            tTemp = cipher.doFinal(plain);
            if (tTemp == null) {
                System.err.println(String.valueOf(transformation) + " Mode Encrypt ERROR! Return value is NULL!");
            } else {
                System.err.println(String.valueOf(transformation) + " Mode Encrypt Success!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tTemp;
    }

    private static byte[] symetryDecryptBySM2(Key key, String transformation, byte[] plain) {
        Cipher cipher = null;
        byte[] tTemp = null;
        try {
            cipher = Cipher.getInstance(transformation, "SwxaJCE");
            cipher.init(2, key);
            tTemp = cipher.doFinal(plain);
            if (tTemp == null) {
                System.err.println(String.valueOf(transformation) + " Mode Decrypt ERROR! Return value is NULL!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tTemp;
    }

    public static byte[] decryptByPrivateKeySM2(byte[] plain, int keynum, String provider, String transformation) {
        KeyPair kp = null;
        byte[] tTemp = null;
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("SM2", provider);
            kpg.initialize(keynum << 16);
            kp = kpg.genKeyPair();
            if (kp == null) {
                System.out.println("fail\uff01");
            } else {
                System.out.println("ok\uff01");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(transformation, provider);
            cipher.init(2, kp.getPrivate());
            tTemp = cipher.doFinal(plain);
            if (tTemp == null) {
                System.out.println(String.valueOf(transformation) + " Mode Decrypt ERROR! Return value is NULL!");
            }
            if (new String(plain).equals(new String(tTemp))) {
                System.out.println(String.valueOf(transformation) + " Mode Encrypt and Decrypt Success!");
            } else {
                System.out.println(String.valueOf(transformation) + " Mode Encrypt and Decrypt ERROR!");
            }
        }
        catch (Exception e) {
            System.out.println(String.valueOf(transformation) + " Mode Encrypt and Decrypt ERROR!");
            e.printStackTrace();
        }
        return tTemp;
    }

    public static byte[] getMergeBytes(byte[] pByteA, byte[] pByteB) {
        int aCount = pByteA.length;
        int bCount = pByteB.length;
        byte[] b = new byte[aCount + bCount];
        int i = 0;
        while (i < aCount) {
            b[i] = pByteA[i];
            ++i;
        }
        i = 0;
        while (i < bCount) {
            b[aCount + i] = pByteB[i];
            ++i;
        }
        return b;
    }

    public void encrypt(String srcPath, String desPath, byte[] bKey, String sAlg, String sProviderName) throws Exception {
        Cipher c1 = null;
        SecretKeySpec oKeySpec = null;
        File file = new File(desPath);
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        RandomAccessFile randomAccessFile = null;
        try {
            try {
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                oKeySpec = new SecretKeySpec(bKey, sAlg);
                c1 = Cipher.getInstance(sAlg, sProviderName);
                c1.init(1, oKeySpec);
                randomAccessFile = new RandomAccessFile(desPath, "rw");
                fileInputStream = new FileInputStream(srcPath);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                byte[] buf = new byte[this.block];
                byte[] tempByte = null;
                int length = 0;
                while ((length = bufferedInputStream.read(buf)) != -1) {
                    tempByte = c1.update(buf, 0, length);
                    randomAccessFile.write(tempByte);
                }
                tempByte = c1.doFinal();
                randomAccessFile.write(tempByte);
            }
            catch (Exception e) {
                file.delete();
                throw e;
            }
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                    randomAccessFile = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                    bufferedInputStream = null;
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void decrypt(String srcPath, String desPath, byte[] bKey, String sAlg, String sProviderName) throws Exception {
        Cipher c1 = null;
        SecretKeySpec oKeySpec = null;
        File file = new File(desPath);
        RandomAccessFile randomAccessFile = null;
        FilterOutputStream bufferedOutputStream = null;
        byte[] tempByte = null;
        try {
            try {
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                oKeySpec = new SecretKeySpec(bKey, sAlg);
                c1 = Cipher.getInstance(sAlg, sProviderName);
                c1.init(2, oKeySpec);
                randomAccessFile = new RandomAccessFile(srcPath, "r");
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(desPath));
                byte[] buf = new byte[this.block];
                int length = 0;
                while ((length = randomAccessFile.read(buf)) != -1) {
                    tempByte = c1.update(buf, 0, length);
                    bufferedOutputStream.write(tempByte);
                }
                tempByte = c1.doFinal();
                bufferedOutputStream.write(tempByte);
            }
            catch (Exception e) {
                file.delete();
                throw e;
            }
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
                randomAccessFile = null;
            }
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
                bufferedOutputStream = null;
            }
        }
    }

    public boolean verifySign(String srcPath, byte[] bSign, String sAlg, Certificate oCert, String sProviderName) throws Exception {
        Signature oSig = null;
        boolean bRet = false;
        Provider oProvider = null;
        oProvider = Security.getProvider(sProviderName);
        oSig = Signature.getInstance(sAlg, oProvider);
        oSig.initVerify(oCert);
        byte[] bData = new byte[this.block];
        int length = 0;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = new FileInputStream(srcPath);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            while ((length = bufferedInputStream.read(bData)) != -1) {
                oSig.update(bData, 0, length);
            }
            bRet = oSig.verify(bSign);
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
                bufferedInputStream = null;
            }
            if (fileInputStream != null) {
                fileInputStream.close();
                fileInputStream = null;
            }
        }
        return bRet;
    }

    private byte[] getCertInfoOnLine(String extOid, X509Certificate oCert, String cagURL) {
        byte[] bRet;
        block23: {
            bRet = null;
            String commonOid = "1.2.156.112570.11.205";
            byte[] gextVal = this.getCAGCertInfo(commonOid, oCert);
            if (gextVal == null) {
                return null;
            }
            DefaultHttpClient client = new DefaultHttpClient();
            HttpPost httpPost = null;
            JSONObject requestMsg = new JSONObject();
            requestMsg.put((Object)"gextval", (Object)new String(gextVal));
            requestMsg.put((Object)"extoid", (Object)extOid);
            String smsg = requestMsg.toString();
            ArrayList<BasicNameValuePair> dataList = new ArrayList<BasicNameValuePair>();
            dataList.add(new BasicNameValuePair("smsg", smsg));
            ByteArrayOutputStream bytestream = null;
            InputStream inputStream = null;
            try {
                try {
                    int ch;
                    httpPost = new HttpPost(cagURL);
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(dataList, "UTF-8");
                    httpPost.setEntity((HttpEntity)entity);
                    HttpResponse response = client.execute((HttpUriRequest)httpPost);
                    inputStream = response.getEntity().getContent();
                    bytestream = new ByteArrayOutputStream();
                    while ((ch = inputStream.read()) != -1) {
                        bytestream.write(ch);
                    }
                    bRet = bytestream.toByteArray();
                    JSONArray resultMsg = JSONArray.fromObject((Object)new String(bRet));
                    if (resultMsg != null && resultMsg.size() > 0) {
                        JSONObject resultJObj = resultMsg.getJSONObject(0);
                        bRet = resultJObj.getString("extval").getBytes();
                        break block23;
                    }
                    bRet = null;
                }
                catch (Exception exception) {
                    if (bytestream != null) {
                        try {
                            bytestream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (inputStream == null) break block23;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (bytestream != null) {
                    try {
                        bytestream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bRet;
    }

    private byte[] getCAGCertInfo(String sOid, X509Certificate oCert) {
        byte[] bRet = null;
        try {
            bRet = oCert.getExtensionValue(sOid);
            DEROctetString dRet = (DEROctetString)DEROctetString.fromByteArray((byte[])bRet);
            bRet = dRet.getOctets();
            ASN1Object aRet = ASN1Object.fromByteArray((byte[])bRet);
            String type = aRet.getClass().getName();
            if ("org.bouncycastle.asn1.DERPrintableString".equals(type)) {
                DERPrintableString pntStr = (DERPrintableString)DERPrintableString.fromByteArray((byte[])bRet);
                bRet = pntStr.getString().getBytes();
            } else if ("org.bouncycastle.asn1.DERTaggedObject".equals(type)) {
                DERTaggedObject tobj = (DERTaggedObject)DERTaggedObject.fromByteArray((byte[])bRet);
                int tagNo = tobj.getTagNo();
                switch (tagNo) {
                    case 1: {
                        DERUTF8String tagUTFStr = (DERUTF8String)tobj.getObject();
                        bRet = tagUTFStr.getString().getBytes();
                        break;
                    }
                    case 0: 
                    case 2: {
                        DERPrintableString tagPntStr = (DERPrintableString)tobj.getObject();
                        bRet = tagPntStr.getString().getBytes();
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bRet;
    }

    public byte[] externalPublicKeyEnc(PublicKey pubkey, byte[] inData) {
        byte[] r = null;
        Cipher cp = null;
        try {
            cp = Cipher.getInstance("RSA/2/PKCS1PADDING", "FishermanJCE");
            cp.init(1, pubkey);
            r = cp.doFinal(inData);
        }
        catch (Exception e) {
            System.out.printf(e.toString(), new Object[0]);
        }
        return r;
    }

    public byte[] externalPrivateKeyDec(PrivateKey prikey, byte[] inData) {
        byte[] r = null;
        Cipher cp = null;
        try {
            cp = Cipher.getInstance("RSA/1/PKCS1PADDING", "FishermanJCE");
            cp.init(2, prikey);
            r = cp.doFinal(inData);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.printf(e.toString(), new Object[0]);
        }
        return r;
    }
}

