/*
 * Decompiled with CFR 0.152.
 */
package com.cib.fintech.dfp.open.sdk.config;

import com.cib.fintech.dfp.open.sdk.config.GrayConfigure;
import com.cib.fintech.dfp.open.sdk.enums.KeySignTypeEnum;
import com.cib.fintech.dfp.open.sdk.enums.RespSignAlgorithmEnum;
import com.cib.fintech.dfp.open.sdk.util.Base64;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Enumeration;

public class KeyConfigure {
    private String keyId;
    private String priKey;
    private String respPubKey;
    private String reqParamEncryptKey;
    private KeySignTypeEnum keySignType = KeySignTypeEnum.SM3WITHSM2;
    private boolean respSignSwitch = false;
    private RespSignAlgorithmEnum respSignAlgorithm = RespSignAlgorithmEnum.SM3WITHSM2;
    private String certProtectionPwd = null;
    private GrayConfigure grayConfigure = null;
    private String xCfcaBasic = null;
    private String enterpriseBearer = null;
    private String certFilePath;
    private String certPassword;
    private String sslCertFilePath;

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getPriKey() {
        return this.priKey;
    }

    public void setPriKey(String priKey) {
        this.priKey = priKey;
    }

    public KeySignTypeEnum getKeySignType() {
        return this.keySignType;
    }

    public void setKeySignType(KeySignTypeEnum keySignType) {
        this.keySignType = keySignType;
    }

    public boolean isRespSignSwitch() {
        return this.respSignSwitch;
    }

    public void setRespSignSwitch(boolean respSignSwitch) {
        this.respSignSwitch = respSignSwitch;
    }

    public RespSignAlgorithmEnum getRespSignAlgorithm() {
        return this.respSignAlgorithm;
    }

    public void setRespSignAlgorithm(RespSignAlgorithmEnum respSignAlgorithm) {
        this.respSignAlgorithm = respSignAlgorithm;
    }

    public String getRespPubKey() {
        return this.respPubKey;
    }

    public void setRespPubKey(String respPubKey) {
        this.respPubKey = respPubKey;
    }

    public String getReqParamEncryptKey() {
        return this.reqParamEncryptKey;
    }

    public void setReqParamEncryptKey(String reqParamEncryptKey) {
        this.reqParamEncryptKey = reqParamEncryptKey;
    }

    public String getCertProtectionPwd() {
        return this.certProtectionPwd;
    }

    public void setCertProtectionPwd(String certProtectionPwd) {
        this.certProtectionPwd = certProtectionPwd;
    }

    public String getCertFilePath() {
        return this.certFilePath;
    }

    public void setCertFilePath(String certFilePath) {
        this.certFilePath = certFilePath;
    }

    public String getCertPassword() {
        return this.certPassword;
    }

    public void setCertPassword(String certPassword) {
        this.certPassword = certPassword;
    }

    public String getSslCertFilePath() {
        return this.sslCertFilePath;
    }

    public void setSslCertFilePath(String sslCertFilePath) {
        this.sslCertFilePath = sslCertFilePath;
    }

    public KeyConfigure() {
    }

    public KeyConfigure(String keyId, String priKey, KeySignTypeEnum keySignType, boolean respSignSwitch, RespSignAlgorithmEnum respSignAlgorithm, String respPubKey, String reqParamEncryptKey, String certProtectionPwd, GrayConfigure grayConfigure) {
        this.keyId = keyId;
        this.priKey = priKey;
        this.keySignType = keySignType;
        this.respSignSwitch = respSignSwitch;
        this.respSignAlgorithm = respSignAlgorithm;
        this.respPubKey = respPubKey;
        this.reqParamEncryptKey = reqParamEncryptKey;
        this.certProtectionPwd = certProtectionPwd;
        this.grayConfigure = grayConfigure;
    }

    public GrayConfigure getGrayConfigure() {
        return this.grayConfigure;
    }

    public void setGrayConfigure(GrayConfigure grayConfigure) {
        this.grayConfigure = grayConfigure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCfcaProperties(String cfcaCertFilename, String cfcaProtectionPwd, KeySignTypeEnum keySignType) {
        FileInputStream fis = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            fis = new FileInputStream(cfcaCertFilename);
            char[] password = cfcaProtectionPwd == null ? null : cfcaProtectionPwd.toCharArray();
            keyStore.load(fis, password);
            Enumeration<String> aliases = keyStore.aliases();
            if (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(alias);
                StringBuilder sb = new StringBuilder();
                sb.append(x509Certificate.getSerialNumber()).append("|");
                sb.append(x509Certificate.getSigAlgName()).append("|");
                sb.append(x509Certificate.getIssuerDN()).append("|");
                sb.append(x509Certificate.getSubjectDN()).append("|");
                sb.append(sdf.format(x509Certificate.getNotBefore())).append("-").append(sdf.format(x509Certificate.getNotAfter()));
                this.xCfcaBasic = Base64.encode(sb.toString().getBytes(StandardCharsets.UTF_8));
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password);
                this.priKey = Base64.encode(privateKey.getEncoded());
                this.keySignType = keySignType;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getXCfcaBasic() {
        return this.xCfcaBasic;
    }

    public String getEnterpriseBearer() {
        return this.enterpriseBearer;
    }

    public void setEnterpriseBearer(String enterpriseId, String productId, String acctNo) {
        StringBuilder sb = new StringBuilder();
        sb.append(enterpriseId).append("&");
        sb.append(productId).append("&");
        sb.append(acctNo);
        this.enterpriseBearer = "Bearer " + Base64.encode(sb.toString().getBytes(StandardCharsets.UTF_8));
    }
}

