/*
 * Decompiled with CFR 0.152.
 */
package com.cgb.skms;

import com.alibaba.fastjson.JSON;
import com.cgb.skms.util.FileUtil;
import com.cgb.skms.util.GetKeyMessage;
import com.cgb.skms.util.Hex;
import com.cgb.skms.util.KeyException;
import com.cgb.skms.util.SM2Util;
import com.cgb.skms.util.SM4Util;
import java.io.IOException;
import java.util.Hashtable;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;

public class SmAlgorithm
extends GetKeyMessage {
    public static Hashtable<String, String> sm4Encrypt(String keyId, String value, boolean isECB) throws KeyException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String resultCode = "000000";
        String sm4Code = null;
        if (securityKey.containsKey(keyId)) {
            Hashtable table = (Hashtable)JSON.parseObject((String)String.valueOf(securityKey.get(keyId)), Hashtable.class);
            try {
                sm4Code = isECB ? Hex.encode(SM4Util.encryptECB(value.getBytes(), Hex.decode((String)table.get("keyValue")))) : Hex.encode(SM4Util.encryptCBC(value.getBytes(), Hex.decode((String)table.get("keyValue")), "0000000000000000000000000000".getBytes()));
            }
            catch (DataLengthException e) {
                resultCode = "1021";
                e.printStackTrace();
            }
            catch (IllegalStateException e) {
                resultCode = "2200";
                e.printStackTrace();
            }
        } else {
            throw new KeyException("\u5bc6\u94a5\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u67e5\u8be2\u5bc6\u94a5");
        }
        result.put("resultCode", resultCode);
        if ("000000".equals(resultCode)) {
            result.put("ciphertext", sm4Code);
        } else {
            result.put("ciphertext", "");
        }
        return result;
    }

    public static Hashtable<String, String> sm4Decrypt(String keyId, String code, boolean isECB) throws KeyException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String resultCode = "000000";
        String data = null;
        if (securityKey.containsKey(keyId)) {
            Hashtable table = (Hashtable)JSON.parseObject((String)((String)securityKey.get(keyId)), Hashtable.class);
            try {
                data = isECB ? new String(SM4Util.decryptECB(Hex.decode(code), Hex.decode((String)table.get("keyValue")))) : new String(SM4Util.decryptCBC(Hex.decode(code), Hex.decode((String)table.get("keyValue")), "0000000000000000000000000000".getBytes()));
            }
            catch (DataLengthException e) {
                resultCode = "1001";
                e.printStackTrace();
            }
            catch (IllegalStateException e) {
                resultCode = "2200";
                e.printStackTrace();
            }
        } else {
            throw new KeyException("\u5bc6\u94a5\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u67e5\u8be2\u5bc6\u94a5");
        }
        result.put("resultCode", resultCode);
        if ("000000".equals(resultCode)) {
            result.put("plaintext", data);
        } else {
            result.put("plaintext", "");
        }
        return result;
    }

    public static Hashtable<String, String> sm2Encrypt(String keyId, String value) throws KeyException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String resultCode = "000000";
        String sm2Code = null;
        if (securityKey.containsKey(keyId)) {
            Hashtable table = (Hashtable)JSON.parseObject((String)String.valueOf(securityKey.get(keyId)), Hashtable.class);
            try {
                sm2Code = Hex.encode(SM2Util.encrypt(Hex.decode((String)table.get("pbkValue")), value.getBytes()));
            }
            catch (InvalidCipherTextException e) {
                resultCode = "9003";
                e.printStackTrace();
            }
            catch (IOException e) {
                resultCode = "1100";
                e.printStackTrace();
            }
        } else {
            throw new KeyException("\u5bc6\u94a5\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u67e5\u8be2\u5bc6\u94a5");
        }
        result.put("resultCode", resultCode);
        if ("000000".equals(resultCode)) {
            result.put("ciphertext", sm2Code);
        } else {
            result.put("ciphertext", "");
        }
        return result;
    }

    public static Hashtable<String, String> sm2Decrypt(String keyId, String code) throws KeyException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String resultCode = "000000";
        String data = null;
        if (securityKey.containsKey(keyId)) {
            Hashtable table = (Hashtable)JSON.parseObject((String)String.valueOf(securityKey.get(keyId)), Hashtable.class);
            try {
                data = new String(SM2Util.decrypt(Hex.decode((String)table.get("keyValue")), Hex.decode(code)));
            }
            catch (InvalidCipherTextException e) {
                resultCode = "9003";
                e.printStackTrace();
            }
            catch (IOException e) {
                resultCode = "1100";
                e.printStackTrace();
            }
        } else {
            throw new KeyException("\u5bc6\u94a5\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u67e5\u8be2\u5bc6\u94a5");
        }
        result.put("resultCode", resultCode);
        if ("000000".equals(resultCode)) {
            result.put("plaintext", data);
        } else {
            result.put("plaintext", "");
        }
        return result;
    }

    public static String getKey(String keyID) throws KeyException {
        if (securityKey.containsKey(keyID)) {
            Hashtable table = (Hashtable)JSON.parseObject((String)String.valueOf(securityKey.get(keyID)), Hashtable.class);
            String algorithm = (String)table.get("algorithm");
            return algorithm.toLowerCase();
        }
        throw new KeyException("\u5185\u5b58\u4e2d\u6ca1\u6709\u8be5\u5bc6\u94a5");
    }

    public static String sm4Encrypt(byte[] keyByte, String value, boolean isECB) {
        String sm4Code = null;
        sm4Code = isECB ? Hex.encode(SM4Util.encryptECB(value.getBytes(), keyByte)) : Hex.encode(SM4Util.encryptCBC(value.getBytes(), keyByte, "0000000000000000000000000000".getBytes()));
        return sm4Code;
    }

    public static String sm4Decrypt(byte[] keyByte, String code, boolean isECB) {
        String data = null;
        if (isECB) {
            try {
                data = new String(SM4Util.decryptECB(Hex.decode(code), keyByte));
            }
            catch (KeyException e) {
                e.printStackTrace();
            }
        } else {
            try {
                data = new String(SM4Util.decryptCBC(Hex.decode(code), keyByte, "0000000000000000000000000000".getBytes()));
            }
            catch (KeyException e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    public static String encryptFile(String keyId, String inFlie, String outFlieName, String outFliePath) throws KeyException {
        String resultCode = "000000";
        byte[] data = null;
        if (securityKey.containsKey(keyId)) {
            Hashtable table = (Hashtable)JSON.parseObject((String)String.valueOf(securityKey.get(keyId)), Hashtable.class);
            try {
                data = SM4Util.encryptECB(FileUtil.getBytesByFile(inFlie), Hex.decode((String)table.get("keyValue")));
            }
            catch (DataLengthException e) {
                resultCode = "1021";
                e.printStackTrace();
            }
            catch (IllegalStateException e) {
                resultCode = "2200";
                e.printStackTrace();
            }
        } else {
            throw new KeyException("\u5bc6\u94a5\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u67e5\u8be2\u5bc6\u94a5");
        }
        FileUtil.getFileByBytes(data, outFliePath, outFlieName);
        return resultCode;
    }

    public static String decryptFile(String keyId, String inFlie, String outFlieName, String outFliePath) throws KeyException {
        String resultCode = "000000";
        byte[] data = null;
        if (securityKey.containsKey(keyId)) {
            Hashtable table = (Hashtable)JSON.parseObject((String)String.valueOf(securityKey.get(keyId)), Hashtable.class);
            try {
                data = SM4Util.decryptECB(FileUtil.getBytesByFile(inFlie), Hex.decode((String)table.get("keyValue")));
            }
            catch (DataLengthException e) {
                resultCode = "1021";
                e.printStackTrace();
            }
            catch (IllegalStateException e) {
                resultCode = "2200";
                e.printStackTrace();
            }
        } else {
            throw new KeyException("\u5bc6\u94a5\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u67e5\u8be2\u5bc6\u94a5");
        }
        FileUtil.getFileByBytes(data, outFliePath, outFlieName);
        return resultCode;
    }
}

