/*
 * Decompiled with CFR 0.152.
 */
package com.cgb.skms.util;

import com.alibaba.fastjson.JSON;
import com.cgb.skms.util.Hex;
import com.cgb.skms.util.Httpconnect;
import com.cgb.skms.util.KeyException;
import com.cgb.skms.util.NumberException;
import com.cgb.skms.util.SM2Util;
import com.cgb.skms.util.SM4Util;
import com.cgb.skms.util.SerialNumber;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class GetKeyMessage {
    public static Hashtable<String, String> securityKey = new Hashtable();
    private static String authorize = "";
    static final String version = "1.0.0";

    public static Hashtable<String, String> checkCode(int flag, String systemShortName, String keyId, String authPath, String pubPath, String queryPath, String upLoad) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String reCode = "000000";
        if (flag == 1) {
            if (securityKey.containsKey(keyId)) {
                result.put("resultCode", reCode);
                Hashtable table = (Hashtable)JSON.parseObject((String)String.valueOf(securityKey.get(keyId)), Hashtable.class);
                result.put("checkValue", (String)table.get("checkValue"));
                result.put("keyValue", (String)table.get("keyValue"));
                result.put("algorithm", (String)table.get("algorithm"));
                if (((String)table.get("algorithm")).toLowerCase().equals("sm2")) {
                    result.put("pbkValue", (String)table.get("pbkValue"));
                }
            } else {
                try {
                    result = GetKeyMessage.upLoadCode(keyId, authPath, systemShortName, pubPath, queryPath, upLoad);
                }
                catch (NumberException e) {
                    e.printStackTrace();
                    reCode = "8823";
                }
                catch (KeyException e) {
                    e.printStackTrace();
                    reCode = "3060";
                }
                result.put("resultCode", reCode);
            }
        } else if (flag == 2) {
            if (securityKey.containsKey(keyId)) {
                securityKey.remove(keyId);
            }
            try {
                result = GetKeyMessage.upLoadCode(keyId, authPath, systemShortName, pubPath, queryPath, upLoad);
            }
            catch (NumberException e) {
                e.printStackTrace();
                reCode = "8823";
            }
            catch (KeyException e) {
                e.printStackTrace();
                reCode = "3060";
            }
            result.put("resultCode", reCode);
        }
        return result;
    }

    private static Hashtable<String, String> upLoadCode(String keyID, String authPath, String systemShortName, String pubPath, String queryPath, String upLoad) throws NumberException, KeyException {
        String sm4Key = null;
        String result = null;
        String messageCode = null;
        String keyCode = null;
        int flag = 0;
        int j = 0;
        sm4Key = Hex.encode(SM4Util.generateKey(128));
        GetKeyMessage.readAuthorize(authPath);
        String messageStr = GetKeyMessage.getmessage(keyID, systemShortName);
        messageCode = Hex.encode(SM4Util.encryptECB(Hex.decode(GetKeyMessage.stringToHexString(messageStr)), Hex.decode(sm4Key)));
        String publicKey = null;
        String temp = null;
        Hashtable<String, String> upTemp = new Hashtable<String, String>();
        upTemp.put("sessionKey", "583624");
        upTemp.put("report", "son");
        do {
            try {
                ++j;
                temp = GetKeyMessage.connectTask(pubPath, upTemp);
                if (temp == null) {
                    flag = 1;
                    continue;
                }
                flag = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                flag = 1;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        } while (flag == 1 && j < 3);
        if (0 == flag) {
            Hashtable tableResult = (Hashtable)JSON.parseObject((String)String.valueOf(temp), Hashtable.class);
            publicKey = (String)tableResult.get("secondKey");
            try {
                keyCode = Hex.encode(SM2Util.encrypt(Hex.decode(publicKey), Hex.decode(GetKeyMessage.stringToHexString(sm4Key))));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Hashtable<String, String> codes = new Hashtable<String, String>();
            codes.put("sessionKey", keyCode);
            codes.put("report", messageCode);
            result = null;
            j = 0;
            do {
                try {
                    ++j;
                    result = GetKeyMessage.connectTask(queryPath, codes);
                    if (result != null) {
                        flag = 0;
                        continue;
                    }
                    flag = 1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    flag = 2;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            } while (flag == 2 && j < 3);
        }
        if (0 == flag) {
            Hashtable retMessage = (Hashtable)JSON.parseObject((String)String.valueOf(result), Hashtable.class);
            if (!"0000".equals(retMessage.get("retcode"))) {
                throw new KeyException((String)retMessage.get("retMsg"));
            }
            String report = new String(SM4Util.decryptECB(Hex.decode((String)retMessage.get("report")), Hex.decode(sm4Key)));
            Hashtable table = (Hashtable)JSON.parseObject((String)String.valueOf(report), Hashtable.class);
            Hashtable<String, String> tmp = new Hashtable<String, String>();
            tmp.put("checkValue", (String)table.get("checkValue"));
            tmp.put("keyValue", (String)table.get("keyValue"));
            tmp.put("algorithm", (String)table.get("algorithm"));
            if (((String)table.get("algorithm")).toLowerCase().equals("sm2")) {
                tmp.put("pbkValue", (String)table.get("pbkValue"));
            }
            securityKey.put(keyID, JSON.toJSONString(tmp));
            return tmp;
        }
        if (0 != flag && !securityKey.containsKey(keyID)) {
            return GetKeyMessage.standByCode(keyID, upLoad);
        }
        return (Hashtable)JSON.parseObject((String)String.valueOf(securityKey.get(keyID)), Hashtable.class);
    }

    public static Hashtable<String, String> standByCode(String keyID, String upLoad) {
        int i;
        Hashtable<String, String> secuKey = new Hashtable<String, String>();
        String keyBack = upLoad;
        int len = keyBack.length();
        if (0 != len % 4) {
            int num = 4 - len % 4;
            for (i = 0; i < num; ++i) {
                keyBack = keyBack + "0";
            }
        }
        ArrayList<String> keyList = new ArrayList<String>();
        for (i = 0; i < len; i += 4) {
            keyList.add(keyBack.substring(i, i + 4));
        }
        if (((String)keyList.get(0)).startsWith("02")) {
            String priKey = "";
            int index = Integer.parseInt(((String)keyList.get(2)).substring(2));
            int keyLen = Integer.parseInt(((String)keyList.get(2)).substring(0, 2), 16);
            while ((priKey = priKey + ((String)keyList.get(index)).substring(0, 2)).length() < keyLen) {
                index = Integer.parseInt(((String)keyList.get(index)).substring(2));
                if (priKey.length() < keyLen) continue;
            }
            String pubKey = "";
            index = Integer.parseInt(((String)keyList.get(1)).substring(2));
            keyLen = Integer.parseInt(((String)keyList.get(1)).substring(0, 2), 16);
            while ((pubKey = pubKey + ((String)keyList.get(index)).substring(0, 2)).length() < keyLen) {
                index = Integer.parseInt(((String)keyList.get(index)).substring(2));
                if (pubKey.length() < keyLen) continue;
            }
            secuKey.put("keyValue", priKey);
            secuKey.put("pbkValue", pubKey);
            secuKey.put("checkValue", " ");
            secuKey.put("algorithm", "sm2");
            securityKey.put(keyID, JSON.toJSONString(secuKey));
        } else if (((String)keyList.get(0)).startsWith("04")) {
            String key = "";
            int index = Integer.parseInt(((String)keyList.get(1)).substring(2));
            int keyLen = Integer.parseInt(((String)keyList.get(1)).substring(0, 2), 16);
            while ((key = key + ((String)keyList.get(index)).substring(0, 2)).length() < keyLen) {
                index = Integer.parseInt(((String)keyList.get(index)).substring(2));
                if (key.length() < keyLen) continue;
            }
            secuKey.put("keyValue", key);
            secuKey.put("checkValue", " ");
            secuKey.put("algorithm", "sm4");
            securityKey.put(keyID, JSON.toJSONString(secuKey));
        }
        return secuKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readAuthorize(String authorizePath) throws KeyException {
        File file = new File(authorizePath);
        authorize = "";
        if (!file.exists()) {
            throw new KeyException("\u6388\u6743\u6587\u4ef6\u8def\u5f84\u9519\u8bef");
        }
        BufferedReader br = null;
        InputStreamReader inputStreamReader = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(authorizePath);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "gbk");
            br = new BufferedReader(inputStreamReader);
            String str = null;
            while (null != (str = br.readLine())) {
                authorize = authorize + str;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
                inputStreamReader.close();
                fileInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getmessage(String keyID, String systemShortName) throws NumberException {
        Hashtable<String, String> message = new Hashtable<String, String>();
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        message.put("timestamp", df.format(date));
        message.put("keyName", keyID);
        message.put("token", authorize);
        message.put("version", version);
        SerialNumber sn = new SerialNumber("SM");
        message.put("tradeId", sn.generate());
        message.put("systemShortName", systemShortName);
        String messageStr = JSON.toJSONString(message);
        return messageStr;
    }

    public static String stringToHexString(String s) {
        String str = "";
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            String s4 = Integer.toHexString(ch);
            str = str + s4;
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String connectTask(final String path, final Hashtable<String, String> data) throws TimeoutException {
        ExecutorService exec = null;
        final String[] result = new String[1];
        try {
            exec = Executors.newFixedThreadPool(1);
            Callable call = new Callable(){

                public String call() throws Exception {
                    result[0] = Httpconnect.httpPost(path, data);
                    return null;
                }
            };
            Future future = exec.submit(call);
            future.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        finally {
            if (exec != null) {
                exec.shutdownNow();
            }
        }
        return result[0];
    }

    public static String toFormatUnicode(String strText) {
        String strRet = "";
        for (int i = 0; i < strText.length(); ++i) {
            char c;
            char intAsc = c = strText.charAt(i);
            String strHex = Integer.toHexString(intAsc);
            strRet = intAsc > '\u0080' ? strRet + strHex : strRet + "00" + strHex;
        }
        return strRet;
    }

    public static String toUnFormatUnicode(String s) {
        int[] baKeyword = new int[s.length() / 4];
        for (int i = 0; i < baKeyword.length; ++i) {
            try {
                baKeyword[i] = 0xFFFF & Integer.parseInt(s.substring(i * 4, i * 4 + 4), 16);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            s = new String(baKeyword, 0, baKeyword.length);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return s;
    }

    public static Hashtable<String, String> checkCode(String keyId, String upLoad) {
        Hashtable<String, String> key = GetKeyMessage.standByCode(keyId, upLoad);
        key.put(keyId, JSON.toJSONString(key));
        if (key != null) {
            key.put("resultCode", "000000");
        } else {
            key.put("resultCode", null);
        }
        return key;
    }
}

