/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.generators;

import com.nbcb.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.nbcb.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.nbcb.bouncycastle.crypto.CryptoServicesRegistrar;
import com.nbcb.bouncycastle.crypto.KeyGenerationParameters;
import com.nbcb.bouncycastle.crypto.params.ECDomainParameters;
import com.nbcb.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.nbcb.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.nbcb.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.nbcb.bouncycastle.math.ec.ECConstants;
import com.nbcb.bouncycastle.math.ec.ECMultiplier;
import com.nbcb.bouncycastle.math.ec.ECPoint;
import com.nbcb.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.nbcb.bouncycastle.math.ec.WNafUtil;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    @Override
    public void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters ecP = (ECKeyGenerationParameters)param;
        this.random = ecP.getRandom();
        this.params = ecP.getDomainParameters();
        if (this.random == null) {
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger d;
        BigInteger n = this.params.getN();
        int nBitLength = n.bitLength();
        int minWeight = nBitLength >>> 2;
        while ((d = new BigInteger(nBitLength, this.random)).compareTo(TWO) < 0 || d.compareTo(n) >= 0 || WNafUtil.getNafWeight(d) < minWeight) {
        }
        ECPoint Q = this.createBasePointMultiplier().multiply(this.params.getG(), d);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(Q, this.params), new ECPrivateKeyParameters(d, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

