/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.tls;

import com.nbcb.bouncycastle.asn1.ASN1Primitive;
import com.nbcb.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class Certificate {
    public static final Certificate EMPTY_CHAIN = new Certificate(new com.nbcb.bouncycastle.asn1.x509.Certificate[0]);
    protected com.nbcb.bouncycastle.asn1.x509.Certificate[] certificateList;

    public Certificate(com.nbcb.bouncycastle.asn1.x509.Certificate[] certificateList) {
        if (certificateList == null) {
            throw new IllegalArgumentException("'certificateList' cannot be null");
        }
        this.certificateList = certificateList;
    }

    public com.nbcb.bouncycastle.asn1.x509.Certificate[] getCertificateList() {
        return this.cloneCertificateList();
    }

    public com.nbcb.bouncycastle.asn1.x509.Certificate getCertificateAt(int index) {
        return this.certificateList[index];
    }

    public int getLength() {
        return this.certificateList.length;
    }

    public boolean isEmpty() {
        return this.certificateList.length == 0;
    }

    public void encode(OutputStream output) throws IOException {
        byte[] derEncoding;
        int i;
        Vector<byte[]> derEncodings = new Vector<byte[]>(this.certificateList.length);
        int totalLength = 0;
        for (i = 0; i < this.certificateList.length; ++i) {
            derEncoding = this.certificateList[i].getEncoded("DER");
            derEncodings.addElement(derEncoding);
            totalLength += derEncoding.length + 3;
        }
        TlsUtils.checkUint24(totalLength);
        TlsUtils.writeUint24(totalLength, output);
        for (i = 0; i < derEncodings.size(); ++i) {
            derEncoding = (byte[])derEncodings.elementAt(i);
            TlsUtils.writeOpaque24(derEncoding, output);
        }
    }

    public static Certificate parse(InputStream input) throws IOException {
        int totalLength = TlsUtils.readUint24(input);
        if (totalLength == 0) {
            return EMPTY_CHAIN;
        }
        byte[] certListData = TlsUtils.readFully(totalLength, input);
        ByteArrayInputStream buf = new ByteArrayInputStream(certListData);
        Vector<com.nbcb.bouncycastle.asn1.x509.Certificate> certificate_list = new Vector<com.nbcb.bouncycastle.asn1.x509.Certificate>();
        while (buf.available() > 0) {
            byte[] berEncoding = TlsUtils.readOpaque24(buf);
            ASN1Primitive asn1Cert = TlsUtils.readASN1Object(berEncoding);
            certificate_list.addElement(com.nbcb.bouncycastle.asn1.x509.Certificate.getInstance(asn1Cert));
        }
        com.nbcb.bouncycastle.asn1.x509.Certificate[] certificateList = new com.nbcb.bouncycastle.asn1.x509.Certificate[certificate_list.size()];
        for (int i = 0; i < certificate_list.size(); ++i) {
            certificateList[i] = (com.nbcb.bouncycastle.asn1.x509.Certificate)certificate_list.elementAt(i);
        }
        return new Certificate(certificateList);
    }

    protected com.nbcb.bouncycastle.asn1.x509.Certificate[] cloneCertificateList() {
        com.nbcb.bouncycastle.asn1.x509.Certificate[] result = new com.nbcb.bouncycastle.asn1.x509.Certificate[this.certificateList.length];
        System.arraycopy(this.certificateList, 0, result, 0, result.length);
        return result;
    }
}

