/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.tls;

import com.nbcb.bouncycastle.crypto.Digest;
import com.nbcb.bouncycastle.crypto.tls.CombinedHash;
import com.nbcb.bouncycastle.crypto.tls.DigestInputBuffer;
import com.nbcb.bouncycastle.crypto.tls.HashAlgorithm;
import com.nbcb.bouncycastle.crypto.tls.TlsContext;
import com.nbcb.bouncycastle.crypto.tls.TlsHandshakeHash;
import com.nbcb.bouncycastle.crypto.tls.TlsUtils;
import com.nbcb.bouncycastle.util.Shorts;
import java.util.Enumeration;
import java.util.Hashtable;

class DeferredHash
implements TlsHandshakeHash {
    protected static final int BUFFERING_HASH_LIMIT = 4;
    protected TlsContext context;
    private DigestInputBuffer buf;
    private Hashtable hashes;
    private Short prfHashAlgorithm;

    DeferredHash() {
        this.buf = new DigestInputBuffer();
        this.hashes = new Hashtable();
        this.prfHashAlgorithm = null;
    }

    private DeferredHash(Short prfHashAlgorithm, Digest prfHash) {
        this.buf = null;
        this.hashes = new Hashtable();
        this.prfHashAlgorithm = prfHashAlgorithm;
        this.hashes.put(prfHashAlgorithm, prfHash);
    }

    @Override
    public void init(TlsContext context) {
        this.context = context;
    }

    @Override
    public TlsHandshakeHash notifyPRFDetermined() {
        int prfAlgorithm = this.context.getSecurityParameters().getPrfAlgorithm();
        if (prfAlgorithm == 0) {
            CombinedHash legacyHash = new CombinedHash();
            legacyHash.init(this.context);
            this.buf.updateDigest(legacyHash);
            return legacyHash.notifyPRFDetermined();
        }
        this.prfHashAlgorithm = Shorts.valueOf(TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm));
        this.checkTrackingHash(this.prfHashAlgorithm);
        return this;
    }

    @Override
    public void trackHashAlgorithm(short hashAlgorithm) {
        if (this.buf == null) {
            throw new IllegalStateException("Too late to track more hash algorithms");
        }
        this.checkTrackingHash(Shorts.valueOf(hashAlgorithm));
    }

    @Override
    public void sealHashAlgorithms() {
        this.checkStopBuffering();
    }

    @Override
    public TlsHandshakeHash stopTracking() {
        Digest prfHash = TlsUtils.cloneHash(this.prfHashAlgorithm, (Digest)this.hashes.get(this.prfHashAlgorithm));
        if (this.buf != null) {
            this.buf.updateDigest(prfHash);
        }
        DeferredHash result = new DeferredHash(this.prfHashAlgorithm, prfHash);
        result.init(this.context);
        return result;
    }

    @Override
    public Digest forkPRFHash() {
        this.checkStopBuffering();
        if (this.buf != null) {
            Digest prfHash = TlsUtils.createHash(this.prfHashAlgorithm);
            this.buf.updateDigest(prfHash);
            return prfHash;
        }
        return TlsUtils.cloneHash(this.prfHashAlgorithm, (Digest)this.hashes.get(this.prfHashAlgorithm));
    }

    @Override
    public byte[] getFinalHash(short hashAlgorithm) {
        Digest d = (Digest)this.hashes.get(Shorts.valueOf(hashAlgorithm));
        if (d == null) {
            throw new IllegalStateException("HashAlgorithm." + HashAlgorithm.getText(hashAlgorithm) + " is not being tracked");
        }
        d = TlsUtils.cloneHash(hashAlgorithm, d);
        if (this.buf != null) {
            this.buf.updateDigest(d);
        }
        byte[] bs = new byte[d.getDigestSize()];
        d.doFinal(bs, 0);
        return bs;
    }

    @Override
    public String getAlgorithmName() {
        throw new IllegalStateException("Use fork() to get a definite Digest");
    }

    @Override
    public int getDigestSize() {
        throw new IllegalStateException("Use fork() to get a definite Digest");
    }

    @Override
    public void update(byte input) {
        if (this.buf != null) {
            this.buf.write(input);
            return;
        }
        Enumeration e = this.hashes.elements();
        while (e.hasMoreElements()) {
            Digest hash = (Digest)e.nextElement();
            hash.update(input);
        }
    }

    @Override
    public void update(byte[] input, int inOff, int len) {
        if (this.buf != null) {
            this.buf.write(input, inOff, len);
            return;
        }
        Enumeration e = this.hashes.elements();
        while (e.hasMoreElements()) {
            Digest hash = (Digest)e.nextElement();
            hash.update(input, inOff, len);
        }
    }

    @Override
    public int doFinal(byte[] output, int outOff) {
        throw new IllegalStateException("Use fork() to get a definite Digest");
    }

    @Override
    public void reset() {
        if (this.buf != null) {
            this.buf.reset();
            return;
        }
        Enumeration e = this.hashes.elements();
        while (e.hasMoreElements()) {
            Digest hash = (Digest)e.nextElement();
            hash.reset();
        }
    }

    protected void checkStopBuffering() {
        if (this.buf != null && this.hashes.size() <= 4) {
            Enumeration e = this.hashes.elements();
            while (e.hasMoreElements()) {
                Digest hash = (Digest)e.nextElement();
                this.buf.updateDigest(hash);
            }
            this.buf = null;
        }
    }

    protected void checkTrackingHash(Short hashAlgorithm) {
        if (!this.hashes.containsKey(hashAlgorithm)) {
            Digest hash = TlsUtils.createHash(hashAlgorithm);
            this.hashes.put(hashAlgorithm, hash);
        }
    }
}

