/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.math.ec.custom.sec;

import com.nbcb.bouncycastle.math.raw.Interleave;
import com.nbcb.bouncycastle.math.raw.Nat192;
import java.math.BigInteger;

public class SecT163Field {
    private static final long M35 = 0x7FFFFFFFFL;
    private static final long M55 = 0x7FFFFFFFFFFFFFL;
    private static final long[] ROOT_Z = new long[]{-5270498306774157648L, 5270498306774195053L, 0x492492492L};

    public static void add(long[] x, long[] y, long[] z) {
        z[0] = x[0] ^ y[0];
        z[1] = x[1] ^ y[1];
        z[2] = x[2] ^ y[2];
    }

    public static void addExt(long[] xx, long[] yy, long[] zz) {
        zz[0] = xx[0] ^ yy[0];
        zz[1] = xx[1] ^ yy[1];
        zz[2] = xx[2] ^ yy[2];
        zz[3] = xx[3] ^ yy[3];
        zz[4] = xx[4] ^ yy[4];
        zz[5] = xx[5] ^ yy[5];
    }

    public static void addOne(long[] x, long[] z) {
        z[0] = x[0] ^ 1L;
        z[1] = x[1];
        z[2] = x[2];
    }

    public static long[] fromBigInteger(BigInteger x) {
        long[] z = Nat192.fromBigInteger64(x);
        SecT163Field.reduce29(z, 0);
        return z;
    }

    public static void invert(long[] x, long[] z) {
        if (Nat192.isZero64(x)) {
            throw new IllegalStateException();
        }
        long[] t0 = Nat192.create64();
        long[] t1 = Nat192.create64();
        SecT163Field.square(x, t0);
        SecT163Field.squareN(t0, 1, t1);
        SecT163Field.multiply(t0, t1, t0);
        SecT163Field.squareN(t1, 1, t1);
        SecT163Field.multiply(t0, t1, t0);
        SecT163Field.squareN(t0, 3, t1);
        SecT163Field.multiply(t0, t1, t0);
        SecT163Field.squareN(t1, 3, t1);
        SecT163Field.multiply(t0, t1, t0);
        SecT163Field.squareN(t0, 9, t1);
        SecT163Field.multiply(t0, t1, t0);
        SecT163Field.squareN(t1, 9, t1);
        SecT163Field.multiply(t0, t1, t0);
        SecT163Field.squareN(t0, 27, t1);
        SecT163Field.multiply(t0, t1, t0);
        SecT163Field.squareN(t1, 27, t1);
        SecT163Field.multiply(t0, t1, t0);
        SecT163Field.squareN(t0, 81, t1);
        SecT163Field.multiply(t0, t1, z);
    }

    public static void multiply(long[] x, long[] y, long[] z) {
        long[] tt = Nat192.createExt64();
        SecT163Field.implMultiply(x, y, tt);
        SecT163Field.reduce(tt, z);
    }

    public static void multiplyAddToExt(long[] x, long[] y, long[] zz) {
        long[] tt = Nat192.createExt64();
        SecT163Field.implMultiply(x, y, tt);
        SecT163Field.addExt(zz, tt, zz);
    }

    public static void reduce(long[] xx, long[] z) {
        long x0 = xx[0];
        long x1 = xx[1];
        long x2 = xx[2];
        long x3 = xx[3];
        long x4 = xx[4];
        long x5 = xx[5];
        x2 ^= x5 << 29 ^ x5 << 32 ^ x5 << 35 ^ x5 << 36;
        x1 ^= x4 << 29 ^ x4 << 32 ^ x4 << 35 ^ x4 << 36;
        long t = (x2 ^= x4 >>> 35 ^ x4 >>> 32 ^ x4 >>> 29 ^ x4 >>> 28) >>> 35;
        z[0] = (x0 ^= (x3 ^= x5 >>> 35 ^ x5 >>> 32 ^ x5 >>> 29 ^ x5 >>> 28) << 29 ^ x3 << 32 ^ x3 << 35 ^ x3 << 36) ^ t ^ t << 3 ^ t << 6 ^ t << 7;
        z[1] = x1 ^= x3 >>> 35 ^ x3 >>> 32 ^ x3 >>> 29 ^ x3 >>> 28;
        z[2] = x2 & 0x7FFFFFFFFL;
    }

    public static void reduce29(long[] z, int zOff) {
        long z2 = z[zOff + 2];
        long t = z2 >>> 35;
        int n = zOff;
        z[n] = z[n] ^ (t ^ t << 3 ^ t << 6 ^ t << 7);
        z[zOff + 2] = z2 & 0x7FFFFFFFFL;
    }

    public static void sqrt(long[] x, long[] z) {
        long[] odd = Nat192.create64();
        long u0 = Interleave.unshuffle(x[0]);
        long u1 = Interleave.unshuffle(x[1]);
        long e0 = u0 & 0xFFFFFFFFL | u1 << 32;
        odd[0] = u0 >>> 32 | u1 & 0xFFFFFFFF00000000L;
        u0 = Interleave.unshuffle(x[2]);
        long e1 = u0 & 0xFFFFFFFFL;
        odd[1] = u0 >>> 32;
        SecT163Field.multiply(odd, ROOT_Z, z);
        z[0] = z[0] ^ e0;
        z[1] = z[1] ^ e1;
    }

    public static void square(long[] x, long[] z) {
        long[] tt = Nat192.createExt64();
        SecT163Field.implSquare(x, tt);
        SecT163Field.reduce(tt, z);
    }

    public static void squareAddToExt(long[] x, long[] zz) {
        long[] tt = Nat192.createExt64();
        SecT163Field.implSquare(x, tt);
        SecT163Field.addExt(zz, tt, zz);
    }

    public static void squareN(long[] x, int n, long[] z) {
        long[] tt = Nat192.createExt64();
        SecT163Field.implSquare(x, tt);
        SecT163Field.reduce(tt, z);
        while (--n > 0) {
            SecT163Field.implSquare(z, tt);
            SecT163Field.reduce(tt, z);
        }
    }

    public static int trace(long[] x) {
        return (int)(x[0] ^ x[2] >>> 29) & 1;
    }

    protected static void implCompactExt(long[] zz) {
        long z0 = zz[0];
        long z1 = zz[1];
        long z2 = zz[2];
        long z3 = zz[3];
        long z4 = zz[4];
        long z5 = zz[5];
        zz[0] = z0 ^ z1 << 55;
        zz[1] = z1 >>> 9 ^ z2 << 46;
        zz[2] = z2 >>> 18 ^ z3 << 37;
        zz[3] = z3 >>> 27 ^ z4 << 28;
        zz[4] = z4 >>> 36 ^ z5 << 19;
        zz[5] = z5 >>> 45;
    }

    protected static void implMultiply(long[] x, long[] y, long[] zz) {
        long f0 = x[0];
        long f1 = x[1];
        long f2 = x[2];
        f2 = f1 >>> 46 ^ f2 << 18;
        f1 = (f0 >>> 55 ^ f1 << 9) & 0x7FFFFFFFFFFFFFL;
        f0 &= 0x7FFFFFFFFFFFFFL;
        long g0 = y[0];
        long g1 = y[1];
        long g2 = y[2];
        g2 = g1 >>> 46 ^ g2 << 18;
        g1 = (g0 >>> 55 ^ g1 << 9) & 0x7FFFFFFFFFFFFFL;
        long[] H = new long[10];
        SecT163Field.implMulw(f0, g0 &= 0x7FFFFFFFFFFFFFL, H, 0);
        SecT163Field.implMulw(f2, g2, H, 2);
        long t0 = f0 ^ f1 ^ f2;
        long t1 = g0 ^ g1 ^ g2;
        SecT163Field.implMulw(t0, t1, H, 4);
        long t2 = f1 << 1 ^ f2 << 2;
        long t3 = g1 << 1 ^ g2 << 2;
        SecT163Field.implMulw(f0 ^ t2, g0 ^ t3, H, 6);
        SecT163Field.implMulw(t0 ^ t2, t1 ^ t3, H, 8);
        long t4 = H[6] ^ H[8];
        long t5 = H[7] ^ H[9];
        long v0 = t4 << 1 ^ H[6];
        long v1 = t4 ^ t5 << 1 ^ H[7];
        long v2 = t5;
        long u0 = H[0];
        long u1 = H[1] ^ H[0] ^ H[4];
        long u2 = H[1] ^ H[5];
        long w0 = u0 ^ v0 ^ H[2] << 4 ^ H[2] << 1;
        long w1 = u1 ^ v1 ^ H[3] << 4 ^ H[3] << 1;
        long w2 = u2 ^ v2;
        w1 ^= w0 >>> 55;
        w0 &= 0x7FFFFFFFFFFFFFL;
        w2 ^= w1 >>> 55;
        w0 = w0 >>> 1 ^ ((w1 &= 0x7FFFFFFFFFFFFFL) & 1L) << 54;
        w1 = w1 >>> 1 ^ (w2 & 1L) << 54;
        w2 >>>= 1;
        w0 ^= w0 << 1;
        w0 ^= w0 << 2;
        w0 ^= w0 << 4;
        w0 ^= w0 << 8;
        w0 ^= w0 << 16;
        w0 ^= w0 << 32;
        w1 ^= (w0 &= 0x7FFFFFFFFFFFFFL) >>> 54;
        w1 ^= w1 << 1;
        w1 ^= w1 << 2;
        w1 ^= w1 << 4;
        w1 ^= w1 << 8;
        w1 ^= w1 << 16;
        w1 ^= w1 << 32;
        w2 ^= (w1 &= 0x7FFFFFFFFFFFFFL) >>> 54;
        w2 ^= w2 << 1;
        w2 ^= w2 << 2;
        w2 ^= w2 << 4;
        w2 ^= w2 << 8;
        w2 ^= w2 << 16;
        w2 ^= w2 << 32;
        zz[0] = u0;
        zz[1] = u1 ^ w0 ^ H[2];
        zz[2] = u2 ^ w1 ^ w0 ^ H[3];
        zz[3] = w2 ^ w1;
        zz[4] = w2 ^ H[2];
        zz[5] = H[3];
        SecT163Field.implCompactExt(zz);
    }

    protected static void implMulw(long x, long y, long[] z, int zOff) {
        long[] u = new long[8];
        u[1] = y;
        u[2] = u[1] << 1;
        u[3] = u[2] ^ y;
        u[4] = u[2] << 1;
        u[5] = u[4] ^ y;
        u[6] = u[3] << 1;
        u[7] = u[6] ^ y;
        int j = (int)x;
        long h = 0L;
        long l = u[j & 3];
        int k = 47;
        do {
            j = (int)(x >>> k);
            long g = u[j & 7] ^ u[j >>> 3 & 7] << 3 ^ u[j >>> 6 & 7] << 6;
            l ^= g << k;
            h ^= g >>> -k;
        } while ((k -= 9) > 0);
        z[zOff] = l & 0x7FFFFFFFFFFFFFL;
        z[zOff + 1] = l >>> 55 ^ h << 9;
    }

    protected static void implSquare(long[] x, long[] zz) {
        Interleave.expand64To128(x[0], zz, 0);
        Interleave.expand64To128(x[1], zz, 2);
        long x2 = x[2];
        zz[4] = Interleave.expand32to64((int)x2);
        zz[5] = (long)Interleave.expand8to16((int)(x2 >>> 32)) & 0xFFFFFFFFL;
    }
}

