/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.aes.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URLConnection;
import javax.net.ssl.HttpsURLConnection;

public class URLConnectionAdapter {
    private boolean isHttps = false;
    private HttpURLConnection httpURLConnection;
    private HttpsURLConnection httpsURLConnection;

    public URLConnectionAdapter(String urlStr, URLConnection urlConnection) {
        if (urlStr.startsWith("https")) {
            this.isHttps = true;
            this.httpsURLConnection = (HttpsURLConnection)urlConnection;
        } else {
            this.httpURLConnection = (HttpURLConnection)urlConnection;
        }
    }

    public void setRequestMethod(String method) throws ProtocolException {
        if (this.isHttps) {
            this.httpsURLConnection.setRequestMethod(method);
        } else {
            this.httpURLConnection.setRequestMethod(method);
        }
    }

    public void addRequestProperty(String key, String value) {
        if (this.isHttps) {
            this.httpsURLConnection.addRequestProperty(key, value);
        } else {
            this.httpURLConnection.addRequestProperty(key, value);
        }
    }

    public void setDoOutput(boolean dooutput) {
        if (this.isHttps) {
            this.httpsURLConnection.setDoOutput(dooutput);
        } else {
            this.httpURLConnection.setDoOutput(dooutput);
        }
    }

    public void setDoInput(boolean doinput) {
        if (this.isHttps) {
            this.httpsURLConnection.setDoInput(doinput);
        } else {
            this.httpURLConnection.setDoInput(doinput);
        }
    }

    public void setConnectTimeout(int timeout) {
        if (this.isHttps) {
            this.httpsURLConnection.setConnectTimeout(timeout);
        } else {
            this.httpURLConnection.setConnectTimeout(timeout);
        }
    }

    public void setReadTimeout(int timeout) {
        if (this.isHttps) {
            this.httpsURLConnection.setReadTimeout(timeout);
        } else {
            this.httpURLConnection.setReadTimeout(timeout);
        }
    }

    public void setUseCaches(boolean usecaches) {
        if (this.isHttps) {
            this.httpsURLConnection.setUseCaches(usecaches);
        } else {
            this.httpURLConnection.setUseCaches(usecaches);
        }
    }

    public void disconnect() {
        if (this.isHttps) {
            this.httpsURLConnection.disconnect();
        } else {
            this.httpURLConnection.disconnect();
        }
    }

    public int getResponseCode() throws IOException {
        if (this.isHttps) {
            return this.httpsURLConnection.getResponseCode();
        }
        return this.httpURLConnection.getResponseCode();
    }

    public InputStream getInputStream() throws IOException {
        if (this.isHttps) {
            return this.httpsURLConnection.getInputStream();
        }
        return this.httpURLConnection.getInputStream();
    }
}

