/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.gm;

import cn.com.infosec.netsign.crypto.util.Base64;
import com.nbcb.bouncycastle.asn1.gm.GMObjectIdentifiers;
import com.nbcb.bouncycastle.crypto.InvalidCipherTextException;
import com.nbcb.bouncycastle.crypto.engines.SM2Engine;
import com.nbcb.bouncycastle.crypto.params.ECDomainParameters;
import com.nbcb.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.nbcb.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.nbcb.bouncycastle.crypto.params.ParametersWithRandom;
import com.nbcb.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import com.nbcb.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import com.nbcb.bouncycastle.jce.provider.BouncyCastleProvider;
import com.nbcb.bouncycastle.jce.spec.ECParameterSpec;
import com.nbcb.sdk.gm.Utils;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.X509Certificate;

public class SM2Utils {
    public static byte[] encrypt(byte[] data, PublicKey publicKey) {
        ECPublicKeyParameters localECPublicKeyParameters = null;
        if (publicKey instanceof BCECPublicKey) {
            BCECPublicKey localECPublicKey = (BCECPublicKey)publicKey;
            ECParameterSpec localECParameterSpec = localECPublicKey.getParameters();
            ECDomainParameters localECDomainParameters = new ECDomainParameters(localECParameterSpec.getCurve(), localECParameterSpec.getG(), localECParameterSpec.getN());
            localECPublicKeyParameters = new ECPublicKeyParameters(localECPublicKey.getQ(), localECDomainParameters);
        }
        SM2Engine localSM2Engine = new SM2Engine();
        localSM2Engine.init(true, new ParametersWithRandom(localECPublicKeyParameters, new SecureRandom()));
        try {
            byte[] arrayOfByte2 = localSM2Engine.processBlock(data, 0, data.length);
            return arrayOfByte2;
        }
        catch (InvalidCipherTextException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decrypt(byte[] encodedata, PrivateKey privateKey) {
        SM2Engine localSM2Engine = new SM2Engine();
        BCECPrivateKey sm2PriK = (BCECPrivateKey)privateKey;
        ECParameterSpec localECParameterSpec = sm2PriK.getParameters();
        ECDomainParameters localECDomainParameters = new ECDomainParameters(localECParameterSpec.getCurve(), localECParameterSpec.getG(), localECParameterSpec.getN());
        ECPrivateKeyParameters localECPrivateKeyParameters = new ECPrivateKeyParameters(sm2PriK.getD(), localECDomainParameters);
        localSM2Engine.init(false, localECPrivateKeyParameters);
        try {
            byte[] arrayOfByte3 = localSM2Engine.processBlock(encodedata, 0, encodedata.length);
            return arrayOfByte3;
        }
        catch (InvalidCipherTextException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] signByPrivateKey(byte[] data, PrivateKey privateKey) throws Exception {
        Signature sig = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), "NBBC");
        sig.initSign(privateKey);
        sig.update(data);
        byte[] ret = sig.sign();
        return ret;
    }

    public static boolean verifyByPublicKey(byte[] data, PublicKey publicKey, byte[] signature) throws Exception {
        Signature sig = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), "NBBC");
        sig.initVerify(publicKey);
        sig.update(data);
        boolean ret = sig.verify(signature);
        return ret;
    }

    public static boolean verifyByCret(byte[] data, X509Certificate cret, byte[] signature) throws Exception {
        Utils.formatSM2Signature(Base64.encode((byte[])signature));
        Signature sig = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), "NBBC");
        sig.initVerify(cret);
        sig.update(data);
        boolean ret = sig.verify(signature);
        return ret;
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

