/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.gm.gmnew;

import com.nbcb.bouncycastle.util.encoders.Base64;
import com.nbcb.sdk.gm.gmnew.SM4;
import com.nbcb.sdk.gm.gmnew.SM4_Context;
import com.nbcb.sdk.gm.gmnew.Util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SM4Utils {
    private String secretKey = "";
    private String iv = "";
    private boolean hexString = false;

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public boolean isHexString() {
        return this.hexString;
    }

    public void setHexString(boolean hexString) {
        this.hexString = hexString;
    }

    public String getIv() {
        return this.iv;
    }

    public void setIv(String iv) {
        this.iv = iv;
    }

    public static byte[] encryptData_ECB(byte[] keyBytes, byte[] dataBytes) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            return sm4.sm4_crypt_ecb(ctx, dataBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decryptData_ECB(byte[] keyBytes, byte[] dataBytes) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            return sm4.sm4_crypt_ecb(ctx, dataBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String encryptData_CBC(String plainText) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (this.hexString) {
                keyBytes = Util.hexStringToBytes(this.secretKey);
                ivBytes = Util.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, plainText.getBytes("GBK"));
            String cipherText = Base64.toBase64String(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decryptData_CBC(String cipherText) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (this.hexString) {
                keyBytes = Util.hexStringToBytes(this.secretKey);
                ivBytes = Util.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, Base64.decode(cipherText));
            return new String(decrypted, "GBK");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

