/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.sdk.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import com.nbcb.sdk.log.ExceptionUtil;
import com.nbcb.sdk.log.Log;
import com.nbcb.sdk.log.NbczLogger;
import java.lang.reflect.Method;
import org.slf4j.Marker;
import org.slf4j.impl.StaticLoggerBinder;

public class Slf4jLogger
implements Log {
    public static final String FQCN = Slf4jLogger.class.getName();
    private final String name;
    private volatile transient Logger logger = null;

    public Slf4jLogger() {
        this.name = null;
    }

    public Slf4jLogger(String name) {
        this.name = name;
        this.logger = this.getLogger();
    }

    public Slf4jLogger(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("Warning - null logger in constructor; possible log4j misconfiguration.");
        }
        this.name = logger.getName();
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger() {
        Logger result = this.logger;
        if (result == null) {
            Slf4jLogger slf4jLogger = this;
            synchronized (slf4jLogger) {
                result = this.logger;
                if (result == null) {
                    StaticLoggerBinder singleton = StaticLoggerBinder.getSingleton();
                    this.logger = result = (Logger)singleton.getLoggerFactory().getLogger(this.name);
                }
            }
        }
        return result;
    }

    @Override
    public void trace(Object message) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.TRACE, NbczLogger.wrapMessage(message), null, null);
    }

    private void filterAndLog_0_Or3Plus(String localFQCN, Marker marker, Level level, String msg, Object[] params, Throwable t) {
        try {
            Method method = this.getLogger().getClass().getDeclaredMethod("filterAndLog_0_Or3Plus", String.class, Marker.class, Level.class, String.class, Object[].class, Throwable.class);
            method.setAccessible(true);
            method.invoke((Object)this.getLogger(), localFQCN, marker, level, msg, params, t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.TRACE, NbczLogger.wrapMessage(message), null, t);
    }

    @Override
    public void debug(Object message) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.DEBUG, NbczLogger.wrapMessage(message), null, null);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.DEBUG, NbczLogger.wrapMessage(message), null, t);
    }

    @Override
    public void info(Object message) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.INFO, NbczLogger.wrapMessage(message), null, null);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.INFO, NbczLogger.wrapMessage(message), null, t);
    }

    @Override
    public void warn(Object message) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.WARN, NbczLogger.wrapMessage(message), null, null);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.WARN, NbczLogger.wrapMessage(message), null, t);
    }

    @Override
    public void error(Object message) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.ERROR, NbczLogger.wrapMessage(message), null, null);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.filterAndLog_0_Or3Plus(FQCN, null, Level.ERROR, NbczLogger.wrapMessage(message), null, t);
    }

    @Override
    public void fatal(Object message) {
    }

    @Override
    public void fatal(Object message, Throwable t) {
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return false;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.getLogger().isWarnEnabled();
    }

    static {
        try {
            StaticLoggerBinder singleton = StaticLoggerBinder.getSingleton();
            LoggerContext lc = (LoggerContext)singleton.getLoggerFactory();
            lc.reset();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)lc);
            configurator.doConfigure(NbczLogger.LOGBACK_PATH);
            System.out.println("path:" + NbczLogger.LOGBACK_PATH);
        }
        catch (Exception e) {
            e.printStackTrace();
            NbczLogger.printMsg("nbcb-czsdk- init error" + ExceptionUtil.stacktraceToString(e));
        }
    }
}

