/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcpkix.org.bouncycastle.cert.path.validations;

import com.icbc.bcpkix.org.bouncycastle.cert.X509CRLHolder;
import com.icbc.bcpkix.org.bouncycastle.cert.X509CertificateHolder;
import com.icbc.bcpkix.org.bouncycastle.cert.path.CertPathValidation;
import com.icbc.bcpkix.org.bouncycastle.cert.path.CertPathValidationContext;
import com.icbc.bcpkix.org.bouncycastle.cert.path.CertPathValidationException;
import com.icbc.bcprov.org.bouncycastle.asn1.x500.X500Name;
import com.icbc.bcprov.org.bouncycastle.util.Memoable;
import com.icbc.bcprov.org.bouncycastle.util.Selector;
import com.icbc.bcprov.org.bouncycastle.util.Store;
import java.util.Collection;

public class CRLValidation
implements CertPathValidation {
    private Store crls;
    private X500Name workingIssuerName;

    public CRLValidation(X500Name x500Name, Store store) {
        this.workingIssuerName = x500Name;
        this.crls = store;
    }

    @Override
    public void validate(CertPathValidationContext certPathValidationContext, X509CertificateHolder x509CertificateHolder) throws CertPathValidationException {
        Collection collection = this.crls.getMatches(new Selector(){

            public boolean match(Object object) {
                X509CRLHolder x509CRLHolder = (X509CRLHolder)object;
                return x509CRLHolder.getIssuer().equals(CRLValidation.this.workingIssuerName);
            }

            @Override
            public Object clone() {
                return this;
            }
        });
        if (collection.isEmpty()) {
            throw new CertPathValidationException("CRL for " + this.workingIssuerName + " not found");
        }
        for (X509CRLHolder x509CRLHolder : collection) {
            if (x509CRLHolder.getRevokedCertificate(x509CertificateHolder.getSerialNumber()) == null) continue;
            throw new CertPathValidationException("Certificate revoked");
        }
        this.workingIssuerName = x509CertificateHolder.getSubject();
    }

    @Override
    public Memoable copy() {
        return new CRLValidation(this.workingIssuerName, this.crls);
    }

    @Override
    public void reset(Memoable memoable) {
        CRLValidation cRLValidation = (CRLValidation)memoable;
        this.workingIssuerName = cRLValidation.workingIssuerName;
        this.crls = cRLValidation.crls;
    }
}

