/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.bcprov.org.bouncycastle.pqc.crypto.util;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Set;
import com.icbc.bcprov.org.bouncycastle.asn1.DEROctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.XMSSMTPrivateKey;
import com.icbc.bcprov.org.bouncycastle.pqc.asn1.XMSSPrivateKey;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.util.Utils;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.icbc.bcprov.org.bouncycastle.util.Pack;
import java.io.IOException;

public class PrivateKeyInfoFactory {
    private PrivateKeyInfoFactory() {
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        return PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter, null);
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter, ASN1Set aSN1Set) throws IOException {
        if (asymmetricKeyParameter instanceof QTESLAPrivateKeyParameters) {
            QTESLAPrivateKeyParameters qTESLAPrivateKeyParameters = (QTESLAPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = Utils.qTeslaLookupAlgID(qTESLAPrivateKeyParameters.getSecurityCategory());
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(qTESLAPrivateKeyParameters.getSecret()), aSN1Set);
        }
        if (asymmetricKeyParameter instanceof SPHINCSPrivateKeyParameters) {
            SPHINCSPrivateKeyParameters sPHINCSPrivateKeyParameters = (SPHINCSPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(Utils.sphincs256LookupTreeAlgID(sPHINCSPrivateKeyParameters.getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(sPHINCSPrivateKeyParameters.getKeyData()));
        }
        if (asymmetricKeyParameter instanceof NHPrivateKeyParameters) {
            NHPrivateKeyParameters nHPrivateKeyParameters = (NHPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            short[] sArray = nHPrivateKeyParameters.getSecData();
            byte[] byArray = new byte[sArray.length * 2];
            for (int i = 0; i != sArray.length; ++i) {
                Pack.shortToLittleEndian(sArray[i], byArray, i * 2);
            }
            return new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
        }
        if (asymmetricKeyParameter instanceof XMSSPrivateKeyParameters) {
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters = (XMSSPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(xMSSPrivateKeyParameters.getParameters().getHeight(), Utils.xmssLookupTreeAlgID(xMSSPrivateKeyParameters.getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, PrivateKeyInfoFactory.xmssCreateKeyStructure(xMSSPrivateKeyParameters));
        }
        if (asymmetricKeyParameter instanceof XMSSMTPrivateKeyParameters) {
            XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = (XMSSMTPrivateKeyParameters)asymmetricKeyParameter;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyParams(xMSSMTPrivateKeyParameters.getParameters().getHeight(), xMSSMTPrivateKeyParameters.getParameters().getLayers(), Utils.xmssLookupTreeAlgID(xMSSMTPrivateKeyParameters.getTreeDigest())));
            return new PrivateKeyInfo(algorithmIdentifier, PrivateKeyInfoFactory.xmssmtCreateKeyStructure(xMSSMTPrivateKeyParameters));
        }
        throw new IOException("key parameters not recognized");
    }

    private static XMSSPrivateKey xmssCreateKeyStructure(XMSSPrivateKeyParameters xMSSPrivateKeyParameters) {
        byte[] byArray = xMSSPrivateKeyParameters.toByteArray();
        int n = xMSSPrivateKeyParameters.getParameters().getDigestSize();
        int n2 = xMSSPrivateKeyParameters.getParameters().getHeight();
        int n3 = 4;
        int n4 = n;
        int n5 = n;
        int n6 = n;
        int n7 = n;
        int n8 = 0;
        int n9 = (int)XMSSUtil.bytesToXBigEndian(byArray, n8, n3);
        if (!XMSSUtil.isIndexValid(n2, n9)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, n8 += n3, n4);
        byte[] byArray3 = XMSSUtil.extractBytesAtOffset(byArray, n8 += n4, n5);
        byte[] byArray4 = XMSSUtil.extractBytesAtOffset(byArray, n8 += n5, n6);
        byte[] byArray5 = XMSSUtil.extractBytesAtOffset(byArray, n8 += n6, n7);
        byte[] byArray6 = XMSSUtil.extractBytesAtOffset(byArray, n8 += n7, byArray.length - n8);
        return new XMSSPrivateKey(n9, byArray2, byArray3, byArray4, byArray5, byArray6);
    }

    private static XMSSMTPrivateKey xmssmtCreateKeyStructure(XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters) {
        byte[] byArray = xMSSMTPrivateKeyParameters.toByteArray();
        int n = xMSSMTPrivateKeyParameters.getParameters().getDigestSize();
        int n2 = xMSSMTPrivateKeyParameters.getParameters().getHeight();
        int n3 = (n2 + 7) / 8;
        int n4 = n;
        int n5 = n;
        int n6 = n;
        int n7 = n;
        int n8 = 0;
        int n9 = (int)XMSSUtil.bytesToXBigEndian(byArray, n8, n3);
        if (!XMSSUtil.isIndexValid(n2, n9)) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, n8 += n3, n4);
        byte[] byArray3 = XMSSUtil.extractBytesAtOffset(byArray, n8 += n4, n5);
        byte[] byArray4 = XMSSUtil.extractBytesAtOffset(byArray, n8 += n5, n6);
        byte[] byArray5 = XMSSUtil.extractBytesAtOffset(byArray, n8 += n6, n7);
        byte[] byArray6 = XMSSUtil.extractBytesAtOffset(byArray, n8 += n7, byArray.length - n8);
        return new XMSSMTPrivateKey(n9, byArray2, byArray3, byArray4, byArray5, byArray6);
    }
}

