/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.apiLib;

import com.icbc.hsm.software.basic.HsmKeyParameter;
import com.icbc.hsm.software.cert.CertHelper;
import com.icbc.hsm.software.config.IcbcEnvironment;
import com.icbc.hsm.software.external.ClearKeyFunction;
import com.icbc.hsm.software.parms.ClearKeyParameter;
import com.icbc.hsm.software.parms.icbc.IcbcAsymmetricKeyParameter;
import java.util.Arrays;

public class Signature {
    public static final String API_NAME = "signature";
    private String signatureAlgorithm = null;
    private byte[] id = null;

    private Signature(String string, byte[] byArray) {
        this.signatureAlgorithm = string;
        if (byArray != null) {
            this.id = Arrays.copyOf(byArray, byArray.length);
        }
    }

    public static Signature getInstance(String string) {
        Signature signature = new Signature(string, null);
        return signature;
    }

    public static Signature getInstance(byte[] byArray) {
        Signature signature = new Signature("SM3withSM2", byArray);
        return signature;
    }

    public byte[] sign(HsmKeyParameter hsmKeyParameter, byte[] byArray) throws Exception {
        if (this.id != null) {
            this.setIDtoKey(hsmKeyParameter);
        }
        byte[] byArray2 = com.icbc.hsm.software.basic.Signature.sign(this.signatureAlgorithm, hsmKeyParameter, byArray);
        return byArray2;
    }

    public boolean verify(HsmKeyParameter hsmKeyParameter, byte[] byArray, byte[] byArray2) throws Exception {
        if (this.id != null) {
            this.setIDtoKey(hsmKeyParameter);
        }
        boolean bl = com.icbc.hsm.software.basic.Signature.verify(this.signatureAlgorithm, hsmKeyParameter, byArray, byArray2);
        return bl;
    }

    public boolean verifyWithCert(byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        String string = CertHelper.parseSM2PublicKeyFromX509Cert(byArray);
        ClearKeyParameter clearKeyParameter = ClearKeyFunction.loadClear(string, "SM2Public");
        if (this.id != null) {
            this.setIDtoKey(clearKeyParameter);
        }
        return com.icbc.hsm.software.basic.Signature.verify(this.signatureAlgorithm, clearKeyParameter, byArray2, byArray3);
    }

    private void setIDtoKey(HsmKeyParameter hsmKeyParameter) {
        Object object;
        if (IcbcEnvironment.isICBCEnvironment() && hsmKeyParameter instanceof IcbcAsymmetricKeyParameter) {
            object = (IcbcAsymmetricKeyParameter)hsmKeyParameter;
            object.setId(this.id);
        }
        if (hsmKeyParameter instanceof ClearKeyParameter) {
            object = (ClearKeyParameter)hsmKeyParameter;
            ((ClearKeyParameter)object).setId(this.id);
        }
    }

    public String getParameter() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("signatureAlgorithm: ").append(this.signatureAlgorithm);
        return stringBuffer.toString();
    }
}

