/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1EncodableVector;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Integer;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Primitive;
import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Sequence;
import com.icbc.bcprov.org.bouncycastle.asn1.DEROctetString;
import com.icbc.bcprov.org.bouncycastle.asn1.DERSequence;
import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricBlockCipher;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.ExtendedDigest;
import com.icbc.bcprov.org.bouncycastle.crypto.InvalidCipherTextException;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.MD5Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA1Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA224Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA256Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA384Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA3Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.digests.SHA512Digest;
import com.icbc.bcprov.org.bouncycastle.crypto.encodings.ISO9796d1Encoding;
import com.icbc.bcprov.org.bouncycastle.crypto.encodings.OAEPEncoding;
import com.icbc.bcprov.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.RSAEngine;
import com.icbc.bcprov.org.bouncycastle.crypto.engines.SM2Engine;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.icbc.hsm.software.exception.ParmErrorException;
import com.icbc.hsm.software.utils.Helper;
import com.icbc.hsm.utils.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.spec.PSource;

public class AsymmetricCipher {
    private AsymmetricCipher() {
    }

    public static byte[] encipher(String string, boolean bl, CipherParameters cipherParameters, byte[] byArray) throws Exception {
        CipherParameters cipherParameters2 = Helper.toBCkey(cipherParameters);
        if ("SM2".equalsIgnoreCase(string)) {
            if (bl) {
                if (cipherParameters2 instanceof ECPublicKeyParameters) {
                    return AsymmetricCipher.sm2Encryption((ECPublicKeyParameters)cipherParameters2, byArray);
                }
                throw new ParmErrorException("Cipher key param error, SM2 ECPublicKeyParameters expected");
            }
            if (cipherParameters2 instanceof ECPrivateKeyParameters) {
                return AsymmetricCipher.sm2Decryption((ECPrivateKeyParameters)cipherParameters2, byArray);
            }
            throw new ParmErrorException("Cipher key param error, SM2 ECPrivateKeyParameters expected");
        }
        AsymmetricBlockCipher asymmetricBlockCipher = null;
        asymmetricBlockCipher = AsymmetricCipher.buildRSAEngine(string);
        return AsymmetricCipher.rsaProcess(asymmetricBlockCipher, bl, cipherParameters2, byArray);
    }

    private static AsymmetricBlockCipher buildRSAEngine(String string) {
        AsymmetricBlockCipher asymmetricBlockCipher = null;
        RSAEngine rSAEngine = new RSAEngine();
        ExtendedDigest extendedDigest = null;
        if ("NOPADDING".equalsIgnoreCase(string)) {
            asymmetricBlockCipher = new RSAEngine();
        } else if ("PKCS1PADDING".equalsIgnoreCase(string)) {
            asymmetricBlockCipher = new PKCS1Encoding(rSAEngine);
        } else if ("ISO9796-1PADDING".equalsIgnoreCase(string)) {
            asymmetricBlockCipher = new ISO9796d1Encoding(rSAEngine);
        } else if ("OAEPPadding".equalsIgnoreCase(string)) {
            asymmetricBlockCipher = new OAEPEncoding(rSAEngine);
        } else if ("OAEPWITHMD5ANDMGF1PADDING".equalsIgnoreCase(string)) {
            extendedDigest = new MD5Digest();
            asymmetricBlockCipher = new OAEPEncoding(rSAEngine, extendedDigest, null);
        } else if ("OAEPWITHSHA1ANDMGF1PADDING".equalsIgnoreCase(string) || "OAEPWITHSHA-1ANDMGF1PADDING".equalsIgnoreCase(string)) {
            extendedDigest = new SHA1Digest();
            asymmetricBlockCipher = new OAEPEncoding(rSAEngine, extendedDigest, null);
        } else if ("OAEPWITHSHA224ANDMGF1PADDING".equalsIgnoreCase(string) || "OAEPWITHSHA-224ANDMGF1PADDING".equalsIgnoreCase(string)) {
            extendedDigest = new SHA224Digest();
            asymmetricBlockCipher = new OAEPEncoding(rSAEngine, extendedDigest, null);
        } else if ("OAEPWITHSHA256ANDMGF1PADDING".equalsIgnoreCase(string) || "OAEPWITHSHA-256ANDMGF1PADDING".equalsIgnoreCase(string)) {
            extendedDigest = new SHA256Digest();
            asymmetricBlockCipher = new OAEPEncoding(rSAEngine, extendedDigest, null);
        } else if ("OAEPWITHSHA384ANDMGF1PADDING".equalsIgnoreCase(string) || "OAEPWITHSHA-384ANDMGF1PADDING".equalsIgnoreCase(string)) {
            extendedDigest = new SHA384Digest();
            asymmetricBlockCipher = new OAEPEncoding(rSAEngine, extendedDigest, null);
        } else if ("OAEPWITHSHA512ANDMGF1PADDING".equalsIgnoreCase(string) || "OAEPWITHSHA-512ANDMGF1PADDING".equalsIgnoreCase(string)) {
            extendedDigest = new SHA512Digest();
            asymmetricBlockCipher = new OAEPEncoding(new RSAEngine(), extendedDigest, null);
        } else if ("OAEPWITHSHA3-224ANDMGF1PADDING".equalsIgnoreCase(string)) {
            extendedDigest = new SHA3Digest(224);
            asymmetricBlockCipher = new OAEPEncoding(rSAEngine, extendedDigest, PSource.PSpecified.DEFAULT.getValue());
        } else if ("OAEPWITHSHA3-256ANDMGF1PADDING".equalsIgnoreCase(string)) {
            extendedDigest = new SHA3Digest(256);
            asymmetricBlockCipher = new OAEPEncoding(rSAEngine, extendedDigest, PSource.PSpecified.DEFAULT.getValue());
        } else if ("OAEPWITHSHA3-384ANDMGF1PADDING".equalsIgnoreCase(string)) {
            extendedDigest = new SHA3Digest(384);
            asymmetricBlockCipher = new OAEPEncoding(rSAEngine, extendedDigest, PSource.PSpecified.DEFAULT.getValue());
        } else if ("OAEPWITHSHA3-512ANDMGF1PADDING".equalsIgnoreCase(string)) {
            extendedDigest = new SHA3Digest(512);
            asymmetricBlockCipher = new OAEPEncoding(rSAEngine, extendedDigest, PSource.PSpecified.DEFAULT.getValue());
        }
        return asymmetricBlockCipher;
    }

    private static byte[] rsaProcess(AsymmetricBlockCipher asymmetricBlockCipher, boolean bl, CipherParameters cipherParameters, byte[] byArray) throws ParmErrorException, InvalidCipherTextException, Exception {
        asymmetricBlockCipher.init(bl, cipherParameters);
        if (bl && (asymmetricBlockCipher instanceof RSAEngine ? byArray.length > asymmetricBlockCipher.getInputBlockSize() + 1 : byArray.length > asymmetricBlockCipher.getInputBlockSize())) {
            throw new ParmErrorException("Cipher input exceed max length:" + asymmetricBlockCipher.getInputBlockSize());
        }
        byte[] byArray2 = asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        return byArray2;
    }

    private static byte[] sm2Encryption(CipherParameters cipherParameters, byte[] byArray) throws Exception {
        SM2Engine sM2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        ParametersWithRandom parametersWithRandom = new ParametersWithRandom(cipherParameters, new SecureRandom());
        byte[] byArray2 = null;
        int n = 0;
        while (n++ < 5 && byArray2 == null) {
            sM2Engine.init(true, parametersWithRandom);
            byte[] byArray3 = sM2Engine.processBlock(byArray, 0, byArray.length);
            byArray2 = AsymmetricCipher.encode(byArray3);
        }
        return byArray2;
    }

    private static byte[] sm2Decryption(CipherParameters cipherParameters, byte[] byArray) throws Exception {
        byte[] byArray2 = AsymmetricCipher.decode(byArray);
        SM2Engine sM2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        sM2Engine.init(false, cipherParameters);
        byte[] byArray3 = sM2Engine.processBlock(byArray2, 0, byArray2.length);
        return byArray3;
    }

    private static byte[] encode(byte[] byArray) throws Exception {
        byte[] byArray2 = Arrays.copyOfRange(byArray, 1, 33);
        byte[] byArray3 = Arrays.copyOfRange(byArray, 33, 65);
        byte[] byArray4 = Arrays.copyOfRange(byArray, 65, 97);
        byte[] byArray5 = Arrays.copyOfRange(byArray, 97, byArray.length);
        String string = Hex.toHexString(byArray2).substring(0, 3);
        String string2 = Hex.toHexString(byArray3).substring(0, 3);
        if (Integer.parseInt(string, 16) < 8 || Integer.parseInt(string2, 16) < 8) {
            return null;
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(new BigInteger(1, byArray2)));
        aSN1EncodableVector.add(new ASN1Integer(new BigInteger(1, byArray3)));
        aSN1EncodableVector.add(new DEROctetString(byArray4));
        aSN1EncodableVector.add(new DEROctetString(byArray5));
        byte[] byArray6 = new DERSequence(aSN1EncodableVector).getEncoded("DER");
        return byArray6;
    }

    public static byte[] decode(byte[] byArray) throws Exception {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        if (aSN1Sequence.size() == 4) {
            byte[] byArray2;
            byte[] byArray3;
            byte[] byArray4 = ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue().toByteArray();
            if (byArray4.length == 33) {
                byArray4 = Arrays.copyOfRange(byArray4, 1, byArray4.length);
            }
            if (byArray4.length == 31) {
                byArray3 = new byte[1 + byArray4.length];
                System.arraycopy(Hex.decode("00"), 0, byArray3, 0, 1);
                System.arraycopy(byArray4, 0, byArray3, 1, byArray4.length);
                byArray4 = byArray3;
            }
            if ((byArray3 = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue().toByteArray()).length == 33) {
                byArray3 = Arrays.copyOfRange(byArray3, 1, byArray3.length);
            }
            if (byArray3.length == 31) {
                byArray2 = new byte[1 + byArray3.length];
                System.arraycopy(Hex.decode("00"), 0, byArray2, 0, 1);
                System.arraycopy(byArray3, 0, byArray2, 1, byArray3.length);
                byArray3 = byArray2;
            }
            byArray2 = ((DEROctetString)aSN1Sequence.getObjectAt(2)).getOctets();
            byte[] byArray5 = ((DEROctetString)aSN1Sequence.getObjectAt(3)).getOctets();
            byte[] byArray6 = new byte[1 + byArray4.length + byArray3.length + byArray2.length + byArray5.length];
            System.arraycopy(Hex.decode("04"), 0, byArray6, 0, 1);
            System.arraycopy(byArray4, 0, byArray6, 1, byArray4.length);
            System.arraycopy(byArray3, 0, byArray6, 1 + byArray4.length, byArray3.length);
            System.arraycopy(byArray2, 0, byArray6, 1 + byArray4.length + byArray3.length, byArray2.length);
            System.arraycopy(byArray5, 0, byArray6, 1 + byArray4.length + byArray3.length + byArray2.length, byArray5.length);
            return byArray6;
        }
        throw new Exception("encrypted data error!");
    }

    public static byte[] reformatC1C2C3(byte[] byArray) throws Exception {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        if (aSN1Sequence.size() == 4) {
            byte[] byArray2;
            byte[] byArray3;
            byte[] byArray4 = ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue().toByteArray();
            if (byArray4.length == 33) {
                byArray4 = Arrays.copyOfRange(byArray4, 1, byArray4.length);
            } else if (byArray4.length == 31) {
                byArray3 = new byte[32];
                System.arraycopy(byArray4, 0, byArray3, 1, byArray4.length);
                byArray4 = Arrays.copyOfRange(byArray3, 0, byArray3.length);
            }
            byArray3 = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue().toByteArray();
            if (byArray3.length == 33) {
                byArray3 = Arrays.copyOfRange(byArray3, 1, byArray3.length);
            } else if (byArray3.length == 31) {
                byArray2 = new byte[32];
                System.arraycopy(byArray3, 0, byArray2, 1, byArray3.length);
                byArray3 = Arrays.copyOfRange(byArray2, 0, byArray2.length);
            }
            byArray2 = ((DEROctetString)aSN1Sequence.getObjectAt(2)).getOctets();
            byte[] byArray5 = ((DEROctetString)aSN1Sequence.getObjectAt(3)).getOctets();
            byte[] byArray6 = new byte[1 + byArray4.length + byArray3.length + byArray5.length + byArray2.length];
            System.arraycopy(Hex.decode("04"), 0, byArray6, 0, 1);
            System.arraycopy(byArray4, 0, byArray6, 1, byArray4.length);
            System.arraycopy(byArray3, 0, byArray6, 1 + byArray4.length, byArray3.length);
            System.arraycopy(byArray5, 0, byArray6, 1 + byArray4.length + byArray3.length, byArray5.length);
            System.arraycopy(byArray2, 0, byArray6, 1 + byArray4.length + byArray3.length + byArray5.length, byArray2.length);
            return byArray6;
        }
        throw new Exception("encrypted data error!");
    }
}

