/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.basic;

import com.icbc.bcprov.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECDomainParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECConstants;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECCurve;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECPoint;
import com.icbc.hsm.software.basic.PBEkeyGenerate;
import java.math.BigInteger;
import java.security.SecureRandom;

public class Generator {
    public static AsymmetricCipherKeyPair generateSM2KeyPair() throws Exception {
        BigInteger bigInteger = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
        BigInteger bigInteger2 = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
        BigInteger bigInteger3 = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
        BigInteger bigInteger4 = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
        BigInteger bigInteger5 = ECConstants.ONE;
        BigInteger bigInteger6 = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
        BigInteger bigInteger7 = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
        ECCurve.Fp fp = new ECCurve.Fp(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5);
        ECPoint eCPoint = fp.createPoint(bigInteger6, bigInteger7);
        ECDomainParameters eCDomainParameters = new ECDomainParameters(fp, eCPoint, bigInteger4);
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        ECKeyGenerationParameters eCKeyGenerationParameters = new ECKeyGenerationParameters(eCDomainParameters, new SecureRandom());
        eCKeyPairGenerator.init(eCKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
        return asymmetricCipherKeyPair;
    }

    public static AsymmetricCipherKeyPair generateRSAKeyPair(int n) throws Exception {
        RSAKeyPairGenerator rSAKeyPairGenerator = new RSAKeyPairGenerator();
        RSAKeyGenerationParameters rSAKeyGenerationParameters = new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), new SecureRandom(), n, 50);
        rSAKeyPairGenerator.init(rSAKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = rSAKeyPairGenerator.generateKeyPair();
        return asymmetricCipherKeyPair;
    }

    public static byte[] generateRandom(int n) throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[20];
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = new byte[32];
        secureRandom.nextBytes(byArray2);
        byte[] byArray3 = PBEkeyGenerate.generatePBEKey("PBKDF2", "SM3", null, n, byArray, byArray2, 16);
        return byArray3;
    }
}

