/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.software.cert;

import com.icbc.bcpkix.org.bouncycastle.cert.CertException;
import com.icbc.bcpkix.org.bouncycastle.cert.X509CRLHolder;
import com.icbc.bcpkix.org.bouncycastle.cert.X509CertificateHolder;
import com.icbc.bcpkix.org.bouncycastle.cert.jcajce.JcaCRLStore;
import com.icbc.bcpkix.org.bouncycastle.cert.jcajce.JcaCertStore;
import com.icbc.bcpkix.org.bouncycastle.cert.path.CertPathValidationException;
import com.icbc.bcpkix.org.bouncycastle.cert.path.validations.CRLValidation;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSException;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSProcessable;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSProcessableByteArray;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSSignedData;
import com.icbc.bcpkix.org.bouncycastle.cms.CMSSignedDataGenerator;
import com.icbc.bcpkix.org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import com.icbc.bcpkix.org.bouncycastle.cms.SignerId;
import com.icbc.bcpkix.org.bouncycastle.cms.SignerInfoGenerator;
import com.icbc.bcpkix.org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import com.icbc.bcpkix.org.bouncycastle.cms.SignerInformationVerifier;
import com.icbc.bcpkix.org.bouncycastle.cms.SignerInformationVerifierProvider;
import com.icbc.bcpkix.org.bouncycastle.operator.ContentSigner;
import com.icbc.bcpkix.org.bouncycastle.operator.ContentVerifierProvider;
import com.icbc.bcpkix.org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import com.icbc.bcpkix.org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import com.icbc.bcpkix.org.bouncycastle.operator.OperatorCreationException;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import com.icbc.bcpkix.org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import com.icbc.bcprov.org.bouncycastle.asn1.gm.GMNamedCurves;
import com.icbc.bcprov.org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.asn1.x500.X500Name;
import com.icbc.bcprov.org.bouncycastle.asn1.x500.X500NameBuilder;
import com.icbc.bcprov.org.bouncycastle.asn1.x500.style.RFC4519Style;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.icbc.bcprov.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.icbc.bcprov.org.bouncycastle.asn1.x9.X9ECParameters;
import com.icbc.bcprov.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECDomainParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.jce.provider.BouncyCastleProvider;
import com.icbc.bcprov.org.bouncycastle.util.Store;
import com.icbc.hsm.software.cert.GmContentVerifierProviderBuilder;
import com.icbc.hsm.software.cert.GmDigestCalculatorProvider;
import com.icbc.hsm.software.cert.IcbcContentSignerBuilder;
import com.icbc.hsm.utils.encoders.Base64;
import com.icbc.hsm.utils.encoders.GF;
import com.icbc.hsm.utils.encoders.Hex;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

public class CertHelper {
    private static final X9ECParameters x9 = GMNamedCurves.getByOID(GMObjectIdentifiers.sm2p256v1);
    private static final ECDomainParameters dp = new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN());

    public static String generateP10Sm2(String string, String string2, String string3) throws OperatorCreationException, IOException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, GMObjectIdentifiers.sm2p256v1);
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, Hex.decode(string2));
        X500Name x500Name = CertHelper.parseSubject(string3);
        PKCS10CertificationRequestBuilder pKCS10CertificationRequestBuilder = new PKCS10CertificationRequestBuilder(x500Name, subjectPublicKeyInfo);
        ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(new BigInteger(string, 16), dp);
        AlgorithmIdentifier algorithmIdentifier2 = new DefaultSignatureAlgorithmIdentifierFinder().find("SM3WITHSM2");
        AlgorithmIdentifier algorithmIdentifier3 = new DefaultDigestAlgorithmIdentifierFinder().find("SM3");
        ContentSigner contentSigner = new IcbcContentSignerBuilder(algorithmIdentifier2, algorithmIdentifier3).build(eCPrivateKeyParameters);
        PKCS10CertificationRequest pKCS10CertificationRequest = pKCS10CertificationRequestBuilder.build(contentSigner);
        return Base64.toBase64String(pKCS10CertificationRequest.getEncoded());
    }

    public static String pkcs7Sign(String string, byte[] byArray, byte[] byArray2) throws CMSException, IOException, CertificateEncodingException, OperatorCreationException {
        CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(byArray2);
        X509CertificateHolder x509CertificateHolder = new X509CertificateHolder(byArray);
        JcaCertStore jcaCertStore = new JcaCertStore(Collections.singletonList(x509CertificateHolder));
        CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
        ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(new BigInteger(string, 16), dp);
        AlgorithmIdentifier algorithmIdentifier = x509CertificateHolder.getSignatureAlgorithm();
        AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(GMObjectIdentifiers.sm3);
        ContentSigner contentSigner = new IcbcContentSignerBuilder(algorithmIdentifier, algorithmIdentifier2).build(eCPrivateKeyParameters);
        GmDigestCalculatorProvider gmDigestCalculatorProvider = new GmDigestCalculatorProvider();
        SignerInfoGenerator signerInfoGenerator = new SignerInfoGeneratorBuilder(gmDigestCalculatorProvider).build(contentSigner, x509CertificateHolder);
        cMSSignedDataGenerator.addSignerInfoGenerator(signerInfoGenerator);
        cMSSignedDataGenerator.addCertificates(jcaCertStore);
        CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, false);
        return Base64.toBase64String(cMSSignedData.getEncoded());
    }

    public static boolean pkcs7Verify(byte[] byArray, byte[] byArray2) {
        try {
            final CMSSignedData cMSSignedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(byArray2), byArray);
            return cMSSignedData.verifySignatures(new SignerInformationVerifierProvider(){

                @Override
                public SignerInformationVerifier get(SignerId signerId) throws OperatorCreationException {
                    Store<X509CertificateHolder> store = cMSSignedData.getCertificates();
                    Collection<X509CertificateHolder> collection = store.getMatches(signerId);
                    X509CertificateHolder x509CertificateHolder = collection.iterator().next();
                    return new SignerInformationVerifier(new DefaultCMSSignatureAlgorithmNameGenerator(), new DefaultSignatureAlgorithmIdentifierFinder(), new GmContentVerifierProviderBuilder().build(x509CertificateHolder), new GmDigestCalculatorProvider());
                }
            });
        }
        catch (CMSException cMSException) {
            cMSException.printStackTrace();
            return false;
        }
    }

    private static X500Name parseSubject(String string) {
        String[] stringArray;
        X500Name x500Name = null;
        X500NameBuilder x500NameBuilder = new X500NameBuilder(RFC4519Style.INSTANCE);
        for (String string2 : stringArray = string.split(",")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2[0].trim().equalsIgnoreCase("cn")) {
                x500NameBuilder.addRDN(RFC4519Style.cn, stringArray2[1]);
                continue;
            }
            if (stringArray2[0].trim().equalsIgnoreCase("ou")) {
                x500NameBuilder.addRDN(RFC4519Style.ou, stringArray2[1]);
                continue;
            }
            if (stringArray2[0].trim().equalsIgnoreCase("o")) {
                x500NameBuilder.addRDN(RFC4519Style.o, stringArray2[1]);
                continue;
            }
            if (!stringArray2[0].trim().equalsIgnoreCase("c")) continue;
            x500NameBuilder.addRDN(RFC4519Style.c, stringArray2[1]);
        }
        x500Name = x500NameBuilder.build();
        return x500Name;
    }

    public static ECPublicKeyParameters parsePublicSm2(String string) {
        String string2;
        if (!GF.verifyHex(string)) {
            throw new RuntimeException("SM2 public key format error.");
        }
        if (string.length() == 130 && string.startsWith("04")) {
            string2 = string.substring(2, 130);
        } else if (string.length() == 128) {
            string2 = string;
        } else {
            throw new RuntimeException("SM2 public key format error.");
        }
        return new ECPublicKeyParameters(x9.getCurve().createPoint(new BigInteger(string2.substring(0, 64), 16), new BigInteger(string2.substring(64, 128), 16)), dp);
    }

    public static ECPrivateKeyParameters parsePrivateSm2(String string) {
        if (!GF.verifyHex(string)) {
            throw new RuntimeException("SM2 private key error.");
        }
        return new ECPrivateKeyParameters(new BigInteger(string, 16), dp);
    }

    public static boolean certDateValidate(byte[] byArray, Date date) throws IOException {
        X509CertificateHolder x509CertificateHolder = new X509CertificateHolder(byArray);
        return x509CertificateHolder.isValidOn(date);
    }

    public static boolean certSignatureValidate(byte[] byArray, byte[] byArray2) throws IOException, CertException, OperatorCreationException {
        X509CertificateHolder x509CertificateHolder = new X509CertificateHolder(byArray);
        ContentVerifierProvider contentVerifierProvider = new GmContentVerifierProviderBuilder().build(new X509CertificateHolder(byArray2));
        return x509CertificateHolder.isSignatureValid(contentVerifierProvider);
    }

    public static boolean verifyCRL(byte[] byArray, byte[] byArray2) throws IOException, CRLException {
        X509CRLHolder x509CRLHolder = new X509CRLHolder(byArray);
        X509CertificateHolder x509CertificateHolder = new X509CertificateHolder(byArray2);
        JcaCRLStore jcaCRLStore = new JcaCRLStore(Collections.singletonList(x509CRLHolder));
        CRLValidation cRLValidation = new CRLValidation(x509CRLHolder.getIssuer(), jcaCRLStore);
        try {
            cRLValidation.validate(null, x509CertificateHolder);
        }
        catch (CertPathValidationException certPathValidationException) {
            return false;
        }
        return true;
    }

    public static String parseSM2PublicKeyFromX509Cert(byte[] byArray) throws IOException {
        X509CertificateHolder x509CertificateHolder = new X509CertificateHolder(byArray);
        byte[] byArray2 = x509CertificateHolder.getSubjectPublicKeyInfo().getPublicKeyData().getOctets();
        return Hex.toHexString(byArray2);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

