/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.hsm.utils;

import com.icbc.bcprov.org.bouncycastle.asn1.ASN1Object;
import com.icbc.bcprov.org.bouncycastle.asn1.gm.GMNamedCurves;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.icbc.bcprov.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.icbc.bcprov.org.bouncycastle.asn1.x9.X9ECParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.CipherParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECDomainParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.icbc.bcprov.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import com.icbc.bcprov.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import com.icbc.bcprov.org.bouncycastle.jce.provider.BouncyCastleProvider;
import com.icbc.bcprov.org.bouncycastle.jce.spec.ECParameterSpec;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECCurve;
import com.icbc.bcprov.org.bouncycastle.math.ec.ECPoint;
import com.icbc.bcprov.org.bouncycastle.util.encoders.Hex;
import com.icbc.bcprov.org.bouncycastle.util.io.pem.PemObject;
import com.icbc.bcprov.org.bouncycastle.util.io.pem.PemReader;
import com.icbc.bcprov.org.bouncycastle.util.io.pem.PemWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.EncodedKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KeyTranslator {
    private KeyTranslator() {
    }

    public static AsymmetricKeyParameter toAsymmetricKey(byte[] byArray, String string) throws Exception {
        if ("SM2private".equalsIgnoreCase(string)) {
            X9ECParameters x9ECParameters = GMNamedCurves.getByName("sm2p256v1");
            ECCurve eCCurve = x9ECParameters.getCurve();
            ECPoint eCPoint = x9ECParameters.getG();
            ECDomainParameters eCDomainParameters = new ECDomainParameters(eCCurve, eCPoint, eCCurve.getOrder());
            BigInteger bigInteger = new BigInteger(1, byArray);
            ECPrivateKeyParameters eCPrivateKeyParameters = new ECPrivateKeyParameters(bigInteger, eCDomainParameters);
            return eCPrivateKeyParameters;
        }
        if ("SM2public".equalsIgnoreCase(string)) {
            X9ECParameters x9ECParameters = GMNamedCurves.getByName("sm2p256v1");
            ECCurve eCCurve = x9ECParameters.getCurve();
            ECPoint eCPoint = x9ECParameters.getG();
            ECDomainParameters eCDomainParameters = new ECDomainParameters(eCCurve, eCPoint, eCCurve.getOrder());
            String string2 = Hex.toHexString(byArray);
            if (!string2.startsWith("04")) {
                throw new Exception("key data error!");
            }
            String string3 = string2.substring(2, 66);
            String string4 = string2.substring(66);
            ECPoint eCPoint2 = eCCurve.createPoint(new BigInteger(string3, 16), new BigInteger(string4, 16));
            ECPublicKeyParameters eCPublicKeyParameters = new ECPublicKeyParameters(eCPoint2, eCDomainParameters);
            return eCPublicKeyParameters;
        }
        if ("RSAprivate".equalsIgnoreCase(string)) {
            RSAPrivateKey rSAPrivateKey = RSAPrivateKey.getInstance(byArray);
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = new RSAPrivateCrtKeyParameters(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getPrime1(), rSAPrivateKey.getPrime2(), rSAPrivateKey.getExponent1(), rSAPrivateKey.getExponent2(), rSAPrivateKey.getCoefficient());
            return rSAPrivateCrtKeyParameters;
        }
        if ("RSApublic".equalsIgnoreCase(string)) {
            RSAPublicKey rSAPublicKey = RSAPublicKey.getInstance(byArray);
            RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            return rSAKeyParameters;
        }
        throw new Exception("key type not support! " + string);
    }

    public static CipherParameters toClearRsaKey(byte[] byArray) {
        Key key;
        EncodedKeySpec encodedKeySpec;
        KeyFactory keyFactory;
        RSAKeyParameters rSAKeyParameters = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            encodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            key = (java.security.interfaces.RSAPrivateKey)keyFactory.generatePrivate(encodedKeySpec);
            if (key instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
                rSAKeyParameters = new RSAPrivateCrtKeyParameters(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
            } else if (key instanceof java.security.interfaces.RSAPrivateKey) {
                rSAKeyParameters = new RSAKeyParameters(true, key.getModulus(), key.getPrivateExponent());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rSAKeyParameters == null) {
            try {
                keyFactory = KeyFactory.getInstance("RSA");
                encodedKeySpec = new X509EncodedKeySpec(byArray);
                key = (java.security.interfaces.RSAPublicKey)keyFactory.generatePublic(encodedKeySpec);
                rSAKeyParameters = new RSAKeyParameters(true, key.getModulus(), key.getPublicExponent());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rSAKeyParameters;
    }

    public static byte[] toPKCS1(byte[] byArray) {
        Object object;
        Key key;
        EncodedKeySpec encodedKeySpec;
        KeyFactory keyFactory;
        byte[] byArray2 = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            encodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            key = (java.security.interfaces.RSAPrivateKey)keyFactory.generatePrivate(encodedKeySpec);
            if (key instanceof RSAPrivateCrtKey) {
                object = (RSAPrivateCrtKey)key;
                RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(object.getModulus(), object.getPublicExponent(), object.getPrivateExponent(), object.getPrimeP(), object.getPrimeQ(), object.getPrimeExponentP(), object.getPrimeExponentQ(), object.getCrtCoefficient());
                byArray2 = rSAPrivateKey.getEncoded();
            } else if (key instanceof java.security.interfaces.RSAPrivateKey) {
                object = new RSAPrivateKey(key.getModulus(), new BigInteger("0"), key.getPrivateExponent(), new BigInteger("0"), new BigInteger("0"), new BigInteger("0"), new BigInteger("0"), new BigInteger("0"));
                byArray2 = ((ASN1Object)object).getEncoded();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byArray2 == null) {
            try {
                keyFactory = KeyFactory.getInstance("RSA");
                encodedKeySpec = new X509EncodedKeySpec(byArray);
                key = (java.security.interfaces.RSAPublicKey)keyFactory.generatePublic(encodedKeySpec);
                object = new RSAPublicKey(key.getModulus(), key.getPublicExponent());
                byArray2 = ((ASN1Object)object).getEncoded();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return byArray2;
    }

    public static String toPem(byte[] byArray, String string, byte[] byArray2) throws Exception {
        if ("SM2private".equalsIgnoreCase(string)) {
            AsymmetricKeyParameter asymmetricKeyParameter = KeyTranslator.toAsymmetricKey(byArray, "SM2public");
            AsymmetricKeyParameter asymmetricKeyParameter2 = KeyTranslator.toAsymmetricKey(byArray2, string);
            ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricKeyParameter;
            ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricKeyParameter2;
            byte[] byArray3 = KeyTranslator.convertECPrivateKeyToPKCS8(eCPrivateKeyParameters, eCPublicKeyParameters);
            String string2 = KeyTranslator.convertEncodedDataToPEM("EC PRIVATE KEY", byArray3);
            return string2;
        }
        if ("SM2public".equalsIgnoreCase(string)) {
            AsymmetricKeyParameter asymmetricKeyParameter = KeyTranslator.toAsymmetricKey(byArray, string);
            ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricKeyParameter;
            byte[] byArray4 = KeyTranslator.convertECPublicKeyToX509(eCPublicKeyParameters);
            String string3 = KeyTranslator.convertEncodedDataToPEM("PUBLIC KEY", byArray4);
            return string3;
        }
        if ("RSAprivate".equalsIgnoreCase(string)) {
            AsymmetricKeyParameter asymmetricKeyParameter = KeyTranslator.toAsymmetricKey(byArray, string);
            RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricKeyParameter;
            RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(rSAPrivateCrtKeyParameters.getModulus(), rSAPrivateCrtKeyParameters.getExponent());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)((Object)keyFactory.generatePrivate(rSAPrivateKeySpec));
            byte[] byArray5 = rSAPrivateKey.getEncoded();
            String string4 = KeyTranslator.convertEncodedDataToPEM("RSA PRIVATE KEY", byArray5);
            return string4;
        }
        if ("RSApublic".equalsIgnoreCase(string)) {
            AsymmetricKeyParameter asymmetricKeyParameter = KeyTranslator.toAsymmetricKey(byArray, string);
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricKeyParameter;
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAKeyParameters.getModulus(), rSAKeyParameters.getExponent());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
            byte[] byArray6 = rSAPublicKey.getEncoded();
            String string5 = KeyTranslator.convertEncodedDataToPEM("PUBLIC KEY", byArray6);
            return string5;
        }
        throw new Exception("key type not support! " + string);
    }

    public static byte[] convertECPublicKeyToX509(ECPublicKeyParameters eCPublicKeyParameters) {
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        ECParameterSpec eCParameterSpec = new ECParameterSpec(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH());
        BCECPublicKey bCECPublicKey = new BCECPublicKey("EC", eCPublicKeyParameters, eCParameterSpec, BouncyCastleProvider.CONFIGURATION);
        return bCECPublicKey.getEncoded();
    }

    public static byte[] convertECPrivateKeyToPKCS8(ECPrivateKeyParameters eCPrivateKeyParameters, ECPublicKeyParameters eCPublicKeyParameters) {
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        ECParameterSpec eCParameterSpec = new ECParameterSpec(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH());
        BCECPublicKey bCECPublicKey = null;
        if (eCPublicKeyParameters != null) {
            bCECPublicKey = new BCECPublicKey("EC", eCPublicKeyParameters, eCParameterSpec, BouncyCastleProvider.CONFIGURATION);
        }
        BCECPrivateKey bCECPrivateKey = new BCECPrivateKey("EC", eCPrivateKeyParameters, bCECPublicKey, eCParameterSpec, BouncyCastleProvider.CONFIGURATION);
        return bCECPrivateKey.getEncoded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertEncodedDataToPEM(String string, byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PemWriter pemWriter = new PemWriter(new OutputStreamWriter(byteArrayOutputStream));
        try {
            PemObject pemObject = new PemObject(string, byArray);
            pemWriter.writeObject(pemObject);
        }
        finally {
            pemWriter.close();
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] convertPEMToEncodedData(String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        PemReader pemReader = new PemReader(new InputStreamReader(byteArrayInputStream));
        try {
            PemObject pemObject = pemReader.readPemObject();
            byte[] byArray = pemObject.getContent();
            return byArray;
        }
        finally {
            pemReader.close();
        }
    }
}

