/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.x509;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1TaggedObject;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.x509.PolicyInformation;
import java.util.Enumeration;
import java.util.Vector;

public class CertificatePolicies
implements DEREncodable {
    static final DERObjectIdentifier anyPolicy = new DERObjectIdentifier("2.5.29.32.0");
    Vector policies = new Vector();

    public static CertificatePolicies getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertificatePolicies.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static CertificatePolicies getInstance(Object obj) {
        if (obj instanceof CertificatePolicies) {
            return (CertificatePolicies)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CertificatePolicies((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CertificatePolicies(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1Sequence s = (ASN1Sequence)e.nextElement();
            this.policies.addElement(s);
        }
    }

    public CertificatePolicies(DERObjectIdentifier p) {
        this.policies.addElement(p);
    }

    public CertificatePolicies(String p) {
        this(new DERObjectIdentifier(p));
    }

    public void addPolicy(String p) {
        this.policies.addElement(new DERObjectIdentifier(p));
    }

    public String getPolicy(int nr) {
        if (this.policies.size() > nr) {
            return ((DERObjectIdentifier)this.policies.elementAt(nr)).getId();
        }
        return null;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < this.policies.size()) {
            PolicyInformation pi = new PolicyInformation((ASN1Sequence)this.policies.get(i));
            v.add(pi.toASN1Object());
            ++i;
        }
        return new DERSequence(v);
    }

    public String toString() {
        String p = null;
        int i = 0;
        while (i < this.policies.size()) {
            if (p != null) {
                p = String.valueOf(p) + ", ";
            }
            p = String.valueOf(p) + ((DERObjectIdentifier)this.policies.elementAt(i)).getId();
            ++i;
        }
        return "CertificatePolicies: " + p;
    }
}

