/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.x509;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1TaggedObject;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.DERTaggedObject;

public class PolicyConstraints
implements DEREncodable {
    private ASN1Sequence seq;
    private DERInteger requireExplicitPolicy;
    private DERInteger inhibitPolicyMapping;

    public PolicyConstraints(DERInteger requireExplicitPolicy, DERInteger inhibitPolicyMapping) {
        this.requireExplicitPolicy = requireExplicitPolicy;
        this.inhibitPolicyMapping = inhibitPolicyMapping;
    }

    public PolicyConstraints(ASN1Sequence seq) {
        this.seq = seq;
        int i = 0;
        while (i < seq.size()) {
            ASN1TaggedObject obj = (ASN1TaggedObject)seq.getObjectAt(i);
            switch (obj.getTagNo()) {
                case 0: {
                    this.requireExplicitPolicy = DERInteger.getInstance(obj, false);
                    break;
                }
                case 1: {
                    this.inhibitPolicyMapping = DERInteger.getInstance(obj, false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal tag");
                }
            }
            ++i;
        }
    }

    public static PolicyConstraints getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PolicyConstraints.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static PolicyConstraints getInstance(Object obj) {
        if (obj instanceof PolicyConstraints) {
            return (PolicyConstraints)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PolicyConstraints((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public DERInteger getRequireExplicitPolicy() {
        return this.requireExplicitPolicy;
    }

    public DERInteger getInhibitPolicyMapping() {
        return this.inhibitPolicyMapping;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.requireExplicitPolicy != null) {
            v.add(new DERTaggedObject(false, 0, this.requireExplicitPolicy));
        }
        if (this.inhibitPolicyMapping != null) {
            v.add(new DERTaggedObject(false, 1, this.inhibitPolicyMapping));
        }
        return new DERSequence(v);
    }
}

