/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cms;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.ASN1OctetString;
import com.cfca.util.pki.asn1.ASN1OutputStream;
import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.BERConstructedOctetString;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DEROutputStream;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.DERUTCTime;
import com.cfca.util.pki.asn1.cms.Attribute;
import com.cfca.util.pki.asn1.cms.AttributeTable;
import com.cfca.util.pki.asn1.cms.CMSAttributes;
import com.cfca.util.pki.asn1.cms.ContentInfo;
import com.cfca.util.pki.asn1.cms.IssuerAndSerialNumber;
import com.cfca.util.pki.asn1.cms.SignedData;
import com.cfca.util.pki.asn1.cms.SignerIdentifier;
import com.cfca.util.pki.asn1.cms.SignerInfo;
import com.cfca.util.pki.asn1.cms.Time;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.DigestInfo;
import com.cfca.util.pki.asn1.x509.SubjectKeyIdentifier;
import com.cfca.util.pki.asn1.x509.SubjectPublicKeyInfo;
import com.cfca.util.pki.asn1.x509.TBSCertificateStructure;
import com.cfca.util.pki.asn1.x509.X509CertificateStructure;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.crl.X509CRL;
import com.cfca.util.pki.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class CMSSignedDataCFCA {
    private ASN1EncodableVector certs = new ASN1EncodableVector();
    private ASN1EncodableVector clss = new ASN1EncodableVector();
    private ArrayList signers = new ArrayList();
    private Session session = null;
    private SignedData signedData = null;
    private byte[] msg = null;

    public CMSSignedDataCFCA(Session value) {
        this.session = value;
    }

    public void AddCert(X509Cert value) throws PKIException {
        this.certs.add(Parser.convertCFCACertStruct2BCCertStruct(value.getCertStructure()));
    }

    public void AddCRL(X509CRL value) throws PKIException {
        this.clss.add(Parser.convertCFCACertList2BCCertList(value.getCertificateList()));
    }

    public void AddSigner(JKey privatekey, X509Cert cert, Mechanism sign_Mechanism) {
        this.signers.add(new Signer(this.session, privatekey, cert, sign_Mechanism));
    }

    public void AddSigner(JKey privatekey, X509Cert cert, Mechanism sign_Mechanism, AttributeTable sAttr, AttributeTable unsAttr) {
        this.signers.add(new Signer(this.session, privatekey, cert, sign_Mechanism, sAttr, unsAttr));
    }

    public byte[] GetSignedDataForByte() throws PKIException, IOException {
        if (this.signedData == null) {
            return null;
        }
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, this.signedData);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(contentInfo);
        byte[] ret_byte = bOut.toByteArray();
        aOut.flush();
        aOut.close();
        bOut.flush();
        bOut.close();
        return ret_byte;
    }

    public InputStream GetSignedDataForInputStream() throws PKIException, IOException {
        return new ByteArrayInputStream(this.GetSignedDataForByte());
    }

    public SignedData GetSignedData() throws PKIException {
        return this.signedData;
    }

    public void GetSignedDataForFile(String FileName) throws PKIException, IOException {
        FileOutputStream fos = new FileOutputStream(FileName);
        ((OutputStream)fos).write(this.GetSignedDataForByte());
        fos.flush();
        ((OutputStream)fos).close();
    }

    public void Generate(byte[] content, boolean encapsulate, boolean setIssuerAndSN) throws PKIException, IOException {
        this.Generate(PKCSObjectIdentifiers.data.getId(), content, encapsulate, setIssuerAndSN);
    }

    public void Generate(byte[] content, boolean encapsulate, boolean addDefaultAttributes, boolean setIssuerAndSN) throws PKIException, IOException {
        this.Generate(PKCSObjectIdentifiers.data.getId(), content, encapsulate, addDefaultAttributes, setIssuerAndSN);
    }

    public void Generate(String signedContentType, byte[] content, boolean encapsulate, boolean setIssuerAndSN) throws PKIException, IOException {
        this.Generate(signedContentType, content, encapsulate, true, setIssuerAndSN);
    }

    public void Generate(String signedContentType, byte[] content, boolean encapsulate, boolean addDefaultAttributes, boolean setIssuerAndSN) throws PKIException, IOException {
        ContentInfo encInfo;
        if (this.msg != null && this.signedData != null) {
            return;
        }
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        DERObjectIdentifier contentTypeOID = new DERObjectIdentifier(signedContentType);
        Iterator it = this.signers.iterator();
        Signer signer = null;
        while (it.hasNext()) {
            signer = (Signer)it.next();
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(signer.GetDigestTypeOID()), new DERNull());
            digestAlgs.add(digAlgId);
            signerInfos.add(signer.toSignerInfo(contentTypeOID, content, addDefaultAttributes, setIssuerAndSN));
        }
        DERSet certificates = new DERSet(this.certs);
        DERSet certrevlist = new DERSet(this.clss);
        if (encapsulate) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            bOut.write(content);
            BERConstructedOctetString octs = new BERConstructedOctetString(bOut.toByteArray());
            encInfo = new ContentInfo(contentTypeOID, octs);
            bOut.flush();
            bOut.close();
        } else {
            encInfo = new ContentInfo(contentTypeOID, null);
        }
        this.signedData = new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos));
        this.msg = content;
    }

    public void load(byte[] data) throws PKIException {
        boolean isB64 = Parser.isBase64Encode(data);
        if (isB64) {
            data = Parser.convertBase64(data);
            data = Base64.decode(data);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        this.load(bis);
    }

    public void load(InputStream ins) throws PKIException {
        ASN1InputStream ais = new ASN1InputStream(ins);
        try {
            ContentInfo contentInfo = ContentInfo.getInstance(ais.readObject());
            this.signedData = SignedData.getInstance(contentInfo.getContent());
            ins.close();
            ais.close();
            this.msg = null;
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
    }

    public void load(SignedData signedData) throws PKIException {
        this.signedData = signedData;
        this.msg = null;
    }

    public void load(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
        this.load(data);
    }

    public byte[] getContent() throws PKIException {
        if (this.msg == null && this.signedData == null) {
            return null;
        }
        if (this.msg == null && this.signedData != null) {
            ContentInfo contentInfo = this.signedData.getEncapContentInfo();
            if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo)) {
                if (contentInfo.getContent() == null) {
                    throw new PKIException("850604", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25 \u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", new Exception("no sourceData to be verify."));
                }
                this.msg = ((ASN1OctetString)contentInfo.getContent()).getOctets();
            } else {
                this.msg = CMSSignedDataCFCA.writeDERObj2Bytes(contentInfo.getContent());
            }
            return this.msg;
        }
        if (this.msg != null) {
            return this.msg;
        }
        return this.msg;
    }

    public boolean verify(byte[] sourcedata, X509Cert cert, SignerInfo signerInfo) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return this.verifySignerInfo(sourcedata, (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded())), signerInfo, true);
        }
        catch (CertificateException ex) {
            return false;
        }
        catch (PKIException ex1) {
            return false;
        }
    }

    public boolean verify(X509Cert[] certs) {
        return this.verify(null, certs);
    }

    public boolean verify(byte[] sourcedata, X509Cert[] certs) {
        ArrayList<Certificate> CertList = new ArrayList<Certificate>();
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            int i = 0;
            while (i < certs.length) {
                if (certs[i] != null) {
                    CertList.add(cf.generateCertificate(new ByteArrayInputStream(certs[i].getEncoded())));
                }
                ++i;
            }
        }
        catch (PKIException ex) {
            return false;
        }
        catch (CertificateException ex2) {
            return false;
        }
        return this.verifySignerInfo(sourcedata, CertList);
    }

    public boolean verify(byte[] sourcedata) {
        ArrayList<Certificate> CertList = new ArrayList<Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        CertificateFactory cf = null;
        ASN1Set setCerts = this.signedData.getCertificates();
        try {
            cf = CertificateFactory.getInstance("X.509");
            if (setCerts != null) {
                Enumeration e = setCerts.getObjects();
                while (e.hasMoreElements()) {
                    aOut.writeObject(e.nextElement());
                    CertList.add(cf.generateCertificate(new ByteArrayInputStream(bOut.toByteArray())));
                    bOut.reset();
                }
            }
            aOut.flush();
            aOut.close();
            bOut.flush();
            bOut.close();
        }
        catch (IOException ex4) {
            return false;
        }
        catch (CertificateException ex2) {
            return false;
        }
        return this.verifySignerInfo(sourcedata, CertList);
    }

    public boolean verify() {
        return this.verify((byte[])null);
    }

    public X509Cert verify(InputStream ins) throws PKIException {
        ArrayList<Certificate> CertList = new ArrayList<Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        CertificateFactory cf = null;
        ASN1Set setCerts = this.signedData.getCertificates();
        try {
            cf = CertificateFactory.getInstance("X.509");
            if (setCerts != null) {
                Enumeration e = setCerts.getObjects();
                while (e.hasMoreElements()) {
                    aOut.writeObject(e.nextElement());
                    CertList.add(cf.generateCertificate(new ByteArrayInputStream(bOut.toByteArray())));
                    bOut.reset();
                }
            }
            aOut.flush();
            aOut.close();
            bOut.flush();
            bOut.close();
        }
        catch (IOException ex4) {
            throw new PKIException("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u5931\u8d25\uff0c\u53d6\u7b7e\u540d\u8005\u8bc1\u4e66\u9519\u8bef\uff1a" + ex4.getMessage());
        }
        catch (CertificateException ex2) {
            throw new PKIException("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u5931\u8d25\uff0c\u53d6\u7b7e\u540d\u8005\u8bc1\u4e66\u9519\u8bef\uff1a" + ex2.getMessage());
        }
        return this.verifySignerInfo(ins, CertList);
    }

    public boolean verify(byte[] sourceData, Map subjectKeyMap, Map issuerAndSNMap, boolean isCheckTime) {
        ASN1Set SignerInfoset = this.signedData.getSignerInfos();
        boolean TF = true;
        int i = 0;
        while (i < SignerInfoset.size()) {
            block8: {
                X509Cert cert = null;
                SignerInfo signerInfo = SignerInfo.getInstance(SignerInfoset.getObjectAt(i));
                SignerIdentifier signerid = signerInfo.getSID();
                if (signerid.isTagged()) {
                    SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.getInstance(signerid.getId());
                    byte[] temp = subjectKeyIdentifier.getKeyIdentifier();
                    byte[] tempBase64 = Base64.encode(temp);
                    String tmepSubjectKey = new String(tempBase64);
                    cert = (X509Cert)issuerAndSNMap.get((String)subjectKeyMap.get(tmepSubjectKey));
                } else {
                    IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(signerid.getId());
                    String tmepIssuerAndSN = String.valueOf(iAnds.getName().toString()) + iAnds.getSerialNumber().getValue().toString();
                    cert = (X509Cert)issuerAndSNMap.get(tmepIssuerAndSN);
                }
                X509Certificate certificate = null;
                if (cert == null) {
                    TF = false;
                    break;
                }
                try {
                    CertificateFactory certfactory = CertificateFactory.getInstance("X.509");
                    certificate = (X509Certificate)certfactory.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
                    if (!this.verifySignerInfo(sourceData, certificate, signerInfo, isCheckTime)) {
                        TF = false;
                    }
                    break block8;
                }
                catch (CertificateException e) {
                    TF = false;
                }
                catch (PKIException e) {
                    TF = false;
                }
                break;
            }
            ++i;
        }
        return TF;
    }

    private boolean verifySignerInfo(byte[] sourceData, ArrayList CertList) {
        CertStore certStore = null;
        try {
            certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(CertList));
        }
        catch (Exception e) {
            return false;
        }
        ASN1Set SignerInfoset = this.signedData.getSignerInfos();
        Collection<? extends Certificate> certCollection = null;
        boolean TF = true;
        int i = 0;
        while (i < SignerInfoset.size()) {
            SignerInfo signerInfo = SignerInfo.getInstance(SignerInfoset.getObjectAt(i));
            SignerId sid = new SignerId();
            SignerIdentifier signerid = signerInfo.getSID();
            if (signerid.isTagged()) {
                ASN1OctetString octs = ASN1OctetString.getInstance(signerid.getId());
                sid.setSubjectKeyIdentifier(octs.getOctets());
            } else {
                IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(signerid.getId());
                ByteArrayOutputStream sidbOut = new ByteArrayOutputStream();
                ASN1OutputStream sidaOut = new ASN1OutputStream(sidbOut);
                try {
                    sidaOut.writeObject(iAnds.getName());
                    sid.setIssuer(sidbOut.toByteArray());
                    sidaOut.flush();
                    sidaOut.close();
                    sidbOut.flush();
                    sidbOut.close();
                }
                catch (IOException ex3) {
                    TF = false;
                    break;
                }
                sid.setSerialNumber(iAnds.getSerialNumber().getValue());
            }
            try {
                certCollection = certStore.getCertificates(sid);
            }
            catch (Exception e) {
                TF = false;
                break;
            }
            Iterator<? extends Certificate> certIt = certCollection.iterator();
            X509Certificate cert = (X509Certificate)certIt.next();
            if (!this.verifySignerInfo(sourceData, cert, signerInfo, true)) {
                TF = false;
                break;
            }
            ++i;
        }
        return TF;
    }

    private X509Cert verifySignerInfo(InputStream ins, ArrayList CertList) throws PKIException {
        CertStore certStore = null;
        try {
            certStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(CertList));
        }
        catch (Exception e) {
            throw new PKIException("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u5931\u8d25\uff0c\u52a0\u8f7d\u8bc1\u4e66\u9519\u8bef\uff1a" + e.getMessage());
        }
        ASN1Set SignerInfoset = this.signedData.getSignerInfos();
        Collection<? extends Certificate> certCollection = null;
        int i = 0;
        while (i < SignerInfoset.size()) {
            SignerInfo signerInfo = SignerInfo.getInstance(SignerInfoset.getObjectAt(i));
            SignerId sid = new SignerId();
            SignerIdentifier signerid = signerInfo.getSID();
            if (signerid.isTagged()) {
                ASN1OctetString octs = ASN1OctetString.getInstance(signerid.getId());
                sid.setSubjectKeyIdentifier(octs.getOctets());
            } else {
                IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(signerid.getId());
                ByteArrayOutputStream sidbOut = new ByteArrayOutputStream();
                ASN1OutputStream sidaOut = new ASN1OutputStream(sidbOut);
                try {
                    sidaOut.writeObject(iAnds.getName());
                    sid.setIssuer(sidbOut.toByteArray());
                    sidaOut.flush();
                    sidaOut.close();
                    sidbOut.flush();
                    sidbOut.close();
                }
                catch (IOException ex3) {
                    throw new PKIException("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u5931\u8d25: " + ex3.getMessage());
                }
                sid.setSerialNumber(iAnds.getSerialNumber().getValue());
            }
            try {
                certCollection = certStore.getCertificates(sid);
            }
            catch (Exception e) {
                throw new PKIException("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u5931\u8d25: " + e.getMessage());
            }
            Iterator<? extends Certificate> certIt = certCollection.iterator();
            X509Certificate cert = (X509Certificate)certIt.next();
            if (this.verifySignerInfo(ins, cert, signerInfo, true)) {
                X509Cert x509Cert = null;
                try {
                    x509Cert = new X509Cert(cert.getEncoded());
                }
                catch (Exception ex) {
                    throw new PKIException("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u5931\u8d25\uff0c\u89e3\u6790\u7b7e\u540d\u8005\u8bc1\u4e66\u9519\u8bef\uff1a" + ex.getMessage());
                }
                return x509Cert;
            }
            ++i;
        }
        return null;
    }

    private boolean verifySignerInfo(byte[] sourceData, X509Certificate cert, SignerInfo signerInfo, boolean isCheckTime) {
        Attribute t;
        AttributeTable attr = null;
        if (signerInfo.getAuthenticatedAttributes() != null) {
            attr = new AttributeTable(signerInfo.getAuthenticatedAttributes());
        }
        if (isCheckTime && attr != null && (t = attr.get(CMSAttributes.signingTime)) != null) {
            Time time = Time.getInstance(t.getAttrValues().getObjectAt(0).getDERObject());
            try {
                cert.checkValidity(time.getDate());
            }
            catch (CertificateNotYetValidException ex) {
                return false;
            }
            catch (CertificateExpiredException ex) {
                return false;
            }
        }
        return this.doVerify(cert.getPublicKey(), attr, this.GetSignMechanism(signerInfo), signerInfo.getAuthenticatedAttributes(), sourceData, signerInfo.getEncryptedDigest().getOctets());
    }

    private boolean verifySignerInfo(InputStream ins, X509Certificate cert, SignerInfo signerInfo, boolean isCheckTime) throws PKIException {
        Attribute t;
        AttributeTable attr = null;
        if (signerInfo.getAuthenticatedAttributes() != null) {
            attr = new AttributeTable(signerInfo.getAuthenticatedAttributes());
        }
        if (isCheckTime && attr != null && (t = attr.get(CMSAttributes.signingTime)) != null) {
            Time time = Time.getInstance(t.getAttrValues().getObjectAt(0).getDERObject());
            try {
                cert.checkValidity(time.getDate());
            }
            catch (CertificateNotYetValidException ex) {
                return false;
            }
            catch (CertificateExpiredException ex) {
                return false;
            }
        }
        return this.doVerify(cert.getPublicKey(), attr, this.GetSignMechanism(signerInfo), signerInfo.getAuthenticatedAttributes(), ins, signerInfo.getEncryptedDigest().getOctets());
    }

    private Mechanism GetSignMechanism(SignerInfo signerInfo) {
        String DigestAlgorithm = signerInfo.getDigestAlgorithm().getObjectId().getId();
        String EncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm().getObjectId().getId();
        if (EncryptionAlgorithm.equals("1.2.840.113549.1.1.1")) {
            if (DigestAlgorithm.equals("1.2.840.113549.2.2")) {
                return new Mechanism("MD2withRSAEncryption");
            }
            if (DigestAlgorithm.equals("1.2.840.113549.2.5")) {
                return new Mechanism("MD5withRSAEncryption");
            }
            if (DigestAlgorithm.equals("1.3.14.3.2.26")) {
                return new Mechanism("SHA1withRSAEncryption");
            }
            return null;
        }
        return null;
    }

    private String GetDigestTypeName(Mechanism signmechanism) throws PKIException {
        String digestTypeName = null;
        if (signmechanism.getMechanismType().equals("MD2withRSAEncryption")) {
            digestTypeName = "MD2";
        } else if (signmechanism.getMechanismType().equals("MD5withRSAEncryption")) {
            digestTypeName = "MD5";
        } else if (signmechanism.getMechanismType().equals("SHA1withRSAEncryption")) {
            digestTypeName = "SHA1";
        } else if (signmechanism.getMechanismType().equals("SHA1withDSA")) {
            digestTypeName = "SHA1";
        } else {
            StringBuffer error = new StringBuffer();
            error.append("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
            error.append(" ");
            error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
            error.append(" ");
            error.append(signmechanism.getMechanismType());
            throw new PKIException("850205", error.toString());
        }
        return digestTypeName;
    }

    private boolean doVerify(PublicKey key, AttributeTable signedAttrTable, Mechanism signmechanism, ASN1Set signedAttributes, byte[] sourceData, byte[] signdata) {
        JKey jKey;
        block18: {
            Attribute type;
            block17: {
                Attribute dig;
                byte[] hash;
                block16: {
                    block15: {
                        if (sourceData == null) {
                            if (this.msg != null) {
                                sourceData = this.msg;
                            } else {
                                try {
                                    sourceData = this.getContent();
                                }
                                catch (PKIException ex1) {
                                    return false;
                                }
                            }
                            if (sourceData == null) {
                                return false;
                            }
                        }
                        if (signmechanism == null) {
                            return false;
                        }
                        jKey = Parser.convertCFCAPublicKey(key);
                        if (signedAttrTable == null) {
                            return this.session.verifySign(signmechanism, jKey, sourceData, signdata);
                        }
                        hash = this.session.digest(new Mechanism(this.GetDigestTypeName(signmechanism)), sourceData);
                        dig = signedAttrTable.get(CMSAttributes.messageDigest);
                        type = signedAttrTable.get(CMSAttributes.contentType);
                        if (dig != null) break block15;
                        return false;
                    }
                    if (type != null) break block16;
                    return false;
                }
                byte[] signedHash = ((ASN1OctetString)dig.getAttrValues().getObjectAt(0)).getOctets();
                if (MessageDigest.isEqual(hash, signedHash)) break block17;
                return false;
            }
            DERObjectIdentifier typeOID = (DERObjectIdentifier)type.getAttrValues().getObjectAt(0);
            if (typeOID.equals(this.signedData.getEncapContentInfo().getContentType())) break block18;
            return false;
        }
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(signedAttributes);
            byte[] bytedata = bOut.toByteArray();
            dOut.flush();
            dOut.close();
            bOut.flush();
            bOut.close();
            return this.session.verifySign(signmechanism, jKey, bytedata, signdata);
        }
        catch (PKIException ex) {
            return false;
        }
        catch (IOException ex1) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doVerify(PublicKey key, AttributeTable signedAttrTable, Mechanism signmechanism, ASN1Set signedAttributes, InputStream ins, byte[] signdata) throws PKIException {
        if (signmechanism == null) {
            return false;
        }
        byte[] digestData = null;
        byte[] buffer = null;
        try {
            JKey jKey = Parser.convertCFCAPublicKey(key);
            MessageDigest digestSHA = null;
            try {
                String digestType = this.GetDigestTypeName(signmechanism);
                digestSHA = MessageDigest.getInstance(digestType, "BC");
            }
            catch (Exception ex1) {
                throw new PKIException("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u6587\u6458\u7b97\u6cd5\uff1a" + ex1.getMessage());
            }
            buffer = new byte[2048];
            int len = -1;
            try {
                while (true) {
                    if ((len = ins.read(buffer)) <= 0) {
                        digestData = digestSHA.digest();
                        ins.close();
                        break;
                    }
                    digestSHA.update(buffer, 0, len);
                }
            }
            catch (IOException ex) {
                throw new PKIException("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u5931\u8d25\uff0c\u5bf9\u539f\u6587\u505a\u6587\u6458\u9519\u8bef\uff1a" + ex.getMessage());
            }
            if (signedAttrTable == null) {
                DERObjectIdentifier digestOID = new DERObjectIdentifier(PKCSObjectIdentifiers.sha1.getId());
                AlgorithmIdentifier digestAlg = new AlgorithmIdentifier(digestOID, new DERNull());
                DigestInfo digestInfo = new DigestInfo(digestAlg, digestData);
                byte[] bDigestInfo = Parser.writeDERObj2Bytes(digestInfo);
                byte[] decryptHash = this.session.decrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), jKey, signdata);
                boolean bl = MessageDigest.isEqual(decryptHash, bDigestInfo);
                return bl;
            }
            Attribute dig = signedAttrTable.get(CMSAttributes.messageDigest);
            Attribute type = signedAttrTable.get(CMSAttributes.contentType);
            if (dig == null) {
                return false;
            }
            if (type == null) {
                return false;
            }
            byte[] signedHash = ((ASN1OctetString)dig.getAttrValues().getObjectAt(0)).getOctets();
            if (!MessageDigest.isEqual(digestData, signedHash)) {
                return false;
            }
            DERObjectIdentifier typeOID = (DERObjectIdentifier)type.getAttrValues().getObjectAt(0);
            if (!typeOID.equals(this.signedData.getEncapContentInfo().getContentType())) {
                return false;
            }
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            byte[] bytedata = null;
            try {
                dOut.writeObject(signedAttributes);
                bytedata = bOut.toByteArray();
                dOut.flush();
                dOut.close();
                bOut.flush();
                bOut.close();
            }
            catch (IOException ex2) {
                throw new PKIException("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u5931\u8d25\uff0c\u5e8f\u5217\u5316\u7b7e\u540d\u5c5e\u6027\u9519\u8bef\uff1a" + ex2.getMessage());
            }
            boolean bl = this.session.verifySign(signmechanism, jKey, bytedata, signdata);
            return bl;
        }
        catch (PKIException ex) {
            throw ex;
        }
        finally {
            digestData = null;
            buffer = null;
        }
    }

    private static byte[] writeDERObj2Bytes(DEREncodable obj) throws PKIException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(bos);
        try {
            dos.writeObject(obj);
            byte[] byteData = bos.toByteArray();
            dos.flush();
            dos.close();
            bos.flush();
            bos.close();
            return byteData;
        }
        catch (Exception ex) {
            throw new PKIException("8503850306", "\u83b7\u53d6DER\u5bf9\u8c61byte\u7f16\u7801\u5931\u8d25", ex);
        }
    }

    public static void main(String[] args) {
        try {
            X509Cert x509Cert = null;
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            try {
                byte[] test = "test".getBytes();
                byte[] test2 = "test".getBytes();
                boolean arraysEqual = Arrays.equals(test, test2);
                int a = 99;
            }
            catch (Exception test) {
                // empty catch block
            }
            CMSSignedDataCFCA cmsSignedData = new CMSSignedDataCFCA(session);
            cmsSignedData.load("d:/gw/files/300Ms");
            x509Cert = cmsSignedData.verify(new FileInputStream("d:/gw/files/\u6d4b\u8bd5300M8.enc"));
            String subjct = x509Cert.getSubject();
            System.out.println("cert info : " + subjct);
        }
        catch (Exception ex) {
            System.out.println("ex: " + ex.toString());
        }
    }

    private class Signer {
        JKey privateKey = null;
        X509Cert cert = null;
        Mechanism sign_Mechanism = null;
        AttributeTable sAttr = null;
        AttributeTable unsAttr = null;
        Session session = null;

        Signer(Session session, JKey key, X509Cert cert, Mechanism sign_Mechanism) {
            this.session = session;
            this.privateKey = key;
            this.cert = cert;
            this.sign_Mechanism = sign_Mechanism;
        }

        Signer(Session session, JKey key, X509Cert cert, Mechanism sign_Mechanism, AttributeTable sAttr, AttributeTable unsAttr) {
            this.session = session;
            this.privateKey = key;
            this.cert = cert;
            this.sign_Mechanism = sign_Mechanism;
            this.sAttr = sAttr;
            this.unsAttr = unsAttr;
        }

        AttributeTable getSignedAttributes() {
            return this.sAttr;
        }

        AttributeTable getUnsignedAttributes() {
            return this.unsAttr;
        }

        JKey getKey() {
            return this.privateKey;
        }

        X509Cert getCertificate() {
            return this.cert;
        }

        Mechanism getSignMechanism() {
            return this.sign_Mechanism;
        }

        String GetDigestTypeName() throws PKIException {
            String digestTypeName = null;
            if (this.sign_Mechanism.getMechanismType().equals("MD2withRSAEncryption")) {
                digestTypeName = "MD2";
            } else if (this.sign_Mechanism.getMechanismType().equals("MD5withRSAEncryption")) {
                digestTypeName = "MD5";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withRSAEncryption")) {
                digestTypeName = "SHA1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withDSA")) {
                digestTypeName = "SHA1";
            } else {
                StringBuffer error = new StringBuffer();
                error.append("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
                error.append(" ");
                error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
                error.append(" ");
                error.append(this.sign_Mechanism.getMechanismType());
                throw new PKIException("850205", error.toString());
            }
            return digestTypeName;
        }

        String GetEncTypeName() throws PKIException {
            String EncTypeName = null;
            if (this.sign_Mechanism.getMechanismType().equals("MD2withRSAEncryption")) {
                EncTypeName = "RSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("MD5withRSAEncryption")) {
                EncTypeName = "RSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withRSAEncryption")) {
                EncTypeName = "RSA";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withDSA")) {
                EncTypeName = "DSA";
            } else {
                StringBuffer error = new StringBuffer();
                error.append("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
                error.append(" ");
                error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
                error.append(" ");
                error.append(this.sign_Mechanism.getMechanismType());
                throw new PKIException("850205", error.toString());
            }
            return EncTypeName;
        }

        String GetDigestTypeOID() throws PKIException {
            String digestTypeOID = null;
            if (this.sign_Mechanism.getMechanismType().equals("MD2withRSAEncryption")) {
                digestTypeOID = "1.2.840.113549.2.2";
            } else if (this.sign_Mechanism.getMechanismType().equals("MD5withRSAEncryption")) {
                digestTypeOID = "1.2.840.113549.2.5";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withRSAEncryption")) {
                digestTypeOID = "1.3.14.3.2.26";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withDSA")) {
                digestTypeOID = "1.3.14.3.2.26";
            } else {
                StringBuffer error = new StringBuffer();
                error.append("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
                error.append(" ");
                error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
                error.append(" ");
                error.append(this.sign_Mechanism.getMechanismType());
                throw new PKIException("850205", error.toString());
            }
            return digestTypeOID;
        }

        String GetEncTypeOID() throws PKIException {
            String EncTypeOID = null;
            if (this.sign_Mechanism.getMechanismType().equals("MD2withRSAEncryption")) {
                EncTypeOID = "1.2.840.113549.1.1.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("MD5withRSAEncryption")) {
                EncTypeOID = "1.2.840.113549.1.1.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withRSAEncryption")) {
                EncTypeOID = "1.2.840.113549.1.1.1";
            } else if (this.sign_Mechanism.getMechanismType().equals("SHA1withDSA")) {
                EncTypeOID = "1.2.840.10040.4.3";
            } else {
                StringBuffer error = new StringBuffer();
                error.append("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25");
                error.append(" ");
                error.append("\u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b");
                error.append(" ");
                error.append(this.sign_Mechanism.getMechanismType());
                throw new PKIException("850205", error.toString());
            }
            return EncTypeOID;
        }

        SignerInfo toSignerInfo(DERObjectIdentifier contentType, byte[] content, boolean addDefaultAttributes, boolean setIssuerAndSN) throws PKIException, IOException {
            ASN1EncodableVector v;
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(this.GetDigestTypeOID()), new DERNull());
            AlgorithmIdentifier encAlgId = this.GetEncTypeOID().equals("1.2.840.10040.4.3") ? new AlgorithmIdentifier(new DERObjectIdentifier(this.GetEncTypeOID())) : new AlgorithmIdentifier(new DERObjectIdentifier(this.GetEncTypeOID()), new DERNull());
            DERSet signedAttr = null;
            DERSet unsignedAttr = null;
            Object sig = null;
            Object dig = null;
            byte[] hash = this.session.digest(new Mechanism(this.GetDigestTypeName()), content);
            AttributeTable attr = this.getSignedAttributes();
            if (attr != null) {
                v = new ASN1EncodableVector();
                if (attr.get(CMSAttributes.contentType) == null) {
                    v.add(new Attribute(CMSAttributes.contentType, new DERSet(contentType)));
                } else {
                    v.add(attr.get(CMSAttributes.contentType));
                }
                if (attr.get(CMSAttributes.signingTime) == null) {
                    v.add(new Attribute(CMSAttributes.signingTime, new DERSet(new Time(new Date()))));
                } else {
                    v.add(attr.get(CMSAttributes.signingTime));
                }
                v.add(new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(hash))));
                Hashtable ats = attr.toHashtable();
                ats.remove(CMSAttributes.contentType);
                ats.remove(CMSAttributes.signingTime);
                ats.remove(CMSAttributes.messageDigest);
                Iterator it = ats.values().iterator();
                while (it.hasNext()) {
                    v.add(Attribute.getInstance(it.next()));
                }
                signedAttr = new DERSet(v);
            } else if (addDefaultAttributes) {
                v = new ASN1EncodableVector();
                v.add(new Attribute(CMSAttributes.contentType, new DERSet(contentType)));
                v.add(new Attribute(CMSAttributes.signingTime, new DERSet(new DERUTCTime(new Date()))));
                v.add(new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(hash))));
                signedAttr = new DERSet(v);
            }
            attr = this.getUnsignedAttributes();
            if (attr != null) {
                Hashtable ats = attr.toHashtable();
                Iterator it = ats.values().iterator();
                ASN1EncodableVector v2 = new ASN1EncodableVector();
                while (it.hasNext()) {
                    v2.add(Attribute.getInstance(it.next()));
                }
                unsignedAttr = new DERSet(v2);
            }
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            if (signedAttr != null) {
                DEROutputStream dOut = new DEROutputStream(bOut);
                dOut.writeObject(signedAttr);
                dOut.flush();
                dOut.close();
            } else {
                bOut.write(content);
            }
            DEROctetString encDigest = new DEROctetString(this.session.sign(this.sign_Mechanism, this.privateKey, bOut.toByteArray()));
            ByteArrayInputStream bIn = new ByteArrayInputStream(this.cert.getTBSCertificate());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(aIn.readObject());
            SignerInfo signerInfo = null;
            if (setIssuerAndSN) {
                IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
                signerInfo = new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, encAlgId, encDigest, unsignedAttr);
            } else {
                X509CertificateStructure certificateStructure = this.cert.getCertStructure();
                SubjectPublicKeyInfo subjectKeyInfo = certificateStructure.getSubjectPublicKeyInfo();
                SubjectKeyIdentifier sujectKeyIdentifer = new SubjectKeyIdentifier(subjectKeyInfo);
                ASN1OctetString encSid = (ASN1OctetString)sujectKeyIdentifer.getDERObject();
                signerInfo = new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, encAlgId, encDigest, unsignedAttr);
            }
            bOut.flush();
            bOut.close();
            aIn.close();
            bIn.close();
            return signerInfo;
        }
    }

    private class SignerId
    extends X509CertSelector {
        private SignerId() {
        }

        public int hashCode() {
            byte[] subjectId;
            int code = 0;
            if (this.getSerialNumber() != null) {
                code ^= this.getSerialNumber().hashCode();
            }
            if (this.getIssuerAsString() != null) {
                code ^= this.getIssuerAsString().hashCode();
            }
            if ((subjectId = this.getSubjectKeyIdentifier()) != null) {
                int i = 0;
                while (i != subjectId.length) {
                    code ^= (subjectId[i] & 0xFF) << i % 4;
                    ++i;
                }
            }
            return code;
        }

        public boolean equals(Object o) {
            byte[] otherId;
            if (!(o instanceof SignerId)) {
                return false;
            }
            SignerId id = (SignerId)o;
            if (id.getSerialNumber() != null && !id.getSerialNumber().equals(this.getSerialNumber())) {
                return false;
            }
            if (id.getIssuerAsString() != null && !id.getIssuerAsString().equals(this.getIssuerAsString())) {
                return false;
            }
            byte[] subjectId = this.getSubjectKeyIdentifier();
            return subjectId == null || (otherId = id.getSubjectKeyIdentifier()) != null && Arrays.equals(subjectId, otherId);
        }
    }
}

