/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cms;

import com.cfca.util.pki.asn1.cms.KEKIdentifier;
import com.cfca.util.pki.asn1.cms.KEKRecipientInfo;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.cms.CMSException;
import com.cfca.util.pki.cms.CMSTypedStream;
import com.cfca.util.pki.cms.RecipientId;
import com.cfca.util.pki.cms.RecipientInformation;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo _info;
    private AlgorithmIdentifier _encAlg;

    public KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier encAlg, InputStream data) {
        super(encAlg, AlgorithmIdentifier.getInstance(info.getKeyEncryptionAlgorithm()), data);
        this._info = info;
        this._encAlg = encAlg;
        this._rid = new RecipientId();
        KEKIdentifier kekId = info.getKekid();
        this._rid.setKeyIdentifier(kekId.getKeyIdentifier().getOctets());
    }

    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        try {
            byte[] encryptedKey = this._info.getEncryptedKey().getOctets();
            Cipher keyCipher = Cipher.getInstance(this._keyEncAlg.getObjectId().getId(), prov);
            keyCipher.init(4, key);
            AlgorithmIdentifier aid = this._encAlg;
            String alg = aid.getObjectId().getId();
            Key sKey = keyCipher.unwrap(encryptedKey, alg, 3);
            return this.getContentFromSessionKey(sKey, prov);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
    }
}

