/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1OctetString;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.DERTaggedObject;
import com.cfca.util.pki.asn1.x509.AuthorityKeyIdentifier;
import com.cfca.util.pki.asn1.x509.GeneralName;
import com.cfca.util.pki.asn1.x509.GeneralNames;
import com.cfca.util.pki.asn1.x509.SubjectPublicKeyInfo;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.encoders.Hex;
import com.cfca.util.pki.extension.AbstractStandardExtension;
import com.cfca.util.pki.extension.GeneralNamesExt;
import java.math.BigInteger;
import java.util.Enumeration;

public class AuthorityKeyIdentifierExt
extends AbstractStandardExtension {
    private JKey pubKey = null;
    private String keyIdentifier = null;
    private String certIssuer = null;
    private BigInteger certSerialNumber = null;

    public AuthorityKeyIdentifierExt(JKey pubKey) {
        this.pubKey = pubKey;
        this.critical = false;
        this.OID = X509Extensions.AuthorityKeyIdentifier.getId();
    }

    public AuthorityKeyIdentifierExt(ASN1Sequence asn1Sequence) {
        if (asn1Sequence.size() == 0) {
            return;
        }
        this.OID = X509Extensions.AuthorityKeyIdentifier.getId();
        Enumeration e = asn1Sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject o = (DERTaggedObject)e.nextElement();
            switch (o.getTagNo()) {
                case 0: {
                    this.keyIdentifier = new String(Hex.encode(ASN1OctetString.getInstance(o, false).getOctets()));
                    break;
                }
                case 1: {
                    DERObject doj = GeneralNames.getInstance(o, false).getDERObject();
                    GeneralNamesExt generalNames = new GeneralNamesExt((ASN1Sequence)doj);
                    this.certIssuer = generalNames.getGeneralName(0);
                    break;
                }
                case 2: {
                    this.certSerialNumber = DERInteger.getInstance(o, false).getValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal tag");
                }
            }
        }
    }

    public void setAuthorityCertIssuer(String authorityCertIssuer) {
        this.certIssuer = authorityCertIssuer;
    }

    public String getAuthorityCertIssuer() {
        return this.certIssuer;
    }

    public String getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public void setAuthorityCertSerialNumber(BigInteger authorityCertSerialNumber) {
        this.certSerialNumber = authorityCertSerialNumber;
    }

    public BigInteger getAuthorityCertSerialNumber() {
        return this.certSerialNumber;
    }

    public void setAuthorityCertSerialNumber(int authorityCertSerialNumber) {
        this.certSerialNumber = new BigInteger(String.valueOf(authorityCertSerialNumber));
    }

    public void setAuthorityCertSerialNumber(String authorityCertSerialNumber) {
        this.certSerialNumber = new BigInteger(authorityCertSerialNumber);
    }

    public String getAuthorityCertSerialNumberStringType() {
        return this.certSerialNumber.toString();
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean getCritical() {
        return this.critical;
    }

    public byte[] encode() throws PKIException {
        SubjectPublicKeyInfo spki = null;
        spki = Parser.key2SPKI(this.pubKey);
        AuthorityKeyIdentifier authKeyID = null;
        GeneralNames name = null;
        if (this.certIssuer != null && !this.certIssuer.equals("")) {
            X509Name x509Name = new X509Name(this.certIssuer);
            GeneralName genName = new GeneralName(x509Name);
            name = new GeneralNames(new DERSequence(genName));
        }
        authKeyID = name == null && this.certSerialNumber == null ? new AuthorityKeyIdentifier(spki) : (name == null ? new AuthorityKeyIdentifier(spki, this.certSerialNumber) : (this.certSerialNumber == null ? new AuthorityKeyIdentifier(spki, name) : new AuthorityKeyIdentifier(spki, name, this.certSerialNumber)));
        DEROctetString octetValue = new DEROctetString(authKeyID.getDERObject());
        return octetValue.getOctets();
    }
}

