/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERPrintableString;
import com.cfca.util.pki.asn1.DERUTF8String;
import com.cfca.util.pki.asn1.x509.IdentifyCode;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.extension.AbstractStandardExtension;

public class IdentifyCodeExt
extends AbstractStandardExtension {
    private String residenterCardNumber = null;
    private String militaryOfficerCardNumber = null;
    private String passportNumber = null;
    private IdentifyCode jitIdentifyCode = null;

    public IdentifyCodeExt() {
        this.OID = X509Extensions.IdentifyCode.getId();
        this.critical = false;
    }

    public IdentifyCodeExt(ASN1Set obj) {
        this.OID = X509Extensions.IdentifyCode.getId();
        this.jitIdentifyCode = new IdentifyCode(obj);
    }

    public IdentifyCodeExt(String residenterCardNumber, String militaryOfficerCardNumber, String passportNumber) {
        this.OID = X509Extensions.IdentifyCode.getId();
        this.critical = false;
        this.residenterCardNumber = residenterCardNumber;
        this.militaryOfficerCardNumber = militaryOfficerCardNumber;
        this.passportNumber = passportNumber;
    }

    public String getResidenterCardNumber() {
        if (this.jitIdentifyCode == null) {
            return null;
        }
        return this.jitIdentifyCode.getResidenterCardNumber().getString();
    }

    public String getMilitaryOfficerCardNumber() {
        if (this.jitIdentifyCode == null) {
            return null;
        }
        return this.jitIdentifyCode.getMilitaryOfficerCardNumber().getString();
    }

    public String getPassportNumber() {
        if (this.jitIdentifyCode == null) {
            return null;
        }
        return this.jitIdentifyCode.getPassportNumber().getString();
    }

    public void setResidenterCardNumber(String value) {
        this.residenterCardNumber = value;
    }

    public void setMilitaryOfficerCardNumber(String value) {
        this.militaryOfficerCardNumber = value;
    }

    public void setPassportNumber(String value) {
        this.passportNumber = value;
    }

    public byte[] encode() throws PKIException {
        if (this.residenterCardNumber == null && this.militaryOfficerCardNumber == null && this.passportNumber == null) {
            throw new PKIException("850503", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        return new DEROctetString(new IdentifyCode(new DERPrintableString(this.residenterCardNumber), new DERUTF8String(this.militaryOfficerCardNumber), new DERPrintableString(this.passportNumber)).getDERObject()).getOctets();
    }

    public boolean getCritical() {
        return this.critical;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }
}

