/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.extension;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERPrintableString;
import com.cfca.util.pki.asn1.x509.TaxationNumeber;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.extension.AbstractStandardExtension;

public class TaxationNumberExt
extends AbstractStandardExtension {
    private String taxationnumber = null;

    public TaxationNumberExt() {
        this.OID = X509Extensions.TaxationNumber.getId();
        this.critical = false;
    }

    public TaxationNumberExt(DERPrintableString obj) {
        this.OID = X509Extensions.TaxationNumber.getId();
        this.taxationnumber = obj.getString();
    }

    public TaxationNumberExt(String value) {
        this.OID = X509Extensions.TaxationNumber.getId();
        this.critical = false;
        this.taxationnumber = value;
    }

    public void SetTaxationNumber(String value) {
        this.taxationnumber = value;
    }

    public String GetTaxationNumber() {
        return this.taxationnumber;
    }

    public byte[] encode() throws PKIException {
        if (this.taxationnumber == null) {
            throw new PKIException("850503", "\u6269\u5c55\u57df\u7684\u6570\u636e\u9879\u4e3a\u7a7a");
        }
        return new DEROctetString(new TaxationNumeber(this.taxationnumber).getDERObject()).getOctets();
    }

    public boolean getCritical() {
        return this.critical;
    }

    public String getOID() {
        return this.OID;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }
}

