/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.ocsp;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROutputStream;
import com.cfca.util.pki.asn1.ocsp.ResponseData;
import com.cfca.util.pki.asn1.ocsp.SingleResponse;
import com.cfca.util.pki.asn1.x509.X509Extension;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.ocsp.RespID;
import com.cfca.util.pki.ocsp.SingleResp;
import java.io.ByteArrayOutputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class RespData
implements java.security.cert.X509Extension {
    ResponseData data;

    public RespData(ResponseData data) {
        this.data = data;
    }

    public int getVersion() {
        return this.data.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() throws PKIException {
        try {
            return this.data.getProducedAt().getDate();
        }
        catch (ParseException e) {
            throw new PKIException("850816", "\u83b7\u5f97ProducedAt\u5931\u8d25", e);
        }
    }

    public SingleResp[] getResponses() {
        ASN1Sequence s = this.data.getResponses();
        SingleResp[] rs = new SingleResp[s.size()];
        int i = 0;
        while (i != rs.length) {
            rs[i] = new SingleResp(SingleResponse.getInstance(s.getObjectAt(i)));
            ++i;
        }
        return rs;
    }

    public X509Extensions getResponseExtensions() {
        return this.data.getResponseExtensions();
    }

    public boolean hasUnsupportedCriticalExtension() {
        Set extns = this.getCriticalExtensionOIDs();
        return extns != null && !extns.isEmpty();
    }

    private Set getExtensionOIDs(boolean critical) {
        HashSet<String> set = new HashSet<String>();
        X509Extensions extensions = this.getResponseExtensions();
        if (extensions != null) {
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                X509Extension ext = extensions.getExtension(oid);
                if (critical != ext.isCritical()) continue;
                set.add(oid.getId());
            }
        }
        return set;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    public byte[] getExtensionValue(String oid) {
        X509Extension ext;
        X509Extensions exts = this.getResponseExtensions();
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            try {
                dOut.writeObject(ext.getValue());
                return bOut.toByteArray();
            }
            catch (Exception e) {
                throw new RuntimeException("error encoding " + e.toString());
            }
        }
        return null;
    }
}

