/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.pkcs;

import com.cfca.util.ini.MACAddressUtil;
import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.ASN1OctetString;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.BERSet;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.pkcs.pkcs7.ContentInfo;
import com.cfca.util.pki.asn1.pkcs.pkcs7.IssuerAndSerialNumber;
import com.cfca.util.pki.asn1.pkcs.pkcs7.SignedData;
import com.cfca.util.pki.asn1.pkcs.pkcs7.SignerInfo;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.CertificateList;
import com.cfca.util.pki.asn1.x509.DigestInfo;
import com.cfca.util.pki.asn1.x509.X509CertificateStructure;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.crl.X509CRL;
import com.cfca.util.pki.encoders.Base64;
import com.cfca.util.pki.pkcs.PKCS12;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Enumeration;

public class PKCS7SignedData {
    private String signedMAC = null;
    static final String CFCA_MAC_ID = "CFCASECLD";
    private Session session = null;
    private SignedData signedData = null;
    static final String pkcs_7 = "1.2.840.113549.1.7";
    public static final String DATA = new DERObjectIdentifier("1.2.840.113549.1.7.1").getId();
    public static final String SIGNED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.2").getId();
    public static final String ENVELOPED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.3").getId();
    public static final String SIGNED_ENVELOPED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.4").getId();
    public static final String DIGESTED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.5").getId();
    public static final String ENCRYPTED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.6").getId();

    public PKCS7SignedData(Session session) {
        this.session = session;
    }

    public byte[] generateSignedData(boolean withContent, String contentType, InputStream sourceData, Mechanism digestAlg, JKey privateKey, X509Cert[] cert, X509CRL[] crl) throws PKIException {
        try {
            byte[] content = new byte[sourceData.available()];
            sourceData.read(content);
            sourceData.close();
            return this.generateSignedData(withContent, contentType, content, digestAlg, privateKey, cert, crl);
        }
        catch (Exception ex) {
            throw new PKIException("850614", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
    }

    public byte[] generateSignedDataWithMAC(boolean withContent, String contentType, byte[] sourceData, Mechanism digestAlg, JKey privateKey, X509Cert[] cert, X509CRL[] crl) throws PKIException {
        if (cert == null) {
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
        }
        BigInteger sn = cert[0].getSerialNumber();
        String issuer = cert[0].getIssuer();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(new X509Name(issuer), sn);
        AlgorithmIdentifier digestAlgorithm = null;
        AlgorithmIdentifier digestEncryptAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull());
        Mechanism signMechansim = null;
        if (privateKey.getKeyType().equals("RSA_Private")) {
            if (digestAlg.getMechanismType().equals("MD2")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md2, new DERNull());
                signMechansim = new Mechanism("MD2withRSAEncryption");
            } else if (digestAlg.getMechanismType().equals("MD5")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, new DERNull());
                signMechansim = new Mechanism("MD5withRSAEncryption");
            } else if (digestAlg.getMechanismType().equals("SHA1")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, new DERNull());
                signMechansim = new Mechanism("SHA1withRSAEncryption");
            }
        } else {
            throw new PKIException("850610", "\u4ea7\u751f\u52a0\u5bc6\u6570\u636e\uff0c\u52a0\u5bc6\u673a\u5236\u4e0d\u652f\u6301");
        }
        DERObjectIdentifier authContentInfoID = PKCSObjectIdentifiers.pkcs_9_at_contentType;
        DERObjectIdentifier authContentInfoIDD = PKCSObjectIdentifiers.data;
        DERSet authConInfoIDSet = new DERSet(authContentInfoIDD);
        ASN1EncodableVector authConInfoIDVec = new ASN1EncodableVector();
        authConInfoIDVec.add(authContentInfoID);
        authConInfoIDVec.add(authConInfoIDSet);
        DERSequence authConInfoIDSeq = new DERSequence(authConInfoIDVec);
        DERObjectIdentifier authContentInfoDigID = PKCSObjectIdentifiers.pkcs_9_at_messageDigest;
        byte[] digestContInfo = this.session.digest(digestAlg, sourceData);
        DEROctetString derOctetDigetCont = new DEROctetString(digestContInfo);
        DERSet authContentInfoDig = new DERSet(derOctetDigetCont);
        ASN1EncodableVector authConInfoDigVec = new ASN1EncodableVector();
        authConInfoDigVec.add(authContentInfoDigID);
        authConInfoDigVec.add(authContentInfoDig);
        DERSequence authConInfoDigSeq = new DERSequence(authConInfoDigVec);
        DERObjectIdentifier authMACAddressID = PKCSObjectIdentifiers.id_ct_MACAddress;
        String strAuthMACAddress = null;
        try {
            strAuthMACAddress = CFCA_MAC_ID + MACAddressUtil.getMacAddress();
        }
        catch (IOException e) {
            throw new PKIException("850614", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", e);
        }
        DEROctetString derOctetMACAddress = new DEROctetString(strAuthMACAddress.getBytes());
        DERSet authOctetMACAddress = new DERSet(derOctetMACAddress);
        ASN1EncodableVector authMacAddressVect = new ASN1EncodableVector();
        authMacAddressVect.add(authMACAddressID);
        authMacAddressVect.add(authOctetMACAddress);
        DERSequence authMacAddressSeq = new DERSequence(authMacAddressVect);
        ASN1EncodableVector authenticatedAttributesVect = new ASN1EncodableVector();
        authenticatedAttributesVect.add(authConInfoIDSeq);
        authenticatedAttributesVect.add(authConInfoDigSeq);
        authenticatedAttributesVect.add(authMacAddressSeq);
        DERSet authenticatedAttributes = new DERSet(authenticatedAttributesVect);
        byte[] bAuthenticatedAttributes = Parser.writeDERObj2Bytes(authenticatedAttributes);
        byte[] encryptedSignature = this.session.sign(signMechansim, privateKey, bAuthenticatedAttributes);
        DEROctetString encryptedData = new DEROctetString(encryptedSignature);
        SignerInfo signerInfo = new SignerInfo(new DERInteger(1), issuerAndSn, digestAlgorithm, authenticatedAttributes, digestEncryptAlg, encryptedData, null);
        DEROctetString derSourceData = new DEROctetString(sourceData);
        ContentInfo contentInfo = null;
        contentInfo = withContent ? (contentType == null ? new ContentInfo(PKCSObjectIdentifiers.data, derSourceData) : new ContentInfo(new DERObjectIdentifier(contentType), derSourceData)) : (contentType == null ? new ContentInfo(PKCSObjectIdentifiers.data) : new ContentInfo(new DERObjectIdentifier(contentType)));
        ASN1EncodableVector derV = new ASN1EncodableVector();
        derV.add(digestAlgorithm);
        BERSet digestAlgorithms = new BERSet(derV);
        derV = new ASN1EncodableVector();
        derV.add(signerInfo);
        DERSet signerInfos = new DERSet(derV);
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < cert.length) {
            X509CertificateStructure certStruc = cert[i].getCertStructure();
            v.add(certStruc);
            ++i;
        }
        BERSet setCert = new BERSet(v);
        BERSet setCRL = null;
        if (crl != null) {
            int i2 = 0;
            while (i2 < crl.length) {
                CertificateList certList = crl[i2].getCertificateList();
                v.add(certList);
                ++i2;
            }
            setCRL = new BERSet(v);
        }
        SignedData signedData = new SignedData(new DERInteger(1), digestAlgorithms, contentInfo, setCert, setCRL, signerInfos);
        return Parser.writeDERObj2Bytes(signedData);
    }

    public byte[] generateSignedData(boolean withContent, String contentType, byte[] sourceData, Mechanism digestAlg, JKey privateKey, X509Cert[] cert, X509CRL[] crl) throws PKIException {
        if (cert == null) {
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
        }
        BigInteger sn = cert[0].getSerialNumber();
        String issuer = cert[0].getIssuer();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(new X509Name(issuer), sn);
        AlgorithmIdentifier digestAlgorithm = null;
        AlgorithmIdentifier digestEncryptAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull());
        Mechanism signMechansim = null;
        if (privateKey.getKeyType().equals("RSA_Private")) {
            if (digestAlg.getMechanismType().equals("MD2")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md2, new DERNull());
                signMechansim = new Mechanism("MD2withRSAEncryption");
            } else if (digestAlg.getMechanismType().equals("MD5")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, new DERNull());
                signMechansim = new Mechanism("MD5withRSAEncryption");
            } else if (digestAlg.getMechanismType().equals("SHA1")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, new DERNull());
                signMechansim = new Mechanism("SHA1withRSAEncryption");
            }
        } else {
            throw new PKIException("850610", "\u4ea7\u751f\u52a0\u5bc6\u6570\u636e\uff0c\u52a0\u5bc6\u673a\u5236\u4e0d\u652f\u6301");
        }
        byte[] encryptedSignature = this.session.sign(signMechansim, privateKey, sourceData);
        DEROctetString encryptedData = new DEROctetString(encryptedSignature);
        SignerInfo signerInfo = new SignerInfo(new DERInteger(1), issuerAndSn, digestAlgorithm, null, digestEncryptAlg, encryptedData, null);
        DEROctetString derSourceData = new DEROctetString(sourceData);
        ContentInfo contentInfo = null;
        contentInfo = withContent ? (contentType == null ? new ContentInfo(PKCSObjectIdentifiers.data, derSourceData) : new ContentInfo(new DERObjectIdentifier(contentType), derSourceData)) : (contentType == null ? new ContentInfo(PKCSObjectIdentifiers.data) : new ContentInfo(new DERObjectIdentifier(contentType)));
        ASN1EncodableVector derV = new ASN1EncodableVector();
        derV.add(digestAlgorithm);
        BERSet digestAlgorithms = new BERSet(derV);
        derV = new ASN1EncodableVector();
        derV.add(signerInfo);
        DERSet signerInfos = new DERSet(derV);
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < cert.length) {
            X509CertificateStructure certStruc = cert[i].getCertStructure();
            v.add(certStruc);
            ++i;
        }
        BERSet setCert = new BERSet(v);
        BERSet setCRL = null;
        if (crl != null) {
            int i2 = 0;
            while (i2 < crl.length) {
                CertificateList certList = crl[i2].getCertificateList();
                v.add(certList);
                ++i2;
            }
            setCRL = new BERSet(v);
        }
        SignedData signedData = new SignedData(new DERInteger(1), digestAlgorithms, contentInfo, setCert, setCRL, signerInfos);
        return Parser.writeDERObj2Bytes(signedData);
    }

    public byte[] generateSignedDataByHash(String contentType, byte[] hash, Mechanism digestAlg, JKey privateKey, X509Cert[] cert, X509CRL[] crl) throws PKIException {
        if (cert == null) {
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
        }
        BigInteger sn = cert[0].getSerialNumber();
        String issuer = cert[0].getIssuer();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(new X509Name(issuer), sn);
        AlgorithmIdentifier digestAlgorithm = null;
        AlgorithmIdentifier digestEncryptAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull());
        if (privateKey.getKeyType().equals("RSA_Private")) {
            if (digestAlg.getMechanismType().equals("MD2")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md2, new DERNull());
            } else if (digestAlg.getMechanismType().equals("MD5")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, new DERNull());
            } else if (digestAlg.getMechanismType().equals("SHA1")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, new DERNull());
            }
        } else {
            throw new PKIException("850610", "\u4ea7\u751f\u52a0\u5bc6\u6570\u636e\uff0c\u52a0\u5bc6\u673a\u5236\u4e0d\u652f\u6301");
        }
        DigestInfo digestInfo = new DigestInfo(digestAlgorithm, hash);
        byte[] bDigestInfo = Parser.writeDERObj2Bytes(digestInfo);
        byte[] encryptHash = this.session.encrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), privateKey, bDigestInfo);
        DEROctetString encryptedData = new DEROctetString(encryptHash);
        SignerInfo signerInfo = new SignerInfo(new DERInteger(1), issuerAndSn, digestAlgorithm, null, digestEncryptAlg, encryptedData, null);
        ContentInfo contentInfo = null;
        contentInfo = contentType == null ? new ContentInfo(PKCSObjectIdentifiers.data) : new ContentInfo(new DERObjectIdentifier(contentType));
        ASN1EncodableVector derV = new ASN1EncodableVector();
        derV.add(digestAlgorithm);
        BERSet digestAlgorithms = new BERSet(derV);
        derV = new ASN1EncodableVector();
        derV.add(signerInfo);
        DERSet signerInfos = new DERSet(derV);
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < cert.length) {
            X509CertificateStructure certStruc = cert[i].getCertStructure();
            v.add(certStruc);
            ++i;
        }
        BERSet setCert = new BERSet(v);
        BERSet setCRL = null;
        if (crl != null) {
            int i2 = 0;
            while (i2 < crl.length) {
                CertificateList certList = crl[i2].getCertificateList();
                v.add(certList);
                ++i2;
            }
            setCRL = new BERSet(v);
        }
        SignedData signedData = new SignedData(new DERInteger(1), digestAlgorithms, contentInfo, setCert, setCRL, signerInfos);
        return Parser.writeDERObj2Bytes(signedData);
    }

    public byte[] reSignSignedData(Mechanism digestAlg, JKey privateKey, X509Cert[] cert, X509CRL[] crl) throws PKIException {
        if (cert == null) {
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
        }
        if (this.signedData == null) {
            throw new PKIException("850648", "\u590d\u7b7e\u7b7e\u540d\u65f6\uff0c\u6ca1\u6709\u52a0\u8f7d\u5148\u524d\u7684\u7b7e\u540d\u6570\u636e");
        }
        ContentInfo contentInfo = this.signedData.getContentInfo();
        byte[] sourceData = null;
        if (contentInfo.getContent() == null) {
            throw new PKIException("850647", "\u590d\u7b7e\u7b7e\u540d\u65f6\uff0c\u6ca1\u6709\u5f85\u7b7e\u540d\u7684\u660e\u6587");
        }
        sourceData = contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo) ? ((ASN1OctetString)contentInfo.getContent()).getOctets() : Parser.writeDERObj2Bytes(contentInfo.getContent().getDERObject());
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        ASN1Set signerCerts = this.signedData.getCertificates();
        ASN1Set signerCRLs = this.signedData.getCrls();
        ASN1Set digestAlgs = this.signedData.getDigestAlgorithms();
        BigInteger sn = cert[0].getSerialNumber();
        String issuer = cert[0].getIssuer();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(new X509Name(issuer), sn);
        AlgorithmIdentifier digestAlgorithm = null;
        AlgorithmIdentifier digestEncryptAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull());
        Mechanism signMechansim = null;
        if (privateKey.getKeyType().equals("RSA_Private")) {
            if (digestAlg.getMechanismType().equals("MD2")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md2, new DERNull());
                signMechansim = new Mechanism("MD2withRSAEncryption");
            } else if (digestAlg.getMechanismType().equals("MD5")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, new DERNull());
                signMechansim = new Mechanism("MD5withRSAEncryption");
            } else if (digestAlg.getMechanismType().equals("SHA1")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, new DERNull());
                signMechansim = new Mechanism("SHA1withRSAEncryption");
            }
        } else {
            throw new PKIException("850610", "\u4ea7\u751f\u52a0\u5bc6\u6570\u636e\uff0c\u52a0\u5bc6\u673a\u5236\u4e0d\u652f\u6301");
        }
        byte[] encryptedSignature = this.session.sign(signMechansim, privateKey, sourceData);
        DEROctetString encryptedData = new DEROctetString(encryptedSignature);
        SignerInfo signerInfo = new SignerInfo(new DERInteger(1), issuerAndSn, digestAlgorithm, null, digestEncryptAlg, encryptedData, null);
        ASN1EncodableVector signInfoDerVec = new ASN1EncodableVector();
        Enumeration enumer = signerInfos.getObjects();
        if (enumer.hasMoreElements()) {
            signInfoDerVec.add((DEREncodable)enumer.nextElement());
        }
        signInfoDerVec.add(signerInfo);
        DERSet newSignerInfos = new DERSet(signInfoDerVec);
        this.signedData.setSignerInfos(newSignerInfos);
        ASN1EncodableVector certsVec = new ASN1EncodableVector();
        enumer = signerCerts.getObjects();
        if (enumer.hasMoreElements()) {
            certsVec.add((DEREncodable)enumer.nextElement());
        }
        int i = 0;
        while (i < cert.length) {
            X509CertificateStructure certStruc = cert[i].getCertStructure();
            certsVec.add(certStruc);
            ++i;
        }
        BERSet setCert = new BERSet(certsVec);
        this.signedData.setCertificates(setCert);
        BERSet setCRL = null;
        if (crl != null) {
            ASN1EncodableVector crlsVec = new ASN1EncodableVector();
            enumer = signerCRLs.getObjects();
            if (enumer.hasMoreElements()) {
                crlsVec.add((DEREncodable)enumer.nextElement());
            }
            int i2 = 0;
            while (i2 < crl.length) {
                CertificateList certList = crl[i2].getCertificateList();
                crlsVec.add(certList);
                ++i2;
            }
            setCRL = new BERSet(crlsVec);
        }
        this.signedData.setCrls(setCRL);
        ASN1EncodableVector derV = new ASN1EncodableVector();
        enumer = digestAlgs.getObjects();
        if (enumer.hasMoreElements()) {
            derV.add((DEREncodable)enumer.nextElement());
        }
        derV.add(digestAlgorithm);
        BERSet digestAlgorithms = new BERSet(derV);
        this.signedData.setDigestAlgorithms(digestAlgorithms);
        return Parser.writeDERObj2Bytes(this.signedData);
    }

    public byte[] reSignSignedData(byte[] sourceData, Mechanism digestAlg, JKey privateKey, X509Cert[] cert, X509CRL[] crl) throws PKIException {
        if (cert == null) {
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
        }
        if (this.signedData == null) {
            throw new PKIException("850648", "\u590d\u7b7e\u7b7e\u540d\u65f6\uff0c\u6ca1\u6709\u52a0\u8f7d\u5148\u524d\u7684\u7b7e\u540d\u6570\u636e");
        }
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        ASN1Set signerCerts = this.signedData.getCertificates();
        ASN1Set signerCRLs = this.signedData.getCrls();
        ASN1Set digestAlgs = this.signedData.getDigestAlgorithms();
        BigInteger sn = cert[0].getSerialNumber();
        String issuer = cert[0].getIssuer();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(new X509Name(issuer), sn);
        AlgorithmIdentifier digestAlgorithm = null;
        AlgorithmIdentifier digestEncryptAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull());
        Mechanism signMechansim = null;
        if (privateKey.getKeyType().equals("RSA_Private")) {
            if (digestAlg.getMechanismType().equals("MD2")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md2, new DERNull());
                signMechansim = new Mechanism("MD2withRSAEncryption");
            } else if (digestAlg.getMechanismType().equals("MD5")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, new DERNull());
                signMechansim = new Mechanism("MD5withRSAEncryption");
            } else if (digestAlg.getMechanismType().equals("SHA1")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, new DERNull());
                signMechansim = new Mechanism("SHA1withRSAEncryption");
            }
        } else {
            throw new PKIException("850610", "\u4ea7\u751f\u52a0\u5bc6\u6570\u636e\uff0c\u52a0\u5bc6\u673a\u5236\u4e0d\u652f\u6301");
        }
        byte[] encryptedSignature = this.session.sign(signMechansim, privateKey, sourceData);
        DEROctetString encryptedData = new DEROctetString(encryptedSignature);
        SignerInfo signerInfo = new SignerInfo(new DERInteger(1), issuerAndSn, digestAlgorithm, null, digestEncryptAlg, encryptedData, null);
        ASN1EncodableVector signInfoDerVec = new ASN1EncodableVector();
        Enumeration enumer = signerInfos.getObjects();
        if (enumer.hasMoreElements()) {
            signInfoDerVec.add((DEREncodable)enumer.nextElement());
        }
        signInfoDerVec.add(signerInfo);
        DERSet newSignerInfos = new DERSet(signInfoDerVec);
        this.signedData.setSignerInfos(newSignerInfos);
        ASN1EncodableVector certsVec = new ASN1EncodableVector();
        enumer = signerCerts.getObjects();
        if (enumer.hasMoreElements()) {
            certsVec.add((DEREncodable)enumer.nextElement());
        }
        int i = 0;
        while (i < cert.length) {
            X509CertificateStructure certStruc = cert[i].getCertStructure();
            certsVec.add(certStruc);
            ++i;
        }
        BERSet setCert = new BERSet(certsVec);
        this.signedData.setCertificates(setCert);
        BERSet setCRL = null;
        if (crl != null) {
            ASN1EncodableVector crlsVec = new ASN1EncodableVector();
            enumer = signerCRLs.getObjects();
            if (enumer.hasMoreElements()) {
                crlsVec.add((DEREncodable)enumer.nextElement());
            }
            int i2 = 0;
            while (i2 < crl.length) {
                CertificateList certList = crl[i2].getCertificateList();
                crlsVec.add(certList);
                ++i2;
            }
            setCRL = new BERSet(crlsVec);
        }
        this.signedData.setCrls(setCRL);
        ASN1EncodableVector derV = new ASN1EncodableVector();
        enumer = digestAlgs.getObjects();
        if (enumer.hasMoreElements()) {
            derV.add((DEREncodable)enumer.nextElement());
        }
        derV.add(digestAlgorithm);
        BERSet digestAlgorithms = new BERSet(derV);
        this.signedData.setDigestAlgorithms(digestAlgorithms);
        return Parser.writeDERObj2Bytes(this.signedData);
    }

    public byte[] reSignSignedDataByHash(byte[] hash, Mechanism digestAlg, JKey privateKey, X509Cert[] cert, X509CRL[] crl) throws PKIException {
        if (cert == null) {
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
        }
        if (this.signedData == null) {
            throw new PKIException("850648", "\u590d\u7b7e\u7b7e\u540d\u65f6\uff0c\u6ca1\u6709\u52a0\u8f7d\u5148\u524d\u7684\u7b7e\u540d\u6570\u636e");
        }
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        ASN1Set signerCerts = this.signedData.getCertificates();
        ASN1Set signerCRLs = this.signedData.getCrls();
        ASN1Set digestAlgs = this.signedData.getDigestAlgorithms();
        BigInteger sn = cert[0].getSerialNumber();
        String issuer = cert[0].getIssuer();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(new X509Name(issuer), sn);
        AlgorithmIdentifier digestAlgorithm = null;
        AlgorithmIdentifier digestEncryptAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull());
        if (privateKey.getKeyType().equals("RSA_Private")) {
            if (digestAlg.getMechanismType().equals("MD2")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md2, new DERNull());
            } else if (digestAlg.getMechanismType().equals("MD5")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, new DERNull());
            } else if (digestAlg.getMechanismType().equals("SHA1")) {
                digestAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, new DERNull());
            }
        } else {
            throw new PKIException("850610", "\u4ea7\u751f\u52a0\u5bc6\u6570\u636e\uff0c\u52a0\u5bc6\u673a\u5236\u4e0d\u652f\u6301");
        }
        DigestInfo digestInfo = new DigestInfo(digestAlgorithm, hash);
        byte[] bDigestInfo = Parser.writeDERObj2Bytes(digestInfo);
        byte[] encryptHash = this.session.encrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), privateKey, bDigestInfo);
        DEROctetString encryptedData = new DEROctetString(encryptHash);
        SignerInfo signerInfo = new SignerInfo(new DERInteger(1), issuerAndSn, digestAlgorithm, null, digestEncryptAlg, encryptedData, null);
        ASN1EncodableVector signInfoDerVec = new ASN1EncodableVector();
        Enumeration enumer = signerInfos.getObjects();
        if (enumer.hasMoreElements()) {
            signInfoDerVec.add((DEREncodable)enumer.nextElement());
        }
        signInfoDerVec.add(signerInfo);
        DERSet newSignerInfos = new DERSet(signInfoDerVec);
        this.signedData.setSignerInfos(newSignerInfos);
        ASN1EncodableVector certsVec = new ASN1EncodableVector();
        enumer = signerCerts.getObjects();
        if (enumer.hasMoreElements()) {
            certsVec.add((DEREncodable)enumer.nextElement());
        }
        int i = 0;
        while (i < cert.length) {
            X509CertificateStructure certStruc = cert[i].getCertStructure();
            certsVec.add(certStruc);
            ++i;
        }
        BERSet setCert = new BERSet(certsVec);
        this.signedData.setCertificates(setCert);
        BERSet setCRL = null;
        if (crl != null) {
            ASN1EncodableVector crlsVec = new ASN1EncodableVector();
            enumer = signerCRLs.getObjects();
            if (enumer.hasMoreElements()) {
                crlsVec.add((DEREncodable)enumer.nextElement());
            }
            int i2 = 0;
            while (i2 < crl.length) {
                CertificateList certList = crl[i2].getCertificateList();
                crlsVec.add(certList);
                ++i2;
            }
            setCRL = new BERSet(crlsVec);
        }
        this.signedData.setCrls(setCRL);
        ASN1EncodableVector derV = new ASN1EncodableVector();
        enumer = digestAlgs.getObjects();
        if (enumer.hasMoreElements()) {
            derV.add((DEREncodable)enumer.nextElement());
        }
        derV.add(digestAlgorithm);
        BERSet digestAlgorithms = new BERSet(derV);
        this.signedData.setDigestAlgorithms(digestAlgorithms);
        return Parser.writeDERObj2Bytes(this.signedData);
    }

    public byte[] generateSignedDataContent(byte[] content) throws PKIException {
        SignedData signedData = SignedData.getInstance(Parser.writeBytes2DERObj(content));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, signedData);
        return Parser.writeDERObj2Bytes(contentInfo);
    }

    public void load(byte[] data) throws PKIException {
        boolean isB64 = Parser.isBase64Encode(data);
        ByteArrayInputStream bis = null;
        if (isB64) {
            byte[] tmpData = Parser.convertBase64(data);
            tmpData = Base64.decode(tmpData);
            bis = new ByteArrayInputStream(tmpData);
        }
        bis = new ByteArrayInputStream(data);
        this.load(bis);
    }

    public void loadBase64(byte[] data) throws PKIException {
        byte[] tmpData = Parser.convertBase64(data);
        tmpData = Base64.decode(tmpData);
        ByteArrayInputStream bis = new ByteArrayInputStream(tmpData);
        this.load(bis);
    }

    public void loadDer(byte[] data) throws PKIException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        this.load(bis);
    }

    public void load(SignedData signedData) throws PKIException {
        this.signedData = signedData;
    }

    public void loadDer(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
        this.loadDer(data);
    }

    public void loadBase64(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
        this.loadBase64(data);
    }

    public void load(String fileName) throws PKIException {
        FileInputStream fin = null;
        byte[] data = null;
        try {
            fin = new FileInputStream(fileName);
            data = new byte[fin.available()];
            fin.read(data);
            fin.close();
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
        this.load(data);
    }

    private void load(InputStream ins) throws PKIException {
        ASN1InputStream ais = new ASN1InputStream(ins);
        SignedData sd = null;
        try {
            ASN1Sequence seq = (ASN1Sequence)ais.readObject();
            ContentInfo contentInfo = ContentInfo.getInstance(seq);
            sd = SignedData.getInstance(contentInfo.getContent());
            ins.close();
            ais.close();
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
        this.signedData = sd;
    }

    public byte[] getContent() throws PKIException {
        ContentInfo contentInfo = this.signedData.getContentInfo();
        byte[] sourceData = null;
        if (contentInfo.getContent() == null) {
            return null;
        }
        sourceData = contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo) ? ((ASN1OctetString)contentInfo.getContent()).getOctets() : Parser.writeDERObj2Bytes(contentInfo.getContent().getDERObject());
        return sourceData;
    }

    public X509Cert[] getSignerCerts() throws PKIException {
        ASN1Set certSet = this.signedData.getCertificates();
        X509Cert[] signerCerts = new X509Cert[certSet.size()];
        int i = 0;
        while (i < certSet.size()) {
            X509CertificateStructure certStru = X509CertificateStructure.getInstance(certSet.getObjectAt(i));
            signerCerts[i] = new X509Cert(certStru);
            ++i;
        }
        return signerCerts;
    }

    private boolean verifySignerInfo(byte[] content, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        boolean bResult = false;
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            while (signerEnumer.hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                DERObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getObjectId();
                if (!encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption)) {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                Mechanism signM = null;
                DERObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getObjectId();
                if (digestId.equals(PKCSObjectIdentifiers.md2)) {
                    signM = new Mechanism("MD2withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                    signM = new Mechanism("MD5withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                    signM = new Mechanism("SHA1withRSAEncryption");
                } else {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                JKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                ASN1Set authAttributes = signerInfo.getAuthenticatedAttributes();
                if (authAttributes != null) {
                    byte[] bAuthAttries = Parser.writeDERObj2Bytes(authAttributes);
                    if (!this.session.verifySign(signM, pubKey, bAuthAttries, signature)) {
                        return bResult;
                    }
                    int i = 0;
                    while (i < authAttributes.size()) {
                        DEREncodable derObj;
                        DERSet derSet;
                        DERSequence derSeq = (DERSequence)authAttributes.getObjectAt(i).getDERObject();
                        if (PKCSObjectIdentifiers.pkcs_9_at_messageDigest.toString().equalsIgnoreCase(derSeq.getObjectAt(0).toString())) {
                            derSet = (DERSet)derSeq.getObjectAt(1);
                            derObj = derSet.getObjectAt(0);
                            if (derObj instanceof ASN1OctetString) {
                                byte[] msgDigest = ((ASN1OctetString)derObj).getOctets();
                                Mechanism digMechanism = null;
                                digMechanism = signM.getMechanismType().equals("MD5withRSAEncryption") ? new Mechanism("MD5") : new Mechanism("SHA1");
                                byte[] newMsgDigest = this.session.digest(digMechanism, content);
                                DEROctetString strMsgDigest = new DEROctetString(msgDigest);
                                DEROctetString strNewMsgDigest = new DEROctetString(newMsgDigest);
                                if (strNewMsgDigest.toString().equalsIgnoreCase(strMsgDigest.toString())) {
                                    bResult = true;
                                }
                            }
                        } else if (PKCSObjectIdentifiers.id_ct_MACAddress.toString().equalsIgnoreCase(derSeq.getObjectAt(0).toString()) && (derObj = (derSet = (DERSet)derSeq.getObjectAt(1)).getObjectAt(0)) instanceof ASN1OctetString) {
                            byte[] signMACAdd = ((ASN1OctetString)derObj).getOctets();
                            this.signedMAC = new String(signMACAdd);
                            this.signedMAC = this.signedMAC.indexOf(CFCA_MAC_ID) == -1 ? null : this.signedMAC.substring(9);
                        }
                        ++i;
                    }
                    continue;
                }
                if (!this.session.verifySign(signM, pubKey, content, signature)) {
                    return bResult;
                }
                bResult = true;
            }
            return bResult;
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean verifySignerInfo(InputStream content, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            byte[] signature;
            X509Cert signerCert;
            JKey pubKey;
            Mechanism signM;
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            do {
                if (!signerEnumer.hasMoreElements()) {
                    return true;
                }
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                DERObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getObjectId();
                if (!encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption)) {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                signM = null;
                DERObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getObjectId();
                if (digestId.equals(PKCSObjectIdentifiers.md2)) {
                    signM = new Mechanism("MD2withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                    signM = new Mechanism("MD5withRSAEncryption");
                } else {
                    if (!digestId.equals(PKCSObjectIdentifiers.sha1)) {
                        throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                    }
                    signM = new Mechanism("SHA1withRSAEncryption");
                }
                signature = signerInfo.getEncryptedDigest().getOctets();
            } while (this.session.verifySign(signM, pubKey = signerCert.getPublicKey(), content, signature));
            return false;
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", ex);
        }
    }

    private boolean verifySignerInfoByHash(byte[] hash, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            Enumeration signerEnumer;
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            if ((signerEnumer = signerInfos.getObjects()).hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                DERObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getObjectId();
                if (!encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption)) {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                DERObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getObjectId();
                if (digestId.equals(PKCSObjectIdentifiers.md2) || digestId.equals(PKCSObjectIdentifiers.md5)) {
                    if (hash.length != 16) {
                        throw new PKIException("850652", "\u6587\u6458\u503c\u4e0e\u7b7e\u540d\u6570\u636e\u4e2d\u7684\u7b7e\u540d\u7b97\u6cd5\u4e0d\u5339\u914d");
                    }
                } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                    if (hash.length != 20) {
                        throw new PKIException("850652", "\u6587\u6458\u503c\u4e0e\u7b7e\u540d\u6570\u636e\u4e2d\u7684\u7b7e\u540d\u7b97\u6cd5\u4e0d\u5339\u914d");
                    }
                } else {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                JKey pubKey = signerCert.getPublicKey();
                AlgorithmIdentifier digestAlg = new AlgorithmIdentifier(digestId, new DERNull());
                DigestInfo digestInfo = new DigestInfo(digestAlg, hash);
                byte[] bDigestInfo = Parser.writeDERObj2Bytes(digestInfo);
                byte[] decryptHash = this.session.decrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), pubKey, signature);
                return Arrays.equals(decryptHash, bDigestInfo);
            }
            return true;
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", ex);
        }
    }

    public boolean verifyP7SignedData(X509Cert[] certs) throws PKIException {
        ContentInfo contentInfo = this.signedData.getContentInfo();
        byte[] sourceData = null;
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo)) {
            if (contentInfo.getContent() == null) {
                throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", new Exception("no sourceData to be verify."));
            }
            sourceData = ((ASN1OctetString)contentInfo.getContent()).getOctets();
        } else {
            sourceData = Parser.writeDERObj2Bytes(contentInfo.getContent().getDERObject());
        }
        ASN1Set aset = this.signedData.getSignerInfos();
        return this.verifySignerInfo(sourceData, aset, certs);
    }

    public boolean verifyP7SignedData() throws PKIException {
        ContentInfo contentInfo = this.signedData.getContentInfo();
        byte[] sourceData = null;
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo)) {
            if (contentInfo.getContent() == null) {
                throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", new Exception("no sourceData to be verify."));
            }
            sourceData = ((ASN1OctetString)contentInfo.getContent()).getOctets();
        } else {
            sourceData = Parser.writeDERObj2Bytes(contentInfo.getContent().getDERObject());
        }
        ASN1Set aset = this.signedData.getSignerInfos();
        return this.verifySignerInfo(sourceData, aset, null);
    }

    public boolean verifyP7SignedData(byte[] sourceData, X509Cert[] certs) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        return this.verifySignerInfo(sourceData, aset, certs);
    }

    public boolean verifyP7SignedData(byte[] sourceData) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        return this.verifySignerInfo(sourceData, aset, null);
    }

    public boolean verifyP7SignedDataByHash(byte[] hashData) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        return this.verifySignerInfoByHash(hashData, aset, null);
    }

    public boolean verifyP7SignedDataByHash(byte[] hashData, X509Cert[] certs) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        return this.verifySignerInfoByHash(hashData, aset, certs);
    }

    public boolean verifyP7SignedData(InputStream sourceData, X509Cert[] certs) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        return this.verifySignerInfo(sourceData, aset, certs);
    }

    public boolean verifyP7SignedData(InputStream sourceData) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        return this.verifySignerInfo(sourceData, aset, null);
    }

    private X509Cert getSignerCert(X509Cert[] certs, IssuerAndSerialNumber issuerAndSN) throws PKIException {
        String issuer = issuerAndSN.getName().toString();
        BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
        int i = 0;
        while (i < certs.length) {
            String tmpIssuer = certs[i].getIssuer();
            BigInteger tmpSN = certs[i].getSerialNumber();
            if (tmpIssuer.equals(issuer) && tmpSN.compareTo(sn) == 0) {
                return certs[i];
            }
            ++i;
        }
        return null;
    }

    public static void main(String[] args) {
        JCrypto jcrypto = JCrypto.getInstance();
        try {
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            PKCS7SignedData p7 = new PKCS7SignedData(session);
            Mechanism mechanism1 = new Mechanism("SHA1");
            PKCS12 p12 = new PKCS12();
            p12.load("d:/temp/opcert1234.pfx");
            p12.decrypt("1234".toCharArray());
            byte[] signData = null;
            signData = p7.generateSignedData(false, DATA, "111111".getBytes(), mechanism1, p12.getPrivateKey(), p12.getCerts(), null);
            signData = p7.generateSignedDataContent(signData);
            p7 = new PKCS7SignedData(session);
            p7.loadDer(signData);
            if (p7.verifyP7SignedDataByHash(session.digest(mechanism1, "111111".getBytes()), p12.getCerts())) {
                System.out.println("\u9a8c\u8bc1\u901a\u8fc7");
                System.out.println("\u539f\u6587\uff1a" + new String(p7.getContent(), "UTF-16LE"));
            } else {
                System.out.println("\u9a8c\u8bc1\u672a\u901a\u8fc7");
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public String getSignedMAC() {
        return this.signedMAC;
    }
}

