/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.file;

import com.xwbank.sdk.exception.SDKException;
import com.xwbank.sdk.file.entity.BusinessInfo;
import com.xwbank.sdk.file.entity.FileListInfo;
import com.xwbank.sdk.file.entity.FileListInfoInner;
import com.xwbank.sdk.file.entity.FileSearchInfo;
import com.xwbank.sdk.file.entity.FileUploadInfo;
import com.xwbank.sdk.file.entity.ImageAndIVPlatformInfo;
import com.xwbank.sdk.file.entity.NotifyFileUploadInfo;
import com.xwbank.sdk.file.entity.UploadBase64FileListInfo;
import com.xwbank.sdk.http.HttpClient;
import com.xwbank.sdk.http.HttpFileAuth;
import com.xwbank.sdk.http.entity.CheckFileAuth;
import com.xwbank.sdk.utils.Base64Utils;
import com.xwbank.sdk.utils.FileUtils;
import com.xwbank.sdk.utils.JacksonUtil;
import com.xwbank.sdk.utils.StringUtils;
import com.xwbank.sdk.verify.CheckValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XWBankFile
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(XWBankFile.class);
    private static final XWBankFile ourHopeBankSDK = new XWBankFile();

    public static XWBankFile getInstance() {
        if (checkValue == null) {
            checkValue = new CheckValue();
        }
        return ourHopeBankSDK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> downLoadFile(String localpath, String fileid, String appId) throws SDKException {
        String fileIdString = fileid;
        if (fileIdString.contains(".")) {
            Map<String, Object> map = this.fileSearch(fileIdString, appId);
            if (!map.containsKey("fileId")) return map;
            fileIdString = (String)map.get("fileId");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        logger.debug("\u6b63\u5728\u8fdb\u884c\u8eab\u4efd\u8ba4\u8bc1....");
        CheckFileAuth authinfo = new CheckFileAuth();
        authinfo.setAppId(appId);
        authinfo.setFileid(fileIdString);
        authinfo.setFilemsgflag("102");
        authinfo.setFilename("/openfile/filename");
        Map<String, Object> object = HttpFileAuth.getInstance().checkFileAuth(authinfo);
        logger.debug("\u8eab\u4efd\u8ba4\u8bc1\u5b8c\u6bd5");
        if (!"000000".equals(JacksonUtil.getString(object, "returnCode"))) {
            return object;
        }
        logger.debug("\u8eab\u4efd\u8ba4\u5408\u6cd5");
        String flowid = JacksonUtil.getString(object, "flowid");
        FileOutputStream fos = null;
        String result = null;
        try {
            File file = new File(localpath);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            fos = new FileOutputStream(file);
            String pieceCont = null;
            String pieceMd5 = null;
            String sessId = null;
            int count = 1;
            while (true) {
                logger.debug("\u6b63\u5728\u4e0b\u8f7d\u6587\u4ef6\u5206\u7247(" + count + ")....");
                sessId = count == 1 ? JacksonUtil.getString(object, "sessId") : JacksonUtil.getString(object, "newSessId");
                body.put("sessId", sessId);
                body.put("fileindex", String.valueOf(count));
                body.put("flowid", flowid);
                body.put("appId", appId);
                object = this.sendPost("/fileServer/TransferFile", body, "GM_FILE");
                if (!"000000".equals(JacksonUtil.getString(object, "returnCode")) && !"666666".equals(JacksonUtil.getString(object, "returnCode"))) {
                    Map<String, Object> map = object;
                    return map;
                }
                ++count;
                pieceCont = JacksonUtil.getString(object, "filecont");
                byte[] pieceContByte = Base64Utils.decryptByBASE64(pieceCont);
                pieceMd5 = JacksonUtil.getString(object, "md5");
                if (!StringUtils.checkMd5(pieceMd5, pieceContByte)) {
                    body.clear();
                    body.put("returnCode", "100022");
                    body.put("returnMsg", "\u6587\u4ef6\u83b7\u53d6\u5931\u8d25,\u524d\u540e\u6587\u4ef6\u4e0d\u4e00\u81f4\uff0cMD5\u6821\u9a8c\u5931\u8d25");
                    HashMap<String, Object> hashMap = body;
                    return hashMap;
                }
                FileUtils.saveToFile(pieceContByte, fos);
                if ("true".equalsIgnoreCase(JacksonUtil.getString(object, "islast"))) {
                    body.clear();
                    body.put("returnCode", "000000");
                    body.put("returnMsg", "\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f");
                    HashMap<String, Object> hashMap = body;
                    return hashMap;
                }
                continue;
                break;
            }
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38==", (Throwable)e);
            logger.error("\u5f02\u5e38==" + result);
            body.clear();
            body.put("returnCode", "100033");
            body.put("returnMsg", "\u6587\u4ef6\u83b7\u53d6\u5931\u8d25," + e.getMessage());
            HashMap<String, Object> hashMap = body;
            return hashMap;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error("\u672a\u77e5\u5f02\u5e38==" + e.getMessage());
                }
            }
        }
    }

    private Map<String, Object> fileUpload(FileUploadInfo fileUploadInfo, String url) throws SDKException {
        boolean isPass = checkValue.check(FileUploadInfo.class, fileUploadInfo);
        if (!isPass) {
            logger.debug(JacksonUtil.toJSONString(checkValue.getErrMap()));
            return checkValue.getErrMap();
        }
        if (fileUploadInfo.getFileList() == null || fileUploadInfo.getFileList().size() == 0) {
            checkValue.getErrMap().put("err", "\u8bf7\u9009\u62e9\u6587\u4ef6");
            logger.debug(JacksonUtil.toJSONString(checkValue.getErrMap()));
            return checkValue.getErrMap();
        }
        List list = fileUploadInfo.getFileList();
        ArrayList<FileListInfoInner> innerList = new ArrayList<FileListInfoInner>();
        String code = "";
        for (int i = 0; i < list.size(); ++i) {
            isPass = checkValue.check(FileListInfo.class, list.get(i));
            if (!isPass) {
                logger.debug(JacksonUtil.toJSONString(checkValue.getErrMap()));
                return checkValue.getErrMap();
            }
            String fileName = ((FileListInfo)list.get(i)).getFileName();
            String appId = fileUploadInfo.getAppId();
            Map<String, Object> resultBody = this.uploadFile(((FileListInfo)list.get(i)).getFilePath(), fileName, appId, url);
            code = resultBody.get("returnCode").toString();
            if (!"666666".equals(code)) {
                return resultBody;
            }
            String fileid = resultBody.get("fileid").toString();
            String filename = resultBody.get("filename").toString();
            FileListInfoInner infoInner = new FileListInfoInner();
            infoInner.setFileName(filename);
            infoInner.setFileCode(fileid);
            innerList.add(infoInner);
        }
        fileUploadInfo.setFileList(innerList);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fileInfo", fileUploadInfo);
        map.put("returnCode", "000000");
        map.put("returnMsg", "\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> uploadBase64FileList(UploadBase64FileListInfo uploadBase64FileListInfo) throws SDKException {
        if (uploadBase64FileListInfo.getFiles() == null || uploadBase64FileListInfo.getFiles().size() == 0) {
            checkValue.getErrMap().put("err", "\u8bf7\u9009\u62e9\u6587\u4ef6");
            logger.debug(JacksonUtil.toJSONString(checkValue.getErrMap()));
            return checkValue.getErrMap();
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        ArrayList params = new ArrayList();
        Map<String, InputStream> files = uploadBase64FileListInfo.getFiles();
        Map<String, Object> resultMap = null;
        String result = "";
        InputStream fis = null;
        try {
            for (String fileName : files.keySet()) {
                fis = files.get(fileName);
                byte[] buffer = new byte[fis.available()];
                fis.read(buffer);
                fis.close();
                String fileContent = Base64Utils.encryptByBASE64(buffer);
                HashMap<String, String> cont = new HashMap<String, String>();
                cont.put("fileName", fileName);
                cont.put("fileContent", fileContent);
                params.add(cont);
            }
            String flowId = StringUtils.getRandomString(16);
            body.put("flowId", flowId);
            body.put("appId", uploadBase64FileListInfo.getAppId());
            body.put("fileList", JacksonUtil.toJSONString(params));
            resultMap = this.sendPost("/fileServer/outerFileUpload", body, "GM_FILE_BASE64");
            logger.debug(result);
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38=={}", (Object)result, (Object)e);
            body.clear();
            body.put("returnCode", "100029");
            body.put("returnMsg", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25" + e.getMessage());
            HashMap<String, Object> hashMap = body;
            return hashMap;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error("\u672a\u77e5\u5f02\u5e38==" + e.getCause());
                }
            }
        }
        return resultMap;
    }

    public Map<String, Object> fileUpload(FileUploadInfo fileUploadInfo) throws SDKException {
        return this.fileUpload(fileUploadInfo, "/fileServer/TransferFile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> uploadFile(String filePath, String filename, String appId, String url) throws SDKException {
        Map<String, Object> map;
        HashMap<String, Object> body = new HashMap<String, Object>();
        logger.debug("\u6b63\u5728\u8fdb\u884c\u8eab\u4efd\u8ba4\u8bc1....");
        CheckFileAuth authinfo = new CheckFileAuth();
        authinfo.setAppId(appId);
        authinfo.setFilemsgflag("101");
        authinfo.setFilename("/openfile/" + filename);
        String result = null;
        InputStream stream = null;
        try {
            Map<String, Object> object;
            Object file;
            if (filePath.startsWith("http")) {
                URL url2 = new URL(filePath);
                HttpURLConnection conn = (HttpURLConnection)url2.openConnection();
                conn.setReadTimeout(50000);
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(50000);
                authinfo.setFilecontlen(String.valueOf(conn.getContentLength()));
                if (conn.getResponseCode() != 200) {
                    body.put("returnCode", "100011");
                    body.put("returnMsg", "\u8fdc\u7a0b\u6587\u4ef6\u83b7\u53d6\u5931\u8d25");
                    HashMap<String, Object> hashMap = body;
                    return hashMap;
                }
                stream = conn.getInputStream();
            } else {
                file = new File(filePath);
                authinfo.setFilecontlen(String.valueOf(((File)file).length()));
                stream = new FileInputStream((File)file);
            }
            logger.debug("\u6b63\u5728\u68c0\u67e5\u6587\u4ef6....");
            if (stream == null) {
                body.put("returnCode", "100012");
                body.put("returnMsg", "\u6587\u4ef6\u4e0d\u5b58\u5728");
                file = body;
                return file;
            }
            if ("/fileServer/TransferFileVedio".equals(url)) {
                object = HttpFileAuth.getInstance().checkVedioFileAuth(authinfo);
            } else if ("/fileServer/TransferFilePlus".equals(url)) {
                authinfo.setFilecontlen(null);
                object = HttpFileAuth.getInstance().checkFileAuthPlus(authinfo);
            } else {
                authinfo.setFilecontlen(null);
                object = HttpFileAuth.getInstance().checkFileAuth(authinfo);
            }
            logger.debug("\u8eab\u4efd\u8ba4\u8bc1\u5b8c\u6bd5");
            if (!"000000".equals(JacksonUtil.getString(object, "returnCode"))) {
                file = object;
                return file;
            }
            logger.debug("\u8eab\u4efd\u8ba4\u5408\u6cd5");
            String flowid = JacksonUtil.getString(object, "flowid");
            String sessionId = JacksonUtil.getString(object, "sessId");
            String pieceSize = JacksonUtil.getString(object, "pieceSize");
            int lenth_dns = Integer.valueOf(pieceSize);
            byte[] buffer = new byte[lenth_dns];
            int index = 0;
            int rdLen = 0;
            while (true) {
                byte[] oneBuffer;
                int len;
                if ((len = stream.read(oneBuffer = new byte[lenth_dns - rdLen])) != -1) {
                    System.arraycopy(oneBuffer, 0, buffer, rdLen, len);
                    if ((rdLen += len) < lenth_dns) continue;
                }
                logger.debug("\u5206\u7247\u8bfb\u53d6\u5927\u5c0f(" + rdLen + ")....");
                if (rdLen < lenth_dns) {
                    body.put("islast", "true");
                    logger.debug("\u6587\u4ef6\u6807\u5fd7==true");
                    byte[] sendbuf = new byte[rdLen];
                    System.arraycopy(buffer, 0, sendbuf, 0, rdLen);
                    body.put("filecont", Base64Utils.encryptByBASE64(sendbuf));
                    body.put("md5", StringUtils.getContentMd5(sendbuf));
                } else {
                    body.put("islast", "false");
                    logger.debug("\u6587\u4ef6\u6807\u5fd7==false");
                    body.put("filecont", Base64Utils.encryptByBASE64(buffer));
                    body.put("md5", StringUtils.getContentMd5(buffer));
                }
                body.put("sessId", sessionId);
                body.put("filecontlen", String.valueOf(rdLen));
                body.put("fileindex", String.valueOf(index));
                body.put("flowid", flowid);
                body.put("appId", appId);
                logger.debug("\u6b63\u5728\u4e0a\u4f20\u6587\u4ef6\u5206\u7247(" + index + ")....");
                ++index;
                map = this.sendPost(url, body, "GM_FILE");
                if (!"000000".equals(map.get("returnCode"))) break;
                sessionId = (String)map.get("newSessId");
                rdLen = 0;
                continue;
                break;
            }
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38==", (Throwable)e);
            logger.error("\u5f02\u5e38==" + result);
            body.clear();
            body.put("returnCode", "100029");
            body.put("returnMsg", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25" + e.getMessage());
            HashMap<String, Object> hashMap = body;
            return hashMap;
        }
        if (!"666666".equals(map.get("returnCode"))) {
            return map;
        }
        if (!map.containsKey("newSessId")) return map;
        map.remove("newSessId");
        return map;
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    logger.error("\u672a\u77e5\u5f02\u5e38==" + e.getCause());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> uploadFile(InputStream stream, String filename, String appId) throws SDKException {
        HashMap<String, Object> body = new HashMap<String, Object>();
        logger.debug("\u6b63\u5728\u8fdb\u884c\u8eab\u4efd\u8ba4\u8bc1....");
        Map<String, Object> object = null;
        CheckFileAuth authinfo = new CheckFileAuth();
        authinfo.setAppId(appId);
        authinfo.setFilemsgflag("101");
        authinfo.setFilename("/openfile/" + filename);
        object = HttpFileAuth.getInstance().checkFileAuth(authinfo);
        logger.debug("\u8eab\u4efd\u8ba4\u8bc1\u5b8c\u6bd5");
        if (!"000000".equals(JacksonUtil.getString(object, "returnCode"))) {
            return object;
        }
        logger.debug("\u8eab\u4efd\u8ba4\u5408\u6cd5");
        String flowid = JacksonUtil.getString(object, "flowid");
        String sessionId = JacksonUtil.getString(object, "sessId");
        String pieceSize = JacksonUtil.getString(object, "pieceSize");
        logger.debug("\u6b63\u5728\u68c0\u67e5\u6587\u4ef6....");
        if (stream == null) {
            body.put("returnCode", "100012");
            body.put("returnMsg", "stream is null");
            return body;
        }
        String result = null;
        try {
            int lenth_dns = Integer.valueOf(pieceSize);
            byte[] buffer = new byte[lenth_dns];
            int index = 0;
            int rdLen = 0;
            while (true) {
                byte[] oneBuffer;
                int len;
                if ((len = stream.read(oneBuffer = new byte[lenth_dns - rdLen])) != -1) {
                    System.arraycopy(oneBuffer, 0, buffer, rdLen, len);
                    if ((rdLen += len) < lenth_dns) continue;
                }
                logger.debug("\u5206\u7247\u8bfb\u53d6\u5927\u5c0f(" + rdLen + ")....");
                if (rdLen < lenth_dns) {
                    body.put("islast", "true");
                    logger.debug("\u6587\u4ef6\u6807\u5fd7==true");
                    byte[] sendbuf = new byte[rdLen];
                    System.arraycopy(buffer, 0, sendbuf, 0, rdLen);
                    body.put("filecont", Base64Utils.encryptByBASE64(sendbuf));
                    body.put("md5", StringUtils.getContentMd5(sendbuf));
                } else {
                    body.put("islast", "false");
                    logger.debug("\u6587\u4ef6\u6807\u5fd7==false");
                    body.put("filecont", Base64Utils.encryptByBASE64(buffer));
                    body.put("md5", StringUtils.getContentMd5(buffer));
                }
                body.put("sessId", sessionId);
                body.put("filecontlen", String.valueOf(rdLen));
                body.put("fileindex", String.valueOf(index));
                body.put("flowid", flowid);
                body.put("appId", appId);
                logger.debug("\u6b63\u5728\u4e0a\u4f20\u6587\u4ef6\u5206\u7247(" + index + ")....");
                ++index;
                object = this.sendPost("/fileServer/TransferFile", body, "GM_FILE");
                if (!"000000".equals(JacksonUtil.getString(object, "returnCode"))) break;
                sessionId = JacksonUtil.getString(object, "newSessId");
                rdLen = 0;
                continue;
                break;
            }
        }
        catch (Exception e) {
            logger.error("\u5f02\u5e38==", (Throwable)e);
            logger.error("\u5f02\u5e38==" + result);
            body.clear();
            body.put("returnCode", "100029");
            body.put("returnMsg", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25" + e.getMessage());
            logger.debug(JacksonUtil.toJSONString(body));
            HashMap<String, Object> hashMap = body;
            return hashMap;
        }
        if (!"666666".equals(JacksonUtil.getString(object, "returnCode"))) {
            body.clear();
            body.put("returnCode", "100029");
            body.put("returnMsg", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
            logger.debug(JacksonUtil.toJSONString(body));
            return body;
        }
        if (object.containsKey("newSessId")) {
            object.remove("newSessId");
        }
        object.put("returnCode", "000000");
        return object;
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.error("\u672a\u77e5\u5f02\u5e38==", (Throwable)e);
            }
        }
    }

    public Map<String, Object> fileSearch(String fileName, String appId) throws SDKException {
        FileSearchInfo info = new FileSearchInfo();
        info.setFileName(fileName);
        info.setAppId(appId);
        return this.sendPost("/fileServer/SearchAndDown", info, "GM_FILE");
    }

    public Map<String, Object> transferFileVedio(FileUploadInfo fileUploadInfo) throws SDKException {
        return this.fileUpload(fileUploadInfo, "/fileServer/TransferFileVedio");
    }

    public Map<String, Object> getImageAndIVPlatform(ImageAndIVPlatformInfo info) throws SDKException {
        boolean isPass = checkValue.check(ImageAndIVPlatformInfo.class, info);
        if (!isPass) {
            logger.debug(JacksonUtil.toJSONString(checkValue.getErrMap()));
            return checkValue.getErrMap();
        }
        BusinessInfo businessInfo = JacksonUtil.toJavaObject(info, BusinessInfo.class);
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("flowId", StringUtils.getRandomString(16));
        body.put("businessMap", JacksonUtil.toJSONString(businessInfo));
        body.put("isIVPlatform", info.getIsIVPlatform());
        body.put("appId", info.getAppId());
        body.put("partnerId", info.getPartnerId());
        body.put("url", info.getUrl());
        body.put("fileName", info.getFileName());
        return this.sendPost("/fileServer/getImageAndIVPlatform", body, "GM_FILE");
    }

    public Map<String, Object> fileUploadPlus(FileUploadInfo fileUploadInfo) throws SDKException {
        return this.fileUpload(fileUploadInfo, "/fileServer/TransferFilePlus");
    }

    public Map<String, Object> NotifyFileUpload(NotifyFileUploadInfo info) throws SDKException {
        boolean isPass = checkValue.check(NotifyFileUploadInfo.class, info);
        if (!isPass) {
            logger.debug(JacksonUtil.toJSONString(checkValue.getErrMap()));
            return checkValue.getErrMap();
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("flowId", StringUtils.getRandomString(16));
        body.put("appId", info.getAppId());
        body.put("fileId", info.getFileId());
        body.put("fileName", info.getFileName());
        return this.sendPost("/fileServer/NotifyFileUpload", body, "GM_FILE");
    }

    public Map<String, Object> uploadFileToS3FilePath(FileUploadInfo fileUploadInfo) throws SDKException {
        return this.fileUpload(fileUploadInfo, "/fileServer/UploadFileToS3FilePath");
    }
}

