/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.http;

import com.xwbank.sdk.config.ApplicationConfig;
import com.xwbank.sdk.enums.ChannelStrategyEnum;
import com.xwbank.sdk.enums.RequestStrategyEnum;
import com.xwbank.sdk.exception.SDKException;
import com.xwbank.sdk.http.HttpClient;
import com.xwbank.sdk.http.entity.HttpRequestEntity;
import com.xwbank.sdk.http.entity.HttpRespEntity;
import com.xwbank.sdk.http.entity.InitParam;
import com.xwbank.sdk.manager.ConfigManager;
import com.xwbank.sdk.manager.HttpClientManager;
import com.xwbank.sdk.strategy.ChannelStrategy;
import com.xwbank.sdk.strategy.RequestStrategy;
import com.xwbank.sdk.utils.HttpClientUtil;
import com.xwbank.sdk.utils.JacksonUtil;
import com.xwbank.sdk.utils.StringUtils;
import com.xwbank.sdk.verify.CheckValue;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotNull;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseHttp {
    private static final Logger logger = LoggerFactory.getLogger(BaseHttp.class);
    public static volatile Boolean isInit = false;
    protected static CheckValue checkValue;
    protected final ConfigManager configManager = ConfigManager.getInstance();
    protected final HttpClientManager httpClientManager = HttpClientManager.getInstance();
    protected final Map<String, ChannelStrategy> channelStrategyMap = new ConcurrentHashMap<String, ChannelStrategy>();

    public boolean isInit(String appId) {
        return isInit != false && this.configManager.getConfig(appId) != null;
    }

    public void setAccessToken(String appId, String idToken) {
        this.configManager.getConfig(appId).setIdToken(idToken);
    }

    public ChannelStrategy getChannelStrategy(String channelType) {
        if (!this.channelStrategyMap.containsKey(channelType)) {
            this.channelStrategyMap.put(channelType, ChannelStrategyEnum.getChannelStrategy(channelType));
        }
        return this.channelStrategyMap.get(channelType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean init(@NotNull InitParam param) {
        if (isInit.booleanValue()) return isInit;
        Class<HttpClient> clazz = HttpClient.class;
        synchronized (HttpClient.class) {
            if (isInit.booleanValue()) return isInit;
            try {
                this.configManager.init(param);
                for (Map.Entry<String, ApplicationConfig> entry : this.configManager.getConfigMap().entrySet()) {
                    this.httpClientManager.init(entry.getValue());
                }
                isInit = true;
                logger.info("SDK\u914d\u7f6e\u521d\u59cb\u5316\u6210\u529f");
            }
            catch (Exception e) {
                logger.error("\u521d\u59cb\u5316\u5f02\u5e38\uff1a", (Throwable)e);
            }
            return isInit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean init(@NotNull List<InitParam> params) {
        if (isInit.booleanValue()) return isInit;
        Class<HttpClient> clazz = HttpClient.class;
        synchronized (HttpClient.class) {
            if (isInit.booleanValue()) return isInit;
            try {
                this.configManager.init(params);
                for (Map.Entry<String, ApplicationConfig> entry : this.configManager.getConfigMap().entrySet()) {
                    this.httpClientManager.init(entry.getValue());
                }
                isInit = true;
                logger.info("SDK\u914d\u7f6e\u521d\u59cb\u5316\u6210\u529f");
            }
            catch (Exception e) {
                logger.error("\u521d\u59cb\u5316\u5f02\u5e38\uff1a", (Throwable)e);
            }
            return isInit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean initStream(@NotNull InitParam param) {
        if (isInit.booleanValue()) return isInit;
        Class<HttpClient> clazz = HttpClient.class;
        synchronized (HttpClient.class) {
            if (isInit.booleanValue()) return isInit;
            try {
                this.configManager.initStream(param);
                for (Map.Entry<String, ApplicationConfig> entry : this.configManager.getConfigMap().entrySet()) {
                    this.httpClientManager.init(entry.getValue());
                }
                isInit = true;
                logger.info("SDK\u914d\u7f6e\u521d\u59cb\u5316\u6210\u529f");
            }
            catch (Exception e) {
                logger.error("\u521d\u59cb\u5316\u5f02\u5e38\uff1a", (Throwable)e);
            }
            return isInit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean initStream(@NotNull List<InitParam> params) {
        if (isInit.booleanValue()) return isInit;
        Class<HttpClient> clazz = HttpClient.class;
        synchronized (HttpClient.class) {
            if (isInit.booleanValue()) return isInit;
            try {
                this.configManager.initStream(params);
                for (Map.Entry<String, ApplicationConfig> entry : this.configManager.getConfigMap().entrySet()) {
                    this.httpClientManager.init(entry.getValue());
                }
                isInit = true;
                logger.info("SDK\u914d\u7f6e\u521d\u59cb\u5316\u6210\u529f");
            }
            catch (Exception e) {
                logger.error("\u521d\u59cb\u5316\u5f02\u5e38\uff1a", (Throwable)e);
            }
            return isInit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRespEntity send(HttpRequestEntity entity) {
        HttpRespEntity respEntity = new HttpRespEntity();
        CloseableHttpResponse response = null;
        try {
            RequestStrategy requestStrategy = RequestStrategyEnum.getRequestStrategy(entity.getRequestType());
            if (requestStrategy == null) {
                throw new SDKException("\u8bf7\u6c42\u7c7b\u578b\u4e0d\u5b58\u5728:" + entity.getRequestType());
            }
            response = requestStrategy.send(this.httpClientManager.getConnection(entity.getAppId()), entity, this.httpClientManager.getHttpClientConfig());
            if (response == null) {
                throw new SDKException("\u8bf7\u6c42\u5f02\u5e38");
            }
            this.handleRespMsg(respEntity, response);
        }
        catch (Exception e) {
            try {
                logger.error("\u8bf7\u6c42\u5f02\u5e38\uff1a", (Throwable)e);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("returnCode", "100034");
                map.put("returnMsg", "\u8bf7\u6c42\u5f02\u5e38: " + e.getMessage());
                respEntity.setStatusCode(-1);
                respEntity.setRespMsg(JacksonUtil.toJSONString(map));
            }
            catch (Throwable throwable) {
                HttpClientUtil.close(response);
                throw throwable;
            }
            HttpClientUtil.close(response);
        }
        HttpClientUtil.close(response);
        return respEntity;
    }

    public void handleRespMsg(HttpRespEntity respEntity, CloseableHttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        Map<String, String> respHeadMap = HttpClientUtil.getAllHeaders((HttpResponse)response);
        respEntity.setStatusCode(statusCode);
        respEntity.setHeaderMap(respHeadMap);
        if (statusCode != 200) {
            logger.error("\u8bf7\u6c42\u5f02\u5e38, \u54cd\u5e94\u7801\uff1a{}\uff0c\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)statusCode, (Object)HttpClientUtil.entityToString((HttpResponse)response));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("returnCode", "100034");
            map.put("returnMsg", "\u8bf7\u6c42\u5f02\u5e38\uff0c\u8bf7\u6c42\u72b6\u6001\u7801\uff1a" + statusCode);
            respEntity.setRespMsg(JacksonUtil.toJSONString(map));
        } else {
            respEntity.setRespMsg(HttpClientUtil.entityToString((HttpResponse)response));
        }
    }

    public Map<String, Object> send(String appId, String url, Object obj, String channelType, String requestType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Map<String, Object> params = JacksonUtil.toMap(obj);
        if (StringUtils.isEmpty(appId)) {
            resultMap.put("returnCode", "100036");
            resultMap.put("returnMsg", "appId\u4e0d\u80fd\u4e3a\u7a7a");
            return resultMap;
        }
        if (!this.isInit(appId)) {
            resultMap.put("returnCode", "100031");
            resultMap.put("returnMsg", "sdk\u672a\u521d\u59cb\u5316\u6216\u8005\u6ca1\u6709\u521d\u59cb\u5316\u6210\u529f");
            return resultMap;
        }
        ApplicationConfig config = this.configManager.getConfig(appId);
        ChannelStrategy channelStrategy = this.getChannelStrategy(channelType);
        Map<String, String> headerMap = null;
        if (channelStrategy != null) {
            headerMap = channelStrategy.getHeaders(appId, config.getIdToken());
            try {
                params = channelStrategy.doRequest(params, config);
            }
            catch (SDKException e) {
                logger.error("\u8bf7\u6c42\u62a5\u6587\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
                resultMap.put("returnCode", "100034");
                resultMap.put("returnMsg", "\u8bf7\u6c42\u62a5\u6587\u5904\u7406\u5f02\u5e38");
                return resultMap;
            }
        }
        HttpRequestEntity entity = this.convertRequestEntity(appId, headerMap, params, requestType, config.getPublicUrl() + url);
        logger.info("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JacksonUtil.toJSONString(entity));
        HttpRespEntity respEntity = this.send(entity);
        logger.info("\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)JacksonUtil.toJSONString(respEntity));
        if (respEntity.getStatusCode() == 200 && channelStrategy != null) {
            return this.returnResp(respEntity, channelStrategy, config);
        }
        return JacksonUtil.toMap(respEntity.getRespMsg());
    }

    public HttpRequestEntity convertRequestEntity(String appId, Map<String, String> headerMap, Map<String, Object> params, String requestType, String url) {
        HttpRequestEntity entity = new HttpRequestEntity();
        entity.setAppId(appId);
        entity.setHeaders(headerMap);
        entity.setRequestType(requestType);
        entity.setFile("FORM_FILE".equalsIgnoreCase(requestType) ? (File)params.get("file") : null);
        entity.setParams(JacksonUtil.toJSONString(params));
        entity.setUrl(url);
        return entity;
    }

    public Map<String, Object> returnResp(HttpRespEntity respEntity, ChannelStrategy channelStrategy, ApplicationConfig config) {
        Map<Object, Object> resultMap = new HashMap();
        Map<String, Object> respMap = JacksonUtil.toMap(respEntity.getRespMsg());
        if (respMap != null && respMap.containsKey("sign")) {
            try {
                resultMap = channelStrategy.doResponse(respMap, config);
                logger.info("\u89e3\u6790\u540e\u7684\u62a5\u6587\uff1a{}", (Object)JacksonUtil.toJSONString(resultMap));
                return resultMap;
            }
            catch (SDKException e) {
                logger.error("\u54cd\u5e94\u62a5\u6587\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
                resultMap.put("returnCode", "100035");
                resultMap.put("returnMsg", "\u54cd\u5e94\u62a5\u6587\u5904\u7406\u5f02\u5e38");
                return resultMap;
            }
        }
        if (!this.verifyResp(respMap)) {
            respMap = new HashMap<String, Object>(2);
            respMap.put("returnMsg", "verify error");
            respMap.put("returnCode", "110110");
            return respMap;
        }
        return respMap;
    }

    public boolean verifyResp(Map<String, Object> respMap) {
        if (respMap == null) {
            return false;
        }
        return respMap.containsKey("sign") || respMap.containsKey("returnCode");
    }

    public Map<String, Object> noticeEn(String appId, Map<String, Object> paramMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!this.isInit(appId)) {
            resultMap.put("returnCode", "100031");
            resultMap.put("returnMsg", "sdk\u672a\u521d\u59cb\u5316\u6216\u8005\u6ca1\u6709\u521d\u59cb\u5316\u6210\u529f");
            return resultMap;
        }
        ApplicationConfig config = this.configManager.getConfig(appId);
        ChannelStrategy channelStrategy = this.getChannelStrategy("GM_NOTICE");
        try {
            return channelStrategy.doResponse(paramMap, config);
        }
        catch (SDKException e) {
            logger.error("\u901a\u77e5\u62a5\u6587\u52a0\u5bc6\u52a0\u7b7e\u5f02\u5e38", (Throwable)e);
            resultMap.put("returnCode", "100035");
            resultMap.put("returnMsg", "\u62a5\u6587\u52a0\u5bc6\u52a0\u7b7e\u5f02\u5e38");
            return resultMap;
        }
    }

    public Map<String, Object> noticeDe(String appId, Map<String, Object> paramMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!this.isInit(appId)) {
            resultMap.put("returnCode", "100031");
            resultMap.put("returnMsg", "sdk\u672a\u521d\u59cb\u5316\u6216\u8005\u6ca1\u6709\u521d\u59cb\u5316\u6210\u529f");
            return resultMap;
        }
        ApplicationConfig config = this.configManager.getConfig(appId);
        ChannelStrategy channelStrategy = this.getChannelStrategy("GM_NOTICE");
        try {
            return channelStrategy.doRequest(paramMap, config);
        }
        catch (SDKException e) {
            logger.error("\u901a\u77e5\u62a5\u6587\u9a8c\u7b7e\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
            resultMap.put("returnCode", "100035");
            resultMap.put("returnMsg", "\u62a5\u6587\u9a8c\u7b7e\u89e3\u5bc6\u5f02\u5e38");
            return resultMap;
        }
    }
}

