/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.manager;

import com.xwbank.sdk.config.ApplicationConfig;
import com.xwbank.sdk.config.HttpClientConfig;
import com.xwbank.sdk.utils.HttpClientUtil;
import com.xwbank.sdk.utils.ResourceBundleFileUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientManager {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientManager.class);
    private static HttpClientManager httpClientManager = null;
    private HttpClientConfig httpClientConfig = null;
    private static ScheduledExecutorService executorService = null;
    private final Map<String, CloseableHttpClient> connectionMap = new ConcurrentHashMap<String, CloseableHttpClient>();
    private String protocolName = "protocol";

    private HttpClientManager() {
        this.readConfig();
        this.idleConnectionPooling();
    }

    private void idleConnectionPooling() {
        executorService = new ScheduledThreadPoolExecutor(1);
        executorService.scheduleAtFixedRate(() -> HttpClientUtil.getPoolingManagers().forEach(poolingManager -> {
            poolingManager.closeExpiredConnections();
            poolingManager.closeIdleConnections((long)this.httpClientConfig.getPoolingManagerIdleConnections(), TimeUnit.MILLISECONDS);
        }), this.httpClientConfig.getInitialDelay(), this.httpClientConfig.getPeriod(), TimeUnit.MILLISECONDS);
    }

    public CloseableHttpClient getConnection(String appId) {
        return this.connectionMap.get(appId);
    }

    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public void setProtocolName(String protocolName) {
        this.protocolName = protocolName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpClientManager getInstance() {
        if (httpClientManager != null) return httpClientManager;
        Class<HttpClientManager> clazz = HttpClientManager.class;
        synchronized (HttpClientManager.class) {
            if (httpClientManager != null) return httpClientManager;
            httpClientManager = new HttpClientManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpClientManager;
        }
    }

    public void init(@NotNull ApplicationConfig config) throws Exception {
        if (!this.connectionMap.containsKey(config.getAppId())) {
            CloseableHttpClient client = HttpClientUtil.doHttpClient(this.httpClientConfig, config);
            this.connectionMap.put(config.getAppId(), client);
        }
    }

    private void readConfig() {
        ResourceBundleFileUtil resourceBundle = ResourceBundleFileUtil.getInstance(this.protocolName);
        this.httpClientConfig = new HttpClientConfig();
        this.httpClientConfig.setMaxTotal(resourceBundle.getInt("http.client.max.total"));
        this.httpClientConfig.setMaxPreRoute(resourceBundle.getInt("http.client.max.per.route"));
        this.httpClientConfig.setConnectionRequestTimeout(resourceBundle.getInt("http.client.connection.request.timeout"));
        this.httpClientConfig.setConnectionTimeout(resourceBundle.getInt("http.client.connection.timeout"));
        this.httpClientConfig.setSocketTimeout(resourceBundle.getInt("http.client.socket.timeout"));
        this.httpClientConfig.setConnectionKeepAlive(resourceBundle.getInt("http.client.connection.keep.alive"));
        this.httpClientConfig.setInitialDelay(resourceBundle.getInt("thread.initial.delay"));
        this.httpClientConfig.setPeriod(resourceBundle.getInt("thread.period"));
        this.httpClientConfig.setPoolingManagerIdleConnections(resourceBundle.getInt("http.client.pooling.manager.idle.connections"));
        this.httpClientConfig.setRequestMaxCount(resourceBundle.getInt("http.client.request.max.count"));
    }

    public void shutdown() {
        HttpClientUtil.poolingShutdown();
        executorService.shutdown();
    }
}

