/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.utils;

import com.xwbank.sdk.exception.SDKException;
import com.xwbank.sdk.utils.Base64Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    public static Logger log = LoggerFactory.getLogger(FileUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTxtFile(String filePath) {
        String AllTxt = null;
        InputStreamReader read = null;
        BufferedReader bufferedReader = null;
        try {
            String encoding = "GBK";
            File file = new File(filePath);
            if (file.isFile() && file.exists()) {
                read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
                bufferedReader = new BufferedReader(read);
                String lineTxt = "";
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    AllTxt = AllTxt + lineTxt;
                }
            } else {
                log.error("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6587\u4ef6");
            }
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519", (Throwable)e);
        }
        finally {
            try {
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
                if (null != read) {
                    read.close();
                }
            }
            catch (IOException e) {
                log.error("\u6587\u4ef6\u8f93\u5165\u6d41\u5173\u95ed\u5931\u8d25", (Throwable)e);
            }
        }
        return AllTxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String PDFToBase64(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return "";
        }
        FileInputStream fin = null;
        BufferedInputStream bin = null;
        ByteArrayOutputStream baos = null;
        FilterOutputStream bout = null;
        try {
            fin = new FileInputStream(file);
            bin = new BufferedInputStream(fin);
            baos = new ByteArrayOutputStream();
            bout = new BufferedOutputStream(baos);
            byte[] buffer = new byte[1024];
            int len = bin.read(buffer);
            while (len != -1) {
                ((BufferedOutputStream)bout).write(buffer, 0, len);
                len = bin.read(buffer);
            }
            ((BufferedOutputStream)bout).flush();
            byte[] bytes = baos.toByteArray();
            String string = Base64Utils.encryptByBASE64(bytes);
            return string;
        }
        catch (FileNotFoundException e) {
            log.error("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6587\u4ef6==", (Throwable)e);
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u8bfb\u5199\u9519\u8bef==", (Throwable)e);
        }
        finally {
            try {
                if (null != bout) {
                    bout.close();
                }
            }
            catch (IOException e) {
                log.error("\u8f93\u5165\u8f93\u51fa\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
            try {
                if (null != baos) {
                    baos.close();
                }
            }
            catch (IOException e) {
                log.error("\u8f93\u5165\u8f93\u51fa\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
            try {
                if (null != bin) {
                    bin.close();
                }
            }
            catch (IOException e) {
                log.error("\u8f93\u5165\u8f93\u51fa\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
            try {
                if (null != fin) {
                    fin.close();
                }
            }
            catch (IOException e) {
                log.error("\u8f93\u5165\u8f93\u51fa\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
        }
        return null;
    }

    public static void saveFile(String path, String data, String date) throws SDKException {
        File filexFile = new File(path);
        if (!filexFile.exists()) {
            filexFile.mkdirs();
        }
        String fileName = date.replace("-", "") + "Statement.zip";
        FileOutputStream fop = null;
        ByteArrayInputStream inputStream = null;
        try {
            int len;
            File file = new File(path + File.separator + fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            fop = new FileOutputStream(file);
            inputStream = new ByteArrayInputStream(Base64Utils.decryptByBASE64(data));
            byte[] bs = new byte[1024];
            while ((len = inputStream.read(bs)) != -1) {
                fop.write(bs, 0, len);
            }
            fop.flush();
        }
        catch (IOException e) {
            throw new SDKException("\u6587\u4ef6\u5b58\u50a8\u5931\u8d25", e);
        }
        catch (Exception e) {
            throw new SDKException("\u672a\u77e5\u5f02\u5e38", e);
        }
        finally {
            try {
                fop.close();
            }
            catch (IOException e) {
                log.warn("\u6d41\u5173\u95ed\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
    }

    public static void saveToFile(byte[] src, FileOutputStream fos) {
        try {
            fos.write(src);
        }
        catch (IOException e) {
            log.warn("\u6587\u4ef6\u5199\u5165\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

