/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.xwbank.sdk.utils.StringUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtil {
    private static final Logger logger = LoggerFactory.getLogger(JacksonUtil.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String toJSONString(Object obj) {
        return obj != null ? JacksonUtil.toJSONString(obj, false, false) : "";
    }

    public static String toJSONString(Object obj, boolean sortField) {
        return obj != null ? JacksonUtil.toJSONString(obj, false, false) : "";
    }

    public static String toFormatJSONString(Object obj) {
        return obj != null ? JacksonUtil.toJSONString(obj, true, false) : "";
    }

    public static String toJSONString(Object obj, boolean format, boolean sortField) {
        try {
            if (obj == null) {
                return "";
            }
            if (obj instanceof String) {
                return obj.toString();
            }
            if (obj instanceof Number) {
                return obj.toString();
            }
            JacksonUtil.setSortField(sortField);
            if (format) {
                return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
            }
            return MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            logger.error(String.format("toJSONString %s", obj.toString()), (Throwable)e);
            return "";
        }
    }

    private static void setSortField(boolean sortField) {
        MAPPER.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, sortField);
    }

    public static <T> T toJavaObject(String value, Class<T> tClass) {
        try {
            if (StringUtils.isEmpty(value)) {
                return null;
            }
            return (T)MAPPER.readValue(value, tClass);
        }
        catch (Throwable e) {
            logger.error(String.format("toJavaObject exception: \n %s\n %s", value, tClass), e);
            return null;
        }
    }

    public static <T> T toJavaObject(String value, JavaType javaType) {
        try {
            if (StringUtils.isEmpty(value)) {
                return null;
            }
            return (T)MAPPER.readValue(value, javaType);
        }
        catch (Throwable e) {
            logger.error(String.format("toJavaObject exception: \n %s\n %s", value, javaType), e);
            return null;
        }
    }

    public static <T> T toJavaObject(Object obj, Class<T> tClass) {
        return obj != null ? (T)JacksonUtil.toJavaObject(JacksonUtil.toJSONString(obj), tClass) : null;
    }

    public static <T> List<T> toJavaObjectList(String value, Class<T> tClass) {
        try {
            if (StringUtils.isEmpty(value)) {
                return null;
            }
            JavaType javaType = MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{tClass});
            return (List)MAPPER.readValue(value, javaType);
        }
        catch (Throwable e) {
            logger.error(String.format("toJavaObjectList exception \n%s\n%s", value, tClass), e);
            return null;
        }
    }

    public static <T> List<T> toJavaObjectList(Object obj, Class<T> tClass) {
        return obj != null ? JacksonUtil.toJavaObjectList(JacksonUtil.toJSONString(obj), tClass) : null;
    }

    public static <T> T jsonCopy(Object obj, Class<T> tClass) {
        return obj != null ? (T)JacksonUtil.toJavaObject(JacksonUtil.toJSONString(obj), tClass) : null;
    }

    public static Map<String, Object> toMap(Object value) {
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof Map) {
                return (Map)value;
            }
        }
        catch (Exception e) {
            logger.info("fail to convert" + JacksonUtil.toJSONString(value), (Throwable)e);
        }
        return JacksonUtil.toMap(JacksonUtil.toJSONString(value));
    }

    public static Map<String, Object> toMap(String value) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        try {
            return JacksonUtil.toJavaObject(value, LinkedHashMap.class);
        }
        catch (Exception e) {
            logger.error(String.format("toMap exception\n%s", value), (Throwable)e);
            return null;
        }
    }

    public static <T1, T2> Map<T1, T2> toMap(String value, Class<T1> cls1, Class<T2> cls2) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        TypeFactory factory = TypeFactory.defaultInstance();
        MapType mapType = factory.constructMapType(LinkedHashMap.class, cls1, cls2);
        try {
            return (Map)JacksonUtil.toJavaObject(value, (JavaType)mapType);
        }
        catch (Exception e) {
            logger.error(String.format("toMap exception \n%s\n%s\n%s", value, cls1, cls2), (Throwable)e);
            return null;
        }
    }

    public static List<Object> toList(String value) {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        try {
            return JacksonUtil.toJavaObject(value, List.class);
        }
        catch (Exception e) {
            logger.error("toList exception\n" + value, (Throwable)e);
            return null;
        }
    }

    public static List<Object> toList(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (List)value;
        }
        return JacksonUtil.toList(JacksonUtil.toJSONString(value));
    }

    public static long getLong(Map<String, Object> map, String key) {
        if (map == null || map.isEmpty()) {
            return 0L;
        }
        String valueStr = String.valueOf(map.get(key));
        if (StringUtils.isEmpty(valueStr) || !StringUtils.isNumeric(valueStr)) {
            return 0L;
        }
        return Long.parseLong(valueStr);
    }

    public static int getInt(Map<String, Object> map, String key) {
        if (map == null || map.isEmpty()) {
            return 0;
        }
        String valueStr = String.valueOf(map.get(key));
        if (StringUtils.isEmpty(valueStr) || !StringUtils.isNumeric(valueStr)) {
            return 0;
        }
        return Integer.parseInt(valueStr);
    }

    public static String getString(Map<String, Object> map, String key) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        return String.valueOf(map.get(key));
    }

    static {
        ObjectMapper configure = MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        MAPPER.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }
}

