/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.utils.sm;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.EncryptUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;

public class SM2Util {
    private static final Mechanism MECHANISM = new Mechanism("SM2");
    private static Session session = null;
    private static final Signature SIGNATURE = new Signature();

    public static String encrypt(PublicKey publicKey, String body) throws Exception {
        byte[] keyByte = EncryptUtil.encrypt((Mechanism)MECHANISM, (Key)publicKey, (byte[])body.getBytes(StandardCharsets.UTF_8), (Session)session);
        return new String(keyByte);
    }

    public static String encrypt(String publicKeyStr, String body) throws Exception {
        X509Cert cert = new X509Cert(publicKeyStr.getBytes(StandardCharsets.UTF_8));
        return SM2Util.encrypt(cert.getPublicKey(), body);
    }

    public static byte[] decrypt(PrivateKey privateKey, byte[] bytes) throws Exception {
        return EncryptUtil.decrypt((Mechanism)MECHANISM, (Key)privateKey, (byte[])bytes, (Session)session);
    }

    public static String sign(PrivateKey privateKey, String body) throws Exception {
        byte[] base64P1SignedData = SIGNATURE.p1SignMessage("sm3WithSM2Encryption", body.getBytes(StandardCharsets.UTF_8), privateKey, session);
        return new String(base64P1SignedData);
    }

    public static String sign(String privateKeyStr, String pwd, String body) throws Exception {
        SM2PrivateKey privateKey = KeyUtil.getPrivateKeyFromSM2((byte[])privateKeyStr.getBytes(StandardCharsets.UTF_8), (String)pwd);
        return SM2Util.sign((PrivateKey)privateKey, body);
    }

    public static boolean verifySign(PublicKey publicKey, String body, String sign) throws Exception {
        return SIGNATURE.p1VerifyMessage("sm3WithSM2Encryption", body.getBytes(StandardCharsets.UTF_8), sign.getBytes(StandardCharsets.UTF_8), publicKey, session);
    }

    public static boolean verifySign(String publicKeyStr, String body, String sign) throws Exception {
        X509Cert cert = new X509Cert(publicKeyStr.getBytes());
        return SM2Util.verifySign(cert.getPublicKey(), body, sign);
    }

    static {
        String deviceName = "JSOFT_LIB";
        try {
            JCrypto.getInstance().initialize("JSOFT_LIB", null);
            session = JCrypto.getInstance().openSession("JSOFT_LIB");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

