/*
 * Decompiled with CFR 0.152.
 */
package com.xwbank.sdk.utils.sm;

import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.util.Base64;
import cfca.sadk.util.EncryptUtil;
import com.xwbank.sdk.utils.sm.TextHexKit;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SM4Util {
    public static String encrypt(byte[] bytes, String body) throws Exception {
        List<byte[]> keyBytes = SM4Util.splitKey(bytes);
        byte[] base64Bytes = EncryptUtil.encryptMessageBySM4((byte[])body.getBytes(StandardCharsets.UTF_8), (byte[])keyBytes.get(0), (byte[])keyBytes.get(1));
        return new String(base64Bytes, StandardCharsets.UTF_8);
    }

    public static String decrypt(byte[] bytes, String body) throws Exception {
        List<byte[]> keyBytes = SM4Util.splitKey(bytes);
        byte[] decryptTextBytes = EncryptUtil.decryptMessageBySM4((byte[])body.getBytes(), (byte[])keyBytes.get(0), (byte[])keyBytes.get(1));
        return new String(Base64.decode((byte[])decryptTextBytes), StandardCharsets.UTF_8);
    }

    public static List<byte[]> splitKey(byte[] bytes) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        String scrtKeyHex = Hex.toHexString((byte[])bytes);
        String ivStr = scrtKeyHex.substring(32);
        String keyStr = scrtKeyHex.substring(0, 32);
        byte[] iv = TextHexKit.decode(ivStr);
        byte[] key = TextHexKit.decode(keyStr);
        list.add(iv);
        list.add(key);
        return list;
    }

    public static String getRandomStr(int length) {
        String base = "0123456789qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static String getBase64Str() {
        String strByBase64 = SM4Util.getRandomStr(32);
        System.out.println("=================" + strByBase64);
        return Base64.toBase64String((byte[])strByBase64.getBytes(StandardCharsets.UTF_8));
    }
}

