/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.another;

import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.banks.spdb.dc.services.payment.another.MillisSequnce;
import kd.ebg.aqap.banks.spdb.dc.services.payment.another.PayContentUtils;
import kd.ebg.aqap.banks.spdb.dc.services.payment.another.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.PackerUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Attribute;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 500;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "AQ52";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"AQ52\u4ee3\u6536/\u4ee3\u4ed8\u4ea4\u6613\u63d0\u4ea4", (String)"PayImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return this.isSalary(info) && !Objects.equals(ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"PayImpl_2", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), info.getExplanation());
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo info = paymentInfos[0];
        String accNo = info.getAccNo();
        Element body = new Element("body");
        String payMasterID = BankBusinessConfig.getPayMasterID(accNo);
        if (StringUtils.isEmpty((String)payMasterID)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5ba2\u6237\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u5230\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PayImpl_3", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        String payChannelNo = BankBusinessConfig.getPayChannelNo(accNo);
        boolean unique = BankBusinessConfig.isUniqueChannelno(accNo);
        if (unique && StringUtils.isEmpty((String)payChannelNo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u652f\u4ed8\u6e20\u9053\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u5230\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PayImpl_4", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        String projectNumber = BankBusinessConfig.getProjectNumber(accNo);
        if (StringUtils.isEmpty((String)projectNumber)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u9879\u76ee\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u5230\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PayImpl_5", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        String projectName = BankBusinessConfig.getProjectName(accNo);
        if (StringUtils.isEmpty((String)projectName)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u5230\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PayImpl_6", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        String feeNo = BankBusinessConfig.getFeeNo(accNo);
        if (StringUtils.isEmpty((String)feeNo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u8d39\u9879\u4ee3\u7801\u4e3a\u7a7a\uff0c\u8bf7\u5230\u94f6\u4f01\u4e91\u7684'\u94f6\u4f01\u8d26\u6237'\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"PayImpl_7", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"transMasterID", (String)payMasterID);
        if (unique) {
            JDomUtils.addChild((Element)body, (String)"onlyChannelFlag", (String)"1");
            JDomUtils.addChild((Element)body, (String)"thirdChannelID", (String)payChannelNo);
        } else {
            JDomUtils.addChild((Element)body, (String)"onlyChannelFlag", (String)"0");
        }
        JDomUtils.addChild((Element)body, (String)"projectNumber", (String)projectNumber);
        JDomUtils.addChild((Element)body, (String)"projectName", (String)projectName);
        JDomUtils.addChild((Element)body, (String)"costItemCode", (String)feeNo);
        JDomUtils.addChild((Element)body, (String)"transType", (String)"2");
        JDomUtils.addChild((Element)body, (String)"totalNumber", (String)(paymentInfos.length + ""));
        JDomUtils.addChild((Element)body, (String)"totalAmount", (String)PackerUtils.getTotalAmount((PaymentInfo[])paymentInfos));
        JDomUtils.addChild((Element)body, (String)"elecChequeNo", (String)info.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"batchNo", (String)MillisSequnce.INSTANCE.getSequnce());
        Element lists = JDomUtils.addChild((Element)body, (String)"lists");
        lists.setAttribute(new Attribute("name", "LoopResult"));
        for (PaymentInfo paymentInfo : paymentInfos) {
            Element list = JDomUtils.addChild((Element)lists, (String)"list");
            String payContent = PayContentUtils.packPayContent(paymentInfo);
            JDomUtils.addChild((Element)list, (String)"detailedContent", (String)payContent);
        }
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg(this.getBizCode(), signedMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        BankResponse rsp = ParserRsp.parseRsp(responseStr);
        if ("EYY8968".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayImpl_8", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)"", (String)"");
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

