/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.payment.foreign;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "8932";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u8de8\u5883 \u540c\u6b65", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo info = paymentInfos[0];
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"entrustSeqNo", (String)Packer.getEntrustSeqNo(paymentInfos[0]));
        JDomUtils.addChild((Element)body, (String)"electronNumber", (String)"");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("8932", signedMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        BankResponse rsp = ParserRsp.parseRsp(responseStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            String rspData = Signature.getInstance().validateSignedData(responseStr);
            Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
            String backhostStatus = ParserUtils.getUnNullElementTextValue((Element)body, (String)"backhostStatus", (String)ResManager.loadKDString((String)"\u8bb0\u5f55\u72b6\u6001", (String)"QueryPayImpl_4", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
            if ("A".equalsIgnoreCase(backhostStatus) || "B".equalsIgnoreCase(backhostStatus) || "0".equalsIgnoreCase(backhostStatus) || "1".equalsIgnoreCase(backhostStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayImpl_5", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)backhostStatus, (String)"");
            } else if ("4".equalsIgnoreCase(backhostStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_6", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), (String)backhostStatus, (String)"");
            } else if ("8".equalsIgnoreCase(backhostStatus) || "9".equalsIgnoreCase(backhostStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)"", (String)backhostStatus, (String)"");
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u672a\u77e5'\u4ea4\u6613\u72b6\u6001'\u7801'%s',\u8bf7\u5411\u94f6\u884c\u6838\u5bf9\u8be5\u72b6\u6001\u3002", (String)"QueryPayImpl_27", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), backhostStatus), (String)backhostStatus, (String)"");
            }
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

