/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fjhxb.dc.services.payment.otherbank;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fjhxb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.fjhxb.dc.services.FJHXB_Packer;
import kd.ebg.aqap.banks.fjhxb.dc.services.FJHXB_Parser;
import kd.ebg.aqap.banks.fjhxb.dc.services.FJHXB_Util;
import kd.ebg.aqap.banks.fjhxb.dc.services.payment.otherbank.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)FJHXB_Packer.buildHead("B2ECrossBankTransfer", info.getBankBatchSeqId()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        Element List2 = JDomUtils.addChild((Element)body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
        JDomUtils.addChild((Element)Map2, (String)"PayerAcNo", (String)info.getAccNo());
        JDomUtils.addChild((Element)Map2, (String)"PayerCurrency", (String)info.getCurrency());
        JDomUtils.addChild((Element)Map2, (String)"PayerAcName", (String)info.getAccName());
        JDomUtils.addChild((Element)Map2, (String)"PayeeAcNo", (String)info.getIncomeAccNo());
        JDomUtils.addChild((Element)Map2, (String)"PayeeAcName", (String)info.getIncomeAccName());
        JDomUtils.addChild((Element)Map2, (String)"UnionDeptId", (String)info.getIncomeCnaps());
        JDomUtils.addChild((Element)Map2, (String)"DrecCode", (String)info.getIncomeCnaps());
        JDomUtils.addChild((Element)Map2, (String)"PayeeBankName", (String)info.getIncomeBankName());
        JDomUtils.addChild((Element)Map2, (String)"Currency", (String)info.getCurrency());
        JDomUtils.addChild((Element)Map2, (String)"Amount", (String)info.getAmount().toString());
        String exp = info.getExplanation();
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)info);
            exp = info.getBankDetailSeqId() + FJHXB_Util.KD_FLAG + exp;
        }
        JDomUtils.addChild((Element)Map2, (String)"Remark", (String)exp);
        JDomUtils.addChild((Element)Map2, (String)"AttachInfo", (String)info.getExplanation());
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element bank_root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse headRsp = FJHXB_Parser.parserCommonInfo(bank_root);
        String bankStatus = headRsp.getResponseCode();
        if (FJHXB_Util.SUCCESS_CODE.equalsIgnoreCase(bankStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2ECrossBankTransfer";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && !paymentInfo.is2SameBank();
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/B2ECrossBankTransfer.do?userPassword=" + RequestContextUtils.getBankParameterValue((String)"userPassword") + "&SIGDATA=1";
        factory.setUri(s);
        super.configFactory(factory);
    }
}

