/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fjhxb.dc.services.payment.salary;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fjhxb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.fjhxb.dc.services.FJHXB_Packer;
import kd.ebg.aqap.banks.fjhxb.dc.services.FJHXB_Parser;
import kd.ebg.aqap.banks.fjhxb.dc.services.FJHXB_Util;
import kd.ebg.aqap.banks.fjhxb.dc.services.payment.salary.SalaryQueryImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)FJHXB_Packer.buildHead("B2ESalaryPay", ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"PayerAcNo", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)body, (String)"SalEntNo", (String)BankBusinessConfig.getSalaryCode(((PaymentInfo)paymentInfos.get(0)).getAccNo()));
        JDomUtils.addChild((Element)body, (String)"TotalEmp", (String)Integer.toString(paymentInfos.size()));
        JDomUtils.addChild((Element)body, (String)"TotalAmount", (String)BigDecimalHelper.plain2((BigDecimal)this.calcTotalAmt(paymentInfos)));
        JDomUtils.addChild((Element)body, (String)"Remark", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation());
        Element List2 = JDomUtils.addChild((Element)body, (String)"List");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            PaymentInfo info = (PaymentInfo)paymentInfos.get(i);
            if (!info.is2SameBank()) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u4ee3\u53d1\u5de5\u8d44\u63a5\u53e3B2ESalaryPay\u53ea\u652f\u6301\u540c\u884c\u4ed8\u6b3e", (String)"SalaryPayImpl_0", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]));
            }
            Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
            JDomUtils.addChild((Element)Map2, (String)"EmpId", (String)Integer.toString(i + 1));
            JDomUtils.addChild((Element)Map2, (String)"EmpAcName", (String)info.getIncomeAccName());
            JDomUtils.addChild((Element)Map2, (String)"EmpAcNo", (String)info.getIncomeAccNo());
            JDomUtils.addChild((Element)Map2, (String)"EmpAmount", (String)info.getAmount().toString());
            JDomUtils.addChild((Element)Map2, (String)"Remark", (String)info.getExplanation());
        }
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    private BigDecimal calcTotalAmt(List<PaymentInfo> paymentInfos) {
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            total = BigDecimalHelper.add((BigDecimal)total, (BigDecimal)paymentInfos.get(i).getAmount());
        }
        return total;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element bank_root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse headRsp = FJHXB_Parser.parserCommonInfo(bank_root);
        String bankStatus = headRsp.getResponseCode();
        String BatchId = bank_root.getChild("Body").getChildText("BatchId");
        EBGBusinessUtils.setBankRefId((List)paymentInfos, (String)BatchId);
        if (FJHXB_Util.SUCCESS_CODE.equalsIgnoreCase(bankStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryPayImpl_1", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalaryPayImpl_2", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]), (String)bankStatus, (String)headRsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2ESalaryPay";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.getSubBizType().equalsIgnoreCase("pay_for_salary");
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/B2ESalaryPay.do?userPassword=" + RequestContextUtils.getBankParameterValue((String)"userPassword") + "&SIGDATA=1";
        factory.setUri(s);
        super.configFactory(factory);
    }
}

