/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.hkn;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dbs.hkn.BankBusinessConfig;
import kd.ebg.aqap.banks.dbs.hkn.services.balance.TodayBalanceImpl;
import kd.ebg.aqap.banks.dbs.hkn.services.detail.HisDetailImpl;
import kd.ebg.aqap.banks.dbs.hkn.services.detail.TodayDetailImpl;
import kd.ebg.aqap.banks.dbs.hkn.services.payment.inner.ACTPayImpl;
import kd.ebg.aqap.banks.dbs.hkn.services.payment.outer.RTGSPayment;
import kd.ebg.aqap.banks.dbs.hkn.services.payment.oversea.TTPayImpl;
import kd.ebg.aqap.banks.dbs.hkn.services.payment.querypay.QueryPayImpl;
import kd.ebg.aqap.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.aqap.common.framework.bank.meta.template.FBEMetaDataTemplate;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public class DbsDcMetaDataImpl
extends FBEMetaDataTemplate
implements BankMetaDataCollector {
    public static final String swiftBic = "swiftBic";
    public static final String dbsPgpPubKey = "dbs_pgp_pub_key";
    public static final String customPgpPriKey = "custom_pgp_pri_key";
    public static final String customPgpPriKeyPd = "customPgpPriKeyPd";
    public static final String balanceUri = "balanceUri";
    public static final String todayDetailUri = "todayDetailUri";
    public static final String hisDetailUri = "hisDetailUri";
    public static final String payUri = "payUri";
    public static final String queryPayUri = "queryPayUri";
    public static final String queryType = "queryType";

    public void baseConfigInit() {
        this.setExchangeProtocol("HTTPS");
        this.setTimeOut(3);
        this.setCharSet("UTF-8");
        this.setHost("enterprise-api.dbs.com");
        this.setPort(443);
        this.builder().ipName(new MultiLangEnumBridge("API\u63a5\u53e3\u7684IP\u6216\u57df\u540d", "DbsDcMetaDataImpl_0", "ebg-aqap-banks-dbs-hkn")).portName(new MultiLangEnumBridge("API\u63a5\u53e3\u7684\u7aef\u53e3\u53f7", "DbsDcMetaDataImpl_1", "ebg-aqap-banks-dbs-hkn")).build();
    }

    public List<BankLoginConfig> getBasicConfigSupplement() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)queryType, (MultiLangEnumBridge)new MultiLangEnumBridge("\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u63a5\u53e3\u65b9\u5f0f", "DbsDcMetaDataImpl_2", "ebg-aqap-banks-dbs-hkn"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u94f6\u884c\u63a8\u9001,\u5982\u8d85\u65f6\u672a\u63a8\u9001\u5219\u4e3b\u52a8\u8bf7\u6c42/\u4e3b\u52a8\u8bf7\u6c42", "DbsDcMetaDataImpl_3", "ebg-aqap-banks-dbs-hkn"), (List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u94f6\u884c\u63a8\u9001,\u5982\u8d85\u65f6\u672a\u63a8\u9001\u5219\u4e3b\u52a8\u8bf7\u6c42", "DbsDcMetaDataImpl_4", "ebg-aqap-banks-dbs-hkn"), new MultiLangEnumBridge("\u4e3b\u52a8\u8bf7\u6c42", "DbsDcMetaDataImpl_5", "ebg-aqap-banks-dbs-hkn")}), (List)Lists.newArrayList((Object[])new String[]{"push", "pull"}), (String)"push", (boolean)false, (boolean)false, (boolean)false)});
    }

    public void metaDataInit() {
        this.setBankName(ResManager.loadKDString((String)"\u661f\u5c55\u94f6\u884c", (String)"DbsDcMetaDataImpl_6", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]));
        this.setBankVersionID("DBS_HKN");
        this.setBankShortName("DBC");
        this.setBankVersionName(ResManager.loadKDString((String)"\u661f\u5c55\u94f6\u884c\uff08\u4e2d\u56fd\u9999\u6e2f\uff09\u76f4\u8054\u7248", (String)"DbsDcMetaDataImpl_7", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]));
        this.setDescription(ResManager.loadKDString((String)"\u661f\u5c55\u94f6\u884c\uff08\u4e2d\u56fd\u9999\u6e2f\uff09\u76f4\u8054\u7248", (String)"DbsDcMetaDataImpl_7", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]));
        this.setKeyNames(Lists.newArrayList());
    }

    public List<BankLoginConfig> getFrontProxyConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)"front_proxy_ip", (MultiLangEnumBridge)new MultiLangEnumBridge("\u91d1\u8776\u4ee3\u7406\u670d\u52a1IP\u5730\u5740", "DbsDcMetaDataImpl_8", "ebg-aqap-banks-dbs-hkn"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u91d1\u8776\u4ee3\u7406\u670d\u52a1\u6240\u5728IP\uff0c\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001\u6240\u9700,\u7531\u91d1\u8776\u65b9\u63d0\u4f9b\u90e8\u7f72\u7a0b\u5e8f", "DbsDcMetaDataImpl_9", "ebg-aqap-banks-dbs-hkn"), (String)"", (boolean)false, (boolean)true), BankLoginConfigUtil.getMlBankLoginConfig((String)"frontProxy_Port", (MultiLangEnumBridge)new MultiLangEnumBridge("\u91d1\u8776\u4ee3\u7406\u670d\u52a1\u7aef\u53e3\u53f7", "DbsDcMetaDataImpl_10", "ebg-aqap-banks-dbs-hkn"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u4ee3\u7406\u7a0b\u5e8f\u7684\u670d\u52a1\u7aef\u53e3\uff0c\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001\u6240\u9700,\u7531\u91d1\u8776\u65b9\u63d0\u4f9b\u90e8\u7f72\u7a0b\u5e8f", "DbsDcMetaDataImpl_11", "ebg-aqap-banks-dbs-hkn"), (String)"", (boolean)false, (boolean)true).set2Integer().set2MaxValueNum(65535)});
    }

    public List<BankLoginConfig> getBankLoginBanksConfig() {
        ArrayList basicConfigs = Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)swiftBic, (MultiLangEnumBridge)new MultiLangEnumBridge("SWIFT BIC CODE\uff08\u94f6\u884c\u63d0\u4f9b\uff09", "DbsDcMetaDataImpl_12", "ebg-aqap-banks-dbs-hkn"), (MultiLangEnumBridge)new MultiLangEnumBridge("SWIFT BIC CODE\uff08\u94f6\u884c\u63d0\u4f9b\uff09", "DbsDcMetaDataImpl_12", "ebg-aqap-banks-dbs-hkn"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)balanceUri, (MultiLangEnumBridge)new MultiLangEnumBridge("API\u63a5\u53e3\u67e5\u8be2\u4f59\u989d\u7684\u5730\u5740URL", "DbsDcMetaDataImpl_13", "ebg-aqap-banks-dbs-hkn"), (MultiLangEnumBridge)new MultiLangEnumBridge("API\u63a5\u53e3\u67e5\u8be2\u4f59\u989d\u7684\u5730\u5740URL", "DbsDcMetaDataImpl_13", "ebg-aqap-banks-dbs-hkn"), (String)"/api/rg/account/v4/enquiry/balance", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)todayDetailUri, (MultiLangEnumBridge)new MultiLangEnumBridge("API\u63a5\u53e3\u67e5\u8be2\u5f53\u65e5\u660e\u7ec6\u7684\u5730\u5740URL", "DbsDcMetaDataImpl_14", "ebg-aqap-banks-dbs-hkn"), (MultiLangEnumBridge)new MultiLangEnumBridge("API\u63a5\u53e3\u67e5\u8be2\u5f53\u65e5\u660e\u7ec6\u7684\u5730\u5740URL", "DbsDcMetaDataImpl_14", "ebg-aqap-banks-dbs-hkn"), (String)"/api/rg/account/v4/bankstatement/intraday", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)hisDetailUri, (MultiLangEnumBridge)new MultiLangEnumBridge("API\u63a5\u53e3\u67e5\u8be2\u5386\u53f2\u660e\u7ec6\u7684\u5730\u5740URL", "DbsDcMetaDataImpl_15", "ebg-aqap-banks-dbs-hkn"), (MultiLangEnumBridge)new MultiLangEnumBridge("API\u63a5\u53e3\u67e5\u8be2\u5386\u53f2\u660e\u7ec6\u7684\u5730\u5740URL", "DbsDcMetaDataImpl_15", "ebg-aqap-banks-dbs-hkn"), (String)"/api/rg/account/v4/bankstatement/eod", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)queryPayUri, (MultiLangEnumBridge)new MultiLangEnumBridge("API\u63a5\u53e3\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u63a5\u53e3\u7684\u5730\u5740URL", "DbsDcMetaDataImpl_16", "ebg-aqap-banks-dbs-hkn"), (MultiLangEnumBridge)new MultiLangEnumBridge("API\u63a5\u53e3\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u63a5\u53e3\u7684\u5730\u5740URL", "DbsDcMetaDataImpl_16", "ebg-aqap-banks-dbs-hkn"), (String)"/api/rg/remittance/v4/enquiry/transactionstatus", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)payUri, (MultiLangEnumBridge)new MultiLangEnumBridge("API\u63a5\u53e3(ACT/TT/CHATS)\u4ed8\u6b3e\u63a5\u53e3\u7684\u5730\u5740URL", "DbsDcMetaDataImpl_17", "ebg-aqap-banks-dbs-hkn"), (MultiLangEnumBridge)new MultiLangEnumBridge("API\u63a5\u53e3(ACT/TT/CHATS)\u4ed8\u6b3e\u63a5\u53e3\u7684\u5730\u5740URL", "DbsDcMetaDataImpl_17", "ebg-aqap-banks-dbs-hkn"), (String)"/api/hk/remittance/v4/payment/transaction", (boolean)false, (boolean)false)});
        basicConfigs.forEach(bankLoginConfig -> bankLoginConfig.setMaxLength(Integer.valueOf(256)));
        return basicConfigs;
    }

    public List<BankLoginConfig> getBankLoginConfig() {
        List<BankLoginConfig> loginConfigs = super.getBankLoginConfig();
        loginConfigs = loginConfigs.stream().filter(l -> !MetaDataConfigType.PGP_CONFIG.getName().equals(l.getType())).collect(Collectors.toList());
        List configs = this.getBankPGPConfig().stream().map(b -> {
            b.setType(MetaDataConfigType.PGP_CONFIG.getName());
            return b;
        }).collect(Collectors.toList());
        loginConfigs.addAll(configs);
        return loginConfigs;
    }

    private List<BankLoginConfig> getBankPGPConfig() {
        BankLoginConfig pgpPubKey = BankLoginConfigUtil.getMlBankLoginConfig((String)dbsPgpPubKey, (MultiLangEnumBridge)new MultiLangEnumBridge("PGP\u516c\u94a5", "DbsDcMetaDataImpl_18", "ebg-aqap-banks-dbs-hkn"), (String)"", (boolean)false, (boolean)false, (String)"upload");
        pgpPubKey.setMlDesc(new MultiLangEnumBridge("\u661f\u5c55\u94f6\u884cPGP\u516c\u94a5\uff0c\u7531\u94f6\u884c\u63d0\u4f9b", "DbsDcMetaDataImpl_19", "ebg-aqap-banks-dbs-hkn"));
        BankLoginConfig pgpPriKey = BankLoginConfigUtil.getMlBankLoginConfig((String)customPgpPriKey, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5ba2\u6237PGP\u79c1\u94a5", "DbsDcMetaDataImpl_20", "ebg-aqap-banks-dbs-hkn"), (String)"", (boolean)false, (boolean)false, (String)"upload");
        pgpPriKey.setMlDesc(new MultiLangEnumBridge("\u901a\u8fc7\u5de5\u5177\u751f\u6210PGP\u8bc1\u4e66\uff0c\u516c\u94a5\u63d0\u4f9b\u7ed9\u94f6\u884c\uff0c\u79c1\u94a5\u5728\u8fd9\u91cc\u4e0a\u4f20\uff1b\u4e0e\u79c1\u94a5\u5bc6\u7801\u9700\u914d\u5957\u3002", "DbsDcMetaDataImpl_21", "ebg-aqap-banks-dbs-hkn"));
        BankLoginConfig pgpPriKeyPd = BankLoginConfigUtil.getMlBankLoginConfig((String)customPgpPriKeyPd, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5ba2\u6237PGP\u79c1\u94a5\u5bc6\u7801", "DbsDcMetaDataImpl_22", "ebg-aqap-banks-dbs-hkn"), (String)"", (boolean)false, (boolean)false, (String)"password");
        pgpPriKeyPd.setMlDesc(new MultiLangEnumBridge("\u901a\u8fc7\u5de5\u5177\u751f\u6210\u7684PGP\u8bc1\u4e66\u7684\u79c1\u94a5\u5bc6\u7801", "DbsDcMetaDataImpl_23", "ebg-aqap-banks-dbs-hkn"));
        return Lists.newArrayList((Object[])new BankLoginConfig[]{pgpPubKey, pgpPriKey, pgpPriKeyPd});
    }

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{TodayBalanceImpl.class, TodayDetailImpl.class, HisDetailImpl.class, ACTPayImpl.class, RTGSPayment.class, TTPayImpl.class, QueryPayImpl.class});
    }

    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList();
    }

    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList();
    }

    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }

    public boolean isDetailSupportMultiCurrency() {
        return true;
    }
}

